/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.client.gui;

import com.google.common.collect.Lists;
import com.mrcrayfish.vehicle.VehicleConfig;
import com.mrcrayfish.vehicle.client.gui.GuiCheckBox;
import com.mrcrayfish.vehicle.common.container.ContainerWorkstation;
import com.mrcrayfish.vehicle.common.entity.PartPosition;
import com.mrcrayfish.vehicle.crafting.VehicleRecipes;
import com.mrcrayfish.vehicle.entity.EngineTier;
import com.mrcrayfish.vehicle.entity.EngineType;
import com.mrcrayfish.vehicle.entity.EntityPoweredVehicle;
import com.mrcrayfish.vehicle.entity.EntityVehicle;
import com.mrcrayfish.vehicle.entity.VehicleProperties;
import com.mrcrayfish.vehicle.entity.WheelType;
import com.mrcrayfish.vehicle.item.ItemEngine;
import com.mrcrayfish.vehicle.item.ItemWheel;
import com.mrcrayfish.vehicle.network.PacketHandler;
import com.mrcrayfish.vehicle.network.message.MessageCraftVehicle;
import com.mrcrayfish.vehicle.tileentity.TileEntityWorkstation;
import com.mrcrayfish.vehicle.util.InventoryUtil;
import com.mrcrayfish.vehicle.util.MouseHelper;
import java.awt.Color;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;

public class GuiWorkstation
extends GuiContainer {
    private static final ResourceLocation GUI = new ResourceLocation("vehicle:textures/gui/workstation.png");
    private List<MaterialItem> materials;
    private List<MaterialItem> filteredMaterials;
    private static int currentVehicle = 0;
    private static int prevCurrentVehicle = 0;
    private static boolean showRemaining = false;
    private EntityVehicle[] cachedVehicle;
    private IInventory playerInventory;
    private TileEntityWorkstation workstation;
    private GuiButton btnCraft;
    private GuiCheckBox checkBoxMaterials;
    private boolean validEngine;
    private boolean transitioning;
    private int vehicleScale = 30;
    private int prevVehicleScale = 30;

    public GuiWorkstation(IInventory playerInventory, TileEntityWorkstation workstation) {
        super((Container)new ContainerWorkstation(playerInventory, workstation));
        this.playerInventory = playerInventory;
        this.workstation = workstation;
        this.field_146999_f = 289;
        this.field_147000_g = 202;
        this.materials = new ArrayList<MaterialItem>();
        this.cachedVehicle = new EntityVehicle[VehicleRecipes.getVehicleCount()];
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int startX = (this.field_146294_l - this.field_146999_f) / 2;
        int startY = (this.field_146295_m - this.field_147000_g) / 2;
        this.field_146292_n.add(new GuiButton(1, startX, startY, 15, 20, "<"));
        this.field_146292_n.add(new GuiButton(2, startX + 161, startY, 15, 20, ">"));
        this.btnCraft = new GuiButton(3, startX + 186, startY + 6, 97, 20, "Craft");
        this.field_146292_n.add(this.btnCraft);
        this.btnCraft.field_146124_l = false;
        this.checkBoxMaterials = new GuiCheckBox(186, 51, "Show Remaining");
        this.checkBoxMaterials.setToggled(showRemaining);
        this.loadVehicle(currentVehicle);
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.validEngine = true;
        for (MaterialItem materialItem : this.materials) {
            materialItem.update();
        }
        boolean canCraft = true;
        for (MaterialItem material : this.materials) {
            if (material.isEnabled()) continue;
            canCraft = false;
            break;
        }
        if (this.cachedVehicle[currentVehicle] instanceof EntityPoweredVehicle) {
            EntityPoweredVehicle entityPoweredVehicle = (EntityPoweredVehicle)this.cachedVehicle[currentVehicle];
            if (entityPoweredVehicle.getEngineType() != EngineType.NONE) {
                ItemStack engine = this.workstation.func_70301_a(1);
                if (!engine.func_190926_b() && engine.func_77973_b() instanceof ItemEngine) {
                    EngineType engineType = ((ItemEngine)engine.func_77973_b()).getEngineType();
                    if (entityPoweredVehicle.getEngineType() != engineType) {
                        canCraft = false;
                        this.validEngine = false;
                        entityPoweredVehicle.setEngine(false);
                    } else {
                        entityPoweredVehicle.setEngineTier(EngineTier.getType(engine.func_77952_i()));
                        entityPoweredVehicle.setEngine(true);
                        entityPoweredVehicle.func_184206_a(EntityPoweredVehicle.ENGINE_TIER);
                    }
                } else {
                    canCraft = false;
                    this.validEngine = false;
                    entityPoweredVehicle.setEngine(false);
                }
            }
            if (entityPoweredVehicle.canChangeWheels()) {
                ItemStack wheels = this.workstation.func_70301_a(2);
                if (!wheels.func_190926_b() && wheels.func_77973_b() instanceof ItemWheel) {
                    NBTTagCompound tagCompound;
                    if (wheels.func_77978_p() != null && (tagCompound = wheels.func_77978_p()).func_150297_b("color", 3)) {
                        entityPoweredVehicle.setWheelColor(tagCompound.func_74762_e("color"));
                    }
                    entityPoweredVehicle.setWheelType(WheelType.values()[wheels.func_77952_i()]);
                    entityPoweredVehicle.setWheels(true);
                    entityPoweredVehicle.func_184206_a(EntityPoweredVehicle.WHEEL_COLOR);
                } else {
                    entityPoweredVehicle.setWheels(false);
                    canCraft = false;
                }
            }
        }
        this.btnCraft.field_146124_l = canCraft;
        this.prevVehicleScale = this.vehicleScale;
        if (this.transitioning) {
            if (this.vehicleScale > 0) {
                this.vehicleScale = Math.max(0, this.vehicleScale - 6);
            } else {
                this.transitioning = false;
            }
        } else if (this.vehicleScale < 30) {
            this.vehicleScale = Math.min(30, this.vehicleScale + 6);
        }
        if (this.cachedVehicle[currentVehicle].canBeColored()) {
            if (!this.workstation.func_70301_a(0).func_190926_b()) {
                ItemStack itemStack = this.workstation.func_70301_a(0);
                if (itemStack.func_77973_b() == Items.field_151100_aR) {
                    this.cachedVehicle[currentVehicle].setColor(EntityVehicle.DYE_TO_COLOR[15 - itemStack.func_77960_j()]);
                } else {
                    this.cachedVehicle[currentVehicle].setColor(EntityVehicle.DYE_TO_COLOR[0]);
                }
            } else {
                this.cachedVehicle[currentVehicle].setColor(EntityVehicle.DYE_TO_COLOR[0]);
            }
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        int startX = (this.field_146294_l - this.field_146999_f) / 2;
        int startY = (this.field_146295_m - this.field_147000_g) / 2;
        this.checkBoxMaterials.handleClick(startX, startY, mouseX, mouseY, mouseButton);
        showRemaining = this.checkBoxMaterials.isToggled();
    }

    protected void func_146284_a(GuiButton button) {
        ResourceLocation registryName;
        EntityEntry entry;
        if (button.field_146127_k == 1) {
            if (currentVehicle - 1 < 0) {
                this.loadVehicle(VehicleRecipes.getVehicleCount() - 1);
            } else {
                this.loadVehicle(currentVehicle - 1);
            }
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
        } else if (button.field_146127_k == 2) {
            if (currentVehicle + 1 >= VehicleRecipes.getVehicleCount()) {
                this.loadVehicle(0);
            } else {
                this.loadVehicle(currentVehicle + 1);
            }
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
        } else if (button.field_146127_k == 3 && (entry = EntityRegistry.getEntry(((Object)((Object)this.cachedVehicle[currentVehicle])).getClass())) != null && (registryName = entry.getRegistryName()) != null) {
            MessageCraftVehicle message = new MessageCraftVehicle(registryName.toString(), this.workstation.func_174877_v());
            PacketHandler.INSTANCE.sendToServer((IMessage)message);
        }
    }

    private void loadVehicle(int index) {
        prevCurrentVehicle = currentVehicle;
        try {
            if (this.cachedVehicle[index] == null) {
                EntityVehicle vehicle = VehicleRecipes.getVehicleClasses().get(index).getDeclaredConstructor(World.class).newInstance(Minecraft.func_71410_x().field_71441_e);
                List entryList = vehicle.func_184212_Q().func_187231_c();
                if (entryList != null) {
                    entryList.forEach(dataEntry -> vehicle.func_184206_a(dataEntry.func_187205_a()));
                }
                if (vehicle instanceof EntityPoweredVehicle) {
                    ((EntityPoweredVehicle)vehicle).setEngine(false);
                    ((EntityPoweredVehicle)vehicle).setWheels(false);
                }
                this.cachedVehicle[index] = vehicle;
            }
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
        this.materials.clear();
        VehicleRecipes.VehicleRecipe recipe = VehicleRecipes.getRecipe(((Object)((Object)this.cachedVehicle[index])).getClass());
        for (int i = 0; i < recipe.getMaterials().size(); ++i) {
            MaterialItem item = new MaterialItem((ItemStack)recipe.getMaterials().get(i));
            item.update();
            this.materials.add(item);
        }
        currentVehicle = index;
        if (VehicleConfig.CLIENT.display.workstationAnimation && prevCurrentVehicle != currentVehicle) {
            this.transitioning = true;
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
        int startX = (this.field_146294_l - this.field_146999_f) / 2;
        int startY = (this.field_146295_m - this.field_147000_g) / 2;
        for (int i = 0; i < this.filteredMaterials.size(); ++i) {
            MaterialItem materialItem;
            int itemX = startX + 186;
            int itemY = startY + i * 19 + 6 + 57;
            if (!MouseHelper.isMouseWithin(mouseX, mouseY, itemX, itemY, 80, 19) || (materialItem = this.filteredMaterials.get(i)).getStack().func_190926_b()) continue;
            this.func_146285_a(materialItem.getStack(), mouseX, mouseY);
        }
        EntityVehicle vehicle = this.cachedVehicle[currentVehicle];
        if (vehicle.canBeColored()) {
            this.drawSlotTooltip(Lists.newArrayList((Object[])new String[]{TextFormatting.AQUA + I18n.func_135052_a((String)"vehicle.tooltip.optional", (Object[])new Object[0]), TextFormatting.GRAY + I18n.func_135052_a((String)"vehicle.tooltip.paint_color", (Object[])new Object[0])}), startX, startY, 186, 29, mouseX, mouseY, 0);
        } else {
            this.drawSlotTooltip(Lists.newArrayList((Object[])new String[]{I18n.func_135052_a((String)"vehicle.tooltip.paint_color", (Object[])new Object[0]), TextFormatting.GRAY + I18n.func_135052_a((String)"vehicle.tooltip.not_applicable", (Object[])new Object[0])}), startX, startY, 186, 29, mouseX, mouseY, 0);
        }
        if (vehicle instanceof EntityPoweredVehicle && ((EntityPoweredVehicle)vehicle).getEngineType() != EngineType.NONE) {
            String engineName = ((EntityPoweredVehicle)vehicle).getEngineType().getEngineName();
            this.drawSlotTooltip(Lists.newArrayList((Object[])new String[]{TextFormatting.RED + I18n.func_135052_a((String)"vehicle.tooltip.required", (Object[])new Object[0]), TextFormatting.GRAY + engineName}), startX, startY, 206, 29, mouseX, mouseY, 1);
        } else {
            this.drawSlotTooltip(Lists.newArrayList((Object[])new String[]{I18n.func_135052_a((String)"vehicle.tooltip.engine", (Object[])new Object[0]), TextFormatting.GRAY + I18n.func_135052_a((String)"vehicle.tooltip.not_applicable", (Object[])new Object[0])}), startX, startY, 206, 29, mouseX, mouseY, 1);
        }
        if (vehicle instanceof EntityPoweredVehicle && ((EntityPoweredVehicle)vehicle).canChangeWheels()) {
            this.drawSlotTooltip(Lists.newArrayList((Object[])new String[]{TextFormatting.RED + I18n.func_135052_a((String)"vehicle.tooltip.required", (Object[])new Object[0]), TextFormatting.GRAY + I18n.func_135052_a((String)"vehicle.tooltip.wheels", (Object[])new Object[0])}), startX, startY, 226, 29, mouseX, mouseY, 2);
        } else {
            this.drawSlotTooltip(Lists.newArrayList((Object[])new String[]{I18n.func_135052_a((String)"vehicle.tooltip.wheels", (Object[])new Object[0]), TextFormatting.GRAY + I18n.func_135052_a((String)"vehicle.tooltip.not_applicable", (Object[])new Object[0])}), startX, startY, 226, 29, mouseX, mouseY, 2);
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        partialTicks = Minecraft.func_71410_x().func_184121_ak();
        this.func_146276_q_();
        int startX = (this.field_146294_l - this.field_146999_f) / 2;
        int startY = (this.field_146295_m - this.field_147000_g) / 2;
        GlStateManager.func_179147_l();
        this.field_146297_k.func_110434_K().func_110577_a(GUI);
        this.func_73729_b(startX, startY + 80, 0, 134, 176, 122);
        this.func_73729_b(startX + 180, startY, 176, 54, 6, 202);
        this.func_73729_b(startX + 186, startY, 182, 54, 57, 202);
        this.func_73729_b(startX + 186 + 57, startY, 220, 54, 23, 202);
        this.func_73729_b(startX + 186 + 57 + 23, startY, 220, 54, 3, 202);
        this.func_73729_b(startX + 186 + 57 + 23 + 3, startY, 236, 54, 20, 202);
        this.drawSlot(startX, startY, 186, 29, 80, 0, 0, false, this.cachedVehicle[currentVehicle].canBeColored());
        boolean needsEngine = this.cachedVehicle[currentVehicle] instanceof EntityPoweredVehicle && ((EntityPoweredVehicle)this.cachedVehicle[currentVehicle]).getEngineType() != EngineType.NONE;
        this.drawSlot(startX, startY, 206, 29, 80, 16, 1, !this.validEngine, needsEngine);
        boolean needsWheels = this.cachedVehicle[currentVehicle] instanceof EntityPoweredVehicle && ((EntityPoweredVehicle)this.cachedVehicle[currentVehicle]).canChangeWheels();
        this.drawSlot(startX, startY, 226, 29, 80, 32, 2, needsWheels && this.workstation.func_70301_a(2).func_190926_b(), needsWheels);
        this.checkBoxMaterials.draw(this.field_146297_k, this.field_147003_i, this.field_147009_r);
        this.func_73732_a(this.field_146289_q, this.cachedVehicle[currentVehicle].func_70005_c_(), startX + 88, startY + 6, Color.WHITE.getRGB());
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)(startX + 88), (float)(startY + 90), (float)100.0f);
        float scale = (float)this.prevVehicleScale + (float)(this.vehicleScale - this.prevVehicleScale) * partialTicks;
        GlStateManager.func_179152_a((float)scale, (float)(-scale), (float)scale);
        GlStateManager.func_179114_b((float)5.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)Minecraft.func_71410_x().field_71439_g.field_70173_aa + partialTicks), (float)0.0f, (float)1.0f, (float)0.0f);
        int vehicleIndex = this.transitioning ? prevCurrentVehicle : currentVehicle;
        Class<?> clazz = ((Object)((Object)this.cachedVehicle[vehicleIndex])).getClass();
        PartPosition position = VehicleProperties.getProperties(VehicleRecipes.getVehicleClasses().get(vehicleIndex)).getDisplayPosition();
        if (position != null) {
            GlStateManager.func_179139_a((double)position.getScale(), (double)position.getScale(), (double)position.getScale());
            GlStateManager.func_179114_b((float)((float)position.getRotX()), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)((float)position.getRotY()), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)((float)position.getRotZ()), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179137_b((double)position.getX(), (double)position.getY(), (double)position.getZ());
        }
        Render render = Minecraft.func_71410_x().func_175598_ae().func_78715_a(clazz);
        render.func_76986_a((Entity)this.cachedVehicle[vehicleIndex], 0.0, 0.0, 0.0, 0.0f, 0.0f);
        GlStateManager.func_179121_F();
        this.filteredMaterials = this.getMaterials();
        for (int i = 0; i < this.filteredMaterials.size(); ++i) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_146297_k.func_110434_K().func_110577_a(GUI);
            MaterialItem materialItem = this.filteredMaterials.get(i);
            ItemStack stack = materialItem.stack;
            if (stack.func_190926_b()) {
                RenderHelper.func_74518_a();
                this.func_73729_b(startX + 186, startY + i * 19 + 6 + 57, 0, 19, 80, 19);
                continue;
            }
            RenderHelper.func_74518_a();
            if (materialItem.isEnabled()) {
                this.func_73729_b(startX + 186, startY + i * 19 + 6 + 57, 0, 0, 80, 19);
            } else {
                this.func_73729_b(startX + 186, startY + i * 19 + 6 + 57, 0, 38, 80, 19);
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            String name = stack.func_82833_r();
            if (this.field_146289_q.func_78256_a(name) > 55) {
                name = this.field_146289_q.func_78269_a(stack.func_82833_r(), 50).trim() + "...";
            }
            this.field_146289_q.func_78276_b(name, startX + 186 + 22, startY + i * 19 + 6 + 6 + 57, Color.WHITE.getRGB());
            RenderHelper.func_74520_c();
            Minecraft.func_71410_x().func_175599_af().func_180450_b(stack, startX + 186 + 2, startY + i * 19 + 6 + 1 + 57);
            if (this.checkBoxMaterials.isToggled()) {
                int count = InventoryUtil.getItemStackAmount((EntityPlayer)Minecraft.func_71410_x().field_71439_g, stack);
                stack = stack.func_77946_l();
                stack.func_190920_e(stack.func_190916_E() - count);
            }
            Minecraft.func_71410_x().func_175599_af().func_180453_a(this.field_146289_q, stack, startX + 186 + 2, startY + i * 19 + 6 + 1 + 57, null);
        }
    }

    private void drawSlot(int startX, int startY, int x, int y, int iconX, int iconY, int slot, boolean required, boolean applicable) {
        int textureOffset = required ? 18 : 0;
        this.func_73729_b(startX + x, startY + y, 128 + textureOffset, 0, 18, 18);
        if (this.workstation.func_70301_a(slot).func_190926_b()) {
            if (applicable) {
                this.func_73729_b(startX + x + 1, startY + y + 1, iconX + (required ? 16 : 0), iconY, 16, 16);
            } else {
                this.func_73729_b(startX + x + 1, startY + y + 1, iconX + (required ? 16 : 0), 48, 16, 16);
            }
        }
    }

    private void drawSlotTooltip(List<String> text, int startX, int startY, int x, int y, int mouseX, int mouseY, int slot) {
        if (this.workstation.func_70301_a(slot).func_190926_b() && MouseHelper.isMouseWithin(mouseX, mouseY, startX + x, startY + y, 18, 18)) {
            this.drawHoveringText(text, mouseX, mouseY, this.field_146297_k.field_71466_p);
        }
    }

    private List<MaterialItem> getMaterials() {
        NonNullList materials = NonNullList.func_191197_a((int)7, (Object)((Object)new MaterialItem(ItemStack.field_190927_a)));
        List filteredMaterials = this.materials.stream().filter(materialItem -> this.checkBoxMaterials.isToggled() ? !materialItem.isEnabled() : !((MaterialItem)materialItem).stack.func_190926_b()).collect(Collectors.toList());
        for (int i = 0; i < filteredMaterials.size() && i < materials.size(); ++i) {
            materials.set(i, filteredMaterials.get(i));
        }
        return materials;
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(this.playerInventory.func_145748_c_().func_150260_c(), 8, 109, 0x404040);
    }

    public static class MaterialItem
    extends Gui {
        public static final MaterialItem EMPTY = new MaterialItem();
        private boolean enabled = false;
        private ItemStack stack = ItemStack.field_190927_a;

        public MaterialItem() {
        }

        public MaterialItem(ItemStack stack) {
            this.stack = stack;
        }

        public ItemStack getStack() {
            return this.stack;
        }

        public void update() {
            if (!this.stack.func_190926_b()) {
                this.enabled = InventoryUtil.hasItemStack((EntityPlayer)Minecraft.func_71410_x().field_71439_g, this.stack);
            }
        }

        public boolean isEnabled() {
            return this.stack.func_190926_b() || this.enabled;
        }
    }
}

