/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.client.util;

import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;

public class BakedQuadBuilder {
    private UnpackedBakedQuad.Builder builder;
    private EnumFacing facing = null;
    private TextureAtlasSprite texture;

    public BakedQuadBuilder(VertexFormat format) {
        this.builder = new UnpackedBakedQuad.Builder(format);
    }

    public void setFacing(EnumFacing facing) {
        this.facing = facing;
        this.builder.setQuadOrientation(facing);
    }

    public EnumFacing getFacing() {
        return this.facing;
    }

    public void setTexture(TextureAtlasSprite texture) {
        this.texture = texture;
        this.builder.setTexture(texture);
    }

    public BakedQuad build() {
        UnpackedBakedQuad quad = this.builder.build();
        this.builder = new UnpackedBakedQuad.Builder(this.builder.getVertexFormat());
        this.builder.setQuadOrientation(this.facing);
        this.builder.setTexture(this.texture);
        return quad;
    }

    public BakedQuadBuilder put(VertexData data, EnumFacing side) {
        data = this.rotate(data);
        VertexFormat format = this.builder.getVertexFormat();
        block6: for (int e = 0; e < this.builder.getVertexFormat().func_177345_h(); ++e) {
            switch (format.func_177348_c(e).func_177375_c()) {
                case POSITION: {
                    this.builder.put(e, new float[]{data.x, data.y, data.z, 1.0f});
                    continue block6;
                }
                case COLOR: {
                    this.builder.put(e, new float[]{1.0f, 1.0f, 1.0f, 1.0f});
                    continue block6;
                }
                case UV: {
                    if (format.func_177348_c(e).func_177369_e() == 0) {
                        float u = this.texture.func_94214_a((double)data.u);
                        float v = this.texture.func_94207_b((double)data.v);
                        this.builder.put(e, new float[]{u, v, 0.0f, 1.0f});
                        continue block6;
                    }
                }
                case NORMAL: {
                    this.builder.put(e, new float[]{side.func_82601_c(), side.func_96559_d(), side.func_82599_e(), 0.0f});
                    continue block6;
                }
                default: {
                    this.builder.put(e, new float[0]);
                }
            }
        }
        return this;
    }

    public VertexData rotate(VertexData data) {
        if (this.facing != null) {
            switch (this.facing) {
                case WEST: {
                    data.x = 1.0f - data.x;
                    data.z = 1.0f - data.z;
                    break;
                }
                case NORTH: {
                    data.x = 1.0f - data.x;
                    float oldX = data.x;
                    data.x = data.z;
                    data.z = oldX;
                    break;
                }
                case SOUTH: {
                    data.z = 1.0f - data.z;
                    float oldZ = data.z;
                    data.z = data.x;
                    data.x = oldZ;
                    break;
                }
            }
        }
        return data;
    }

    public static class VertexData {
        private float x;
        private float y;
        private float z;
        private float u;
        private float v;

        public VertexData(float x, float y, float z, float u, float v) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.u = u;
            this.v = v;
        }
    }
}

