/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.tileentity;

import com.mrcrayfish.vehicle.block.BlockFluidExtractor;
import com.mrcrayfish.vehicle.crafting.FluidExtract;
import com.mrcrayfish.vehicle.crafting.FluidExtractorRecipes;
import com.mrcrayfish.vehicle.util.FluidUtils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.server.management.PlayerChunkMapEntry;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.TileFluidHandler;

public class TileEntityFluidExtractor
extends TileFluidHandler
implements IInventory,
ITickable {
    private NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)7, (Object)ItemStack.field_190927_a);
    public static final int TANK_CAPACITY = 5000;
    public static final int FLUID_MAX_PROGRESS = 600;
    private static final int SLOT_FUEL_SOURCE = 0;
    private static final int SLOT_FLUID_SOURCE = 1;
    private int remainingFuel;
    private int fuelMaxProgress;
    private int extractionProgress;
    private String customName;

    public TileEntityFluidExtractor() {
        this.tank = new FluidTank(5000);
        this.tank.setCanFill(false);
        this.tank.setCanDrain(true);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            ItemStack source = this.func_70301_a(1);
            ItemStack fuel = this.func_70301_a(0);
            if (!fuel.func_190926_b() && !source.func_190926_b() && this.remainingFuel == 0 && this.canFillWithFluid(source)) {
                this.remainingFuel = this.fuelMaxProgress = TileEntityFurnace.func_145952_a((ItemStack)fuel);
                this.shrinkItem(0);
            }
            if (!source.func_190926_b() && this.canFillWithFluid(source) && this.remainingFuel > 0) {
                if (this.extractionProgress++ == 600) {
                    FluidExtract extract = FluidExtractorRecipes.getInstance().getRecipeResult(source);
                    if (extract != null) {
                        this.tank.fillInternal(extract.createStack(), true);
                    }
                    this.extractionProgress = 0;
                    this.shrinkItem(1);
                    this.sendUpdate(this.wrap("fluidLevel", this.tank.getFluidAmount()));
                }
            } else {
                this.extractionProgress = 0;
            }
            if (this.remainingFuel > 0 && this.canFillWithFluid(source)) {
                --this.remainingFuel;
            }
        }
    }

    private boolean canFillWithFluid(ItemStack stack) {
        FluidExtract extract;
        if (!stack.func_190926_b() && this.tank.getFluidAmount() < this.tank.getCapacity() && (extract = this.getFluidExtractSource()) != null) {
            return this.tank.getFluid() == null || extract.getFluid() == this.tank.getFluid().getFluid();
        }
        return false;
    }

    @Nullable
    public FluidStack getFluidStackTank() {
        return this.tank.getFluid();
    }

    @Nullable
    public FluidExtract getFluidExtractSource() {
        return FluidExtractorRecipes.getInstance().getRecipeResult(this.func_70301_a(1));
    }

    public int func_70302_i_() {
        return 2;
    }

    public boolean func_191420_l() {
        for (ItemStack stack : this.inventory) {
            if (stack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.inventory.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack stack = ItemStackHelper.func_188382_a(this.inventory, (int)index, (int)count);
        if (!stack.func_190926_b()) {
            this.func_70296_d();
        }
        return stack;
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.inventory, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inventory.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        this.func_70296_d();
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this && player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (index == 0) {
            return TileEntityFurnace.func_145952_a((ItemStack)stack) > 0;
        }
        if (index == 1) {
            return FluidExtractorRecipes.getInstance().getRecipeResult(stack) != null;
        }
        return false;
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.extractionProgress;
            }
            case 1: {
                return this.remainingFuel;
            }
            case 2: {
                return this.fuelMaxProgress;
            }
            case 3: {
                return this.tank.getFluidAmount();
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.extractionProgress = value;
                break;
            }
            case 1: {
                this.remainingFuel = value;
                break;
            }
            case 2: {
                this.fuelMaxProgress = value;
                break;
            }
            case 3: {
                if (this.tank.getFluid() == null) break;
                this.tank.getFluid().amount = value;
            }
        }
    }

    public int func_174890_g() {
        return 4;
    }

    public void func_174888_l() {
        this.inventory.clear();
    }

    public int getExtractionProgress() {
        return this.func_174887_a_(0);
    }

    public int getRemainingFuel() {
        return this.func_174887_a_(1);
    }

    public int getFuelMaxProgress() {
        return this.func_174887_a_(2);
    }

    public int getFluidLevel() {
        return this.func_174887_a_(3);
    }

    public void func_145839_a(NBTTagCompound tag) {
        FluidUtils.fixEmptyTag(tag);
        super.func_145839_a(tag);
        if (tag.func_150297_b("ExtractionProgress", 3)) {
            this.extractionProgress = tag.func_74762_e("ExtractionProgress");
        }
        if (tag.func_150297_b("RemainingFuel", 3)) {
            this.remainingFuel = tag.func_74762_e("RemainingFuel");
        }
        if (tag.func_150297_b("FuelMaxProgress", 3)) {
            this.fuelMaxProgress = tag.func_74762_e("FuelMaxProgress");
        }
        if (tag.func_150297_b("FluidLevel", 3) && this.tank.getFluid() != null) {
            this.tank.getFluid().amount = tag.func_74762_e("FluidLevel");
        }
        if (tag.func_150297_b("Items", 9)) {
            this.inventory = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
            ItemStackHelper.func_191283_b((NBTTagCompound)tag, this.inventory);
        }
        if (tag.func_150297_b("CustomName", 8)) {
            this.customName = tag.func_74779_i("CustomName");
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74768_a("ExtractionProgress", this.extractionProgress);
        tag.func_74768_a("RemainingFuel", this.remainingFuel);
        tag.func_74768_a("FuelMaxProgress", this.fuelMaxProgress);
        ItemStackHelper.func_191282_a((NBTTagCompound)tag, this.inventory);
        if (this.func_145818_k_()) {
            tag.func_74778_a("CustomName", this.customName);
        }
        return tag;
    }

    private void sendUpdate(NBTTagCompound tag) {
        WorldServer server;
        PlayerChunkMapEntry entry;
        if (!this.field_145850_b.field_72995_K && this.field_145850_b instanceof WorldServer && (entry = (server = (WorldServer)this.field_145850_b).func_184164_w().func_187301_b(this.field_174879_c.func_177958_n() >> 4, this.field_174879_c.func_177952_p() >> 4)) != null) {
            NBTTagCompound tagCompound = super.func_189515_b(new NBTTagCompound());
            tagCompound.func_179237_a(tag);
            SPacketUpdateTileEntity packet = new SPacketUpdateTileEntity(this.field_174879_c, 0, tagCompound);
            entry.func_187267_a((Packet)packet);
        }
    }

    public void syncFluidLevelToClients() {
        this.sendUpdate(this.wrap("FluidLevel", this.tank.getFluidAmount()));
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.customName : "container.fluid_extractor";
    }

    public boolean func_145818_k_() {
        return this.customName != null && !this.customName.isEmpty();
    }

    public ITextComponent func_145748_c_() {
        return this.func_145818_k_() ? new TextComponentString(this.func_70005_c_()) : new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
    }

    private NBTTagCompound wrap(String key, int value) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a(key, value);
        return tag;
    }

    private void shrinkItem(int index) {
        ItemStack stack = this.func_70301_a(index);
        stack.func_190918_g(1);
        if (stack.func_190926_b()) {
            this.func_70299_a(index, ItemStack.field_190927_a);
        }
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        IBlockState state;
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && ((EnumFacing)(state = this.field_145850_b.func_180495_p(this.field_174879_c)).func_177229_b((IProperty)BlockFluidExtractor.FACING)).func_176734_d() == facing) {
            return false;
        }
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (!this.hasCapability(capability, facing)) {
            return null;
        }
        return (T)super.getCapability(capability, facing);
    }
}

