/*
 * Decompiled with CFR 0.152.
 */
package fluxnetworks.client.gui.tab;

import fluxnetworks.api.gui.EnumNavigationTabs;
import fluxnetworks.api.network.INetworkConnector;
import fluxnetworks.api.network.NetworkSettings;
import fluxnetworks.api.translate.FluxTranslate;
import fluxnetworks.api.utils.NBTType;
import fluxnetworks.client.gui.LineChart;
import fluxnetworks.client.gui.basic.GuiTabCore;
import fluxnetworks.common.connection.NetworkStatistics;
import fluxnetworks.common.core.FluxUtils;
import fluxnetworks.common.handler.PacketHandler;
import fluxnetworks.common.network.PacketNetworkUpdateRequest;
import fluxnetworks.common.registry.RegistryBlocks;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiTabStatistics
extends GuiTabCore {
    private NetworkStatistics stats;
    private LineChart chart;
    private int timer;
    private static NBTTagCompound GUI_COLOR_TAG = new NBTTagCompound();
    private static ItemStack plug;
    private static ItemStack point;
    private static ItemStack storage;
    private static ItemStack controller;

    public GuiTabStatistics(EntityPlayer player, INetworkConnector connector) {
        super(player, connector);
        this.stats = this.network.getSetting(NetworkSettings.NETWORK_STATISTICS);
        this.timer = 0;
    }

    @Override
    public EnumNavigationTabs getNavigationTab() {
        return EnumNavigationTabs.TAB_STATISTICS;
    }

    @Override
    protected void drawForegroundLayer(int mouseX, int mouseY) {
        super.drawForegroundLayer(mouseX, mouseY);
        if (this.networkValid) {
            int color = this.network.getSetting(NetworkSettings.NETWORK_COLOR);
            this.renderNetwork(this.network.getSetting(NetworkSettings.NETWORK_NAME), color, 20, 8);
            this.field_146289_q.func_78276_b(TextFormatting.GRAY + FluxTranslate.PLUGS.t() + TextFormatting.GRAY + ": " + TextFormatting.RESET + this.stats.fluxPlugCount, 12, 24, color);
            this.field_146289_q.func_78276_b(TextFormatting.GRAY + FluxTranslate.POINTS.t() + TextFormatting.GRAY + ": " + TextFormatting.RESET + this.stats.fluxPointCount, 12, 36, color);
            this.field_146289_q.func_78276_b(TextFormatting.GRAY + FluxTranslate.STORAGES.t() + TextFormatting.GRAY + ": " + TextFormatting.RESET + this.stats.fluxStorageCount, 82, 24, color);
            this.field_146289_q.func_78276_b(TextFormatting.GRAY + FluxTranslate.CONTROLLERS.t() + TextFormatting.GRAY + ": " + TextFormatting.RESET + this.stats.fluxControllerCount, 82, 36, color);
            this.field_146289_q.func_78276_b(TextFormatting.GRAY + FluxTranslate.INPUT.t() + TextFormatting.GRAY + ": " + TextFormatting.RESET + FluxUtils.format(this.stats.energyInput, FluxUtils.TypeNumberFormat.COMPACT, this.network.getSetting(NetworkSettings.NETWORK_ENERGY), true), 12, 48, color);
            this.field_146289_q.func_78276_b(TextFormatting.GRAY + FluxTranslate.OUTPUT.t() + TextFormatting.GRAY + ": " + TextFormatting.RESET + FluxUtils.format(this.stats.energyOutput, FluxUtils.TypeNumberFormat.COMPACT, this.network.getSetting(NetworkSettings.NETWORK_ENERGY), true), 12, 60, color);
            this.field_146289_q.func_78276_b(TextFormatting.GRAY + FluxTranslate.BUFFER.t() + TextFormatting.GRAY + ": " + TextFormatting.RESET + FluxUtils.format(this.stats.totalBuffer, FluxUtils.TypeNumberFormat.COMPACT, this.network.getSetting(NetworkSettings.NETWORK_ENERGY), false), 12, 72, color);
            this.field_146289_q.func_78276_b(TextFormatting.GRAY + FluxTranslate.ENERGY.t() + TextFormatting.GRAY + ": " + TextFormatting.RESET + FluxUtils.format(this.stats.totalEnergy, FluxUtils.TypeNumberFormat.COMPACT, this.network.getSetting(NetworkSettings.NETWORK_ENERGY), false), 12, 84, color);
            GlStateManager.func_179139_a((double)0.75, (double)0.75, (double)0.75);
            this.func_73732_a(this.field_146289_q, FluxTranslate.AVERAGE_TICK.t() + ": " + this.stats.average_tick_micro + " \u00b5s/t", (int)((double)(this.field_146999_f / 2) * 1.3333333333333333), (int)((double)(this.field_147000_g - 2) * 1.3333333333333333), color);
            GlStateManager.func_179139_a((double)1.3333333333333333, (double)1.3333333333333333, (double)1.3333333333333333);
        } else {
            this.renderNavigationPrompt(FluxTranslate.ERROR_NO_SELECTED.t(), FluxTranslate.TAB_SELECTION.t());
        }
    }

    @Override
    protected void drawBackgroundLayer(float partialTicks, int mouseX, int mouseY) {
        super.drawBackgroundLayer(partialTicks, mouseX, mouseY);
        if (this.networkValid && this.chart != null) {
            this.chart.drawChart(this.field_146297_k);
            this.chart.updateHeight(partialTicks);
        }
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.configureNavigationButtons(EnumNavigationTabs.TAB_STATISTICS, this.navigationTabs);
        if (this.networkValid) {
            this.chart = new LineChart(this.field_146294_l / 2 - 48, this.field_146295_m / 2 + 20, 50, 6, "s", "RF");
            this.chart.updateData(this.stats.energyChange);
        }
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        if (this.networkValid) {
            if (this.timer == 0) {
                PacketHandler.network.sendToServer((IMessage)new PacketNetworkUpdateRequest.UpdateRequestMessage(this.network.getNetworkID(), NBTType.NETWORK_STATISTICS));
            }
            if (this.timer == 1) {
                this.chart.updateData(this.stats.energyChange);
            }
            ++this.timer;
            this.timer %= 20;
        }
    }

    static {
        GUI_COLOR_TAG.func_74757_a("GuiColor", true);
        plug = new ItemStack(RegistryBlocks.FLUX_PLUG);
        plug.func_77982_d(GUI_COLOR_TAG);
        point = new ItemStack(RegistryBlocks.FLUX_POINT);
        point.func_77982_d(GUI_COLOR_TAG);
        storage = new ItemStack(RegistryBlocks.FLUX_STORAGE_1);
        storage.func_77982_d(GUI_COLOR_TAG);
        controller = new ItemStack(RegistryBlocks.FLUX_CONTROLLER);
        controller.func_77982_d(GUI_COLOR_TAG);
    }
}

