/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.blocks;

import cassiokf.industrialrenewal.blocks.abstracts.BlockHorizontalFacing;
import cassiokf.industrialrenewal.tileentity.TileEntityBunkerHatch;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockBunkerHatch
extends BlockHorizontalFacing {
    public static final PropertyBool MASTER = PropertyBool.func_177716_a((String)"master");
    public static final PropertyBool OPEN = PropertyBool.func_177716_a((String)"open");
    protected static final AxisAlignedBB RENDER_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);

    public BlockBunkerHatch(String name, CreativeTabs tab) {
        super(name, tab, Material.field_151573_f);
        this.func_149672_a(SoundType.field_185852_e);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof TileEntityBunkerHatch) {
            ((TileEntityBunkerHatch)tile).changeOpen();
        }
        return true;
    }

    public int getLightOpacity(IBlockState state, IBlockAccess world, BlockPos pos) {
        IBlockState actualState = state.func_185899_b(world, pos);
        if (((Boolean)actualState.func_177229_b((IProperty)OPEN)).booleanValue()) {
            return 0;
        }
        return 250;
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        return false;
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return (Boolean)worldIn.func_180495_p(pos).func_177229_b((IProperty)OPEN);
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        worldIn.func_175656_a(pos.func_177972_a((EnumFacing)state.func_177229_b((IProperty)FACING)), state.func_177226_a((IProperty)MASTER, (Comparable)Boolean.valueOf(true)));
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        if (((Boolean)state.func_177229_b((IProperty)MASTER)).booleanValue()) {
            for (int z = -1; z < 2; ++z) {
                for (int x = -1; x < 2; ++x) {
                    BlockPos currentPos = new BlockPos(pos.func_177958_n() + x, pos.func_177956_o(), pos.func_177952_p() + z);
                    if (z == 0 && x == 0) continue;
                    worldIn.func_175656_a(currentPos, state.func_177226_a((IProperty)MASTER, (Comparable)Boolean.valueOf(false)));
                }
            }
        }
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        EntityPlayer player = worldIn.func_184137_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 10.0, false);
        if (player == null) {
            return false;
        }
        for (int z = 0; z < 3; ++z) {
            for (int x = -1; x < 2; ++x) {
                EnumFacing facing = player.func_174811_aO();
                BlockPos currentPos = new BlockPos((Vec3i)pos.func_177967_a(facing, z).func_177967_a(facing.func_176746_e(), x));
                IBlockState state = worldIn.func_180495_p(currentPos);
                if (state.func_177230_c().func_176200_f((IBlockAccess)worldIn, currentPos)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, MASTER, OPEN});
    }

    @Override
    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO()).func_177226_a((IProperty)MASTER, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)OPEN, (Comparable)Boolean.valueOf(false));
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)(meta & 3))).func_177226_a((IProperty)MASTER, (Comparable)Boolean.valueOf((meta & 4) > 0)).func_177226_a((IProperty)OPEN, (Comparable)Boolean.valueOf((meta & 8) > 0));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        int i = 0;
        i |= ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
        if (((Boolean)state.func_177229_b((IProperty)MASTER)).booleanValue()) {
            i |= 4;
        }
        if (((Boolean)state.func_177229_b((IProperty)OPEN)).booleanValue()) {
            i |= 8;
        }
        return i;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return RENDER_AABB;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        IBlockState actualState = this.func_176221_a(state, (IBlockAccess)worldIn, pos);
        Boolean active = (Boolean)actualState.func_177229_b((IProperty)OPEN);
        if (active.booleanValue()) {
            BlockBunkerHatch.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)field_185506_k);
        } else {
            BlockBunkerHatch.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)RENDER_AABB);
        }
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntityBunkerHatch createTileEntity(World world, IBlockState state) {
        return new TileEntityBunkerHatch();
    }
}

