/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.blocks;

import cassiokf.industrialrenewal.IndustrialRenewal;
import cassiokf.industrialrenewal.blocks.abstracts.BlockHorizontalFacing;
import cassiokf.industrialrenewal.config.IRConfig;
import cassiokf.industrialrenewal.tileentity.TileEntityFirstAidKit;
import cassiokf.industrialrenewal.util.Utils;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class BlockFirstAidKit
extends BlockHorizontalFacing {
    private static final AxisAlignedBB WEST_BLOCK_AABB = new AxisAlignedBB(0.0, 0.1875, 0.1875, 0.3125, 0.8125, 0.8125);
    private static final AxisAlignedBB EAST_BLOCK_AABB = new AxisAlignedBB(1.0, 0.1875, 0.1875, 0.6875, 0.8125, 0.8125);
    private static final AxisAlignedBB SOUTH_BLOCK_AABB = new AxisAlignedBB(0.1875, 0.1875, 0.6875, 0.8125, 0.8125, 1.0);
    private static final AxisAlignedBB NORTH_BLOCK_AABB = new AxisAlignedBB(0.1875, 0.1875, 0.3125, 0.8125, 0.8125, 0.0);

    public BlockFirstAidKit(String name, CreativeTabs tab) {
        super(name, tab, Material.field_151573_f);
        this.func_149711_c(0.8f);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        EnumFacing dir = (EnumFacing)state.func_177229_b((IProperty)FACING);
        switch (dir) {
            default: {
                return NORTH_BLOCK_AABB;
            }
            case SOUTH: {
                return SOUTH_BLOCK_AABB;
            }
            case EAST: {
                return EAST_BLOCK_AABB;
            }
            case WEST: 
        }
        return WEST_BLOCK_AABB;
    }

    public static EnumFacing getFaceDirection(IBlockState state) {
        if (state.func_177230_c() instanceof BlockFirstAidKit) {
            return (EnumFacing)state.func_177229_b((IProperty)FACING);
        }
        return EnumFacing.NORTH;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        if (!player.func_70093_af()) {
            ItemStack stack = this.itemInKit(world, pos);
            if (stack != null && player.func_70996_bM() && !player.func_70644_a(MobEffects.field_76428_l)) {
                player.func_70690_d(new PotionEffect(MobEffects.field_76428_l, IRConfig.MainConfig.Main.medKitEffectDuration, 1, false, false));
                stack.func_190918_g(1);
            }
        } else {
            this.OpenGUI(world, pos, player);
        }
        return true;
    }

    private ItemStack itemInKit(World world, BlockPos pos) {
        TileEntityFirstAidKit te = (TileEntityFirstAidKit)world.func_175625_s(pos);
        if (te == null) {
            return null;
        }
        ItemStackHandler inventory = te.inventory;
        for (int slot = 0; slot < inventory.getSlots(); ++slot) {
            ItemStack stack = inventory.getStackInSlot(slot);
            if (stack.func_190926_b()) continue;
            return stack;
        }
        return null;
    }

    private void OpenGUI(World world, BlockPos pos, EntityPlayer player) {
        player.openGui((Object)IndustrialRenewal.instance, 0, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    @Override
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntityFirstAidKit te = (TileEntityFirstAidKit)world.func_175625_s(pos);
        IItemHandler inventory = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (inventory != null) {
            Utils.dropInventoryItems(world, pos, inventory);
        }
        super.func_180663_b(world, pos, state);
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntityFirstAidKit createTileEntity(World world, IBlockState state) {
        return new TileEntityFirstAidKit();
    }
}

