/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.blocks;

import cassiokf.industrialrenewal.blocks.abstracts.BlockMultiBlockBase;
import cassiokf.industrialrenewal.item.ItemDrill;
import cassiokf.industrialrenewal.item.ItemPowerScrewDrive;
import cassiokf.industrialrenewal.tileentity.TileEntityMining;
import cassiokf.industrialrenewal.util.MachinesUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;

public class BlockMining
extends BlockMultiBlockBase<TileEntityMining> {
    public BlockMining(String name, CreativeTabs tab) {
        super(Material.field_151573_f, name, tab);
        this.func_149672_a(SoundType.field_185852_e);
    }

    @Override
    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileEntityMining) {
            ((TileEntityMining)te).dropAllItems();
        }
        super.func_180663_b(worldIn, pos, state);
    }

    @Override
    public List<BlockPos> getMachineBlockPosList(BlockPos masterPos, EnumFacing facing) {
        return MachinesUtils.getBlocksIn3x3x3Centered(masterPos);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntityMining tile = (TileEntityMining)world.func_175625_s(pos);
        if (tile == null) {
            return false;
        }
        IItemHandler itemHandler = tile.getDrillHandler();
        ItemStack heldItem = player.func_184586_b(hand);
        if (!heldItem.func_190926_b() && (heldItem.func_77973_b() instanceof ItemDrill || heldItem.func_77973_b() instanceof ItemPowerScrewDrive)) {
            if (heldItem.func_77973_b() instanceof ItemDrill && itemHandler.getStackInSlot(0).func_190926_b()) {
                if (!world.field_72995_K) {
                    itemHandler.insertItem(0, new ItemStack(heldItem.func_77973_b(), 1, heldItem.func_77973_b().getDamage(heldItem)), false);
                    if (!player.func_184812_l_()) {
                        heldItem.func_190918_g(1);
                    }
                }
                return true;
            }
            if (heldItem.func_77973_b() instanceof ItemPowerScrewDrive && !itemHandler.getStackInSlot(0).func_190926_b() && !tile.isRunning()) {
                if (!world.field_72995_K) {
                    player.func_191521_c(itemHandler.extractItem(0, 64, false));
                }
                return true;
            }
        }
        return false;
    }

    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(I18n.func_135052_a((String)"info.industrialrenewal.requires", (Object[])new Object[0]) + ":");
        tooltip.add(" -" + I18n.func_135052_a((String)"info.industrialrenewal.drill", (Object[])new Object[0]));
        tooltip.add(" -" + Blocks.field_150355_j.func_149732_F() + ": " + TileEntityMining.waterPerTick + " mB/t");
        tooltip.add(" -" + TileEntityMining.energyPerTick + " ~ " + TileEntityMining.deepEnergyPerTick + " FE/t");
        super.func_190948_a(stack, player, tooltip, advanced);
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, MASTER});
    }

    @Override
    @Nullable
    public TileEntityMining createTileEntity(World world, IBlockState state) {
        return new TileEntityMining();
    }
}

