/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.blocks;

import cassiokf.industrialrenewal.blocks.BlockBase;
import cassiokf.industrialrenewal.blocks.BlockBrace;
import cassiokf.industrialrenewal.blocks.BlockCatWalk;
import cassiokf.industrialrenewal.blocks.BlockColumn;
import cassiokf.industrialrenewal.blocks.BlockLight;
import cassiokf.industrialrenewal.blocks.BlockRoof;
import cassiokf.industrialrenewal.blocks.BlockSignBase;
import cassiokf.industrialrenewal.blocks.industrialfloor.BlockFloorCable;
import cassiokf.industrialrenewal.blocks.industrialfloor.BlockFloorLamp;
import cassiokf.industrialrenewal.blocks.industrialfloor.BlockFloorPipe;
import cassiokf.industrialrenewal.blocks.industrialfloor.BlockIndustrialFloor;
import cassiokf.industrialrenewal.blocks.pipes.BlockCableTray;
import cassiokf.industrialrenewal.blocks.pipes.BlockHVConnectorBase;
import cassiokf.industrialrenewal.blocks.pipes.BlockPillarEnergyCable;
import cassiokf.industrialrenewal.blocks.pipes.BlockPillarFluidPipe;
import cassiokf.industrialrenewal.blocks.redstone.BlockAlarm;
import cassiokf.industrialrenewal.init.ModBlocks;
import cassiokf.industrialrenewal.util.enums.enumproperty.EnumBaseDirection;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLadder;
import net.minecraft.block.BlockLever;
import net.minecraft.block.BlockRedstoneTorch;
import net.minecraft.block.BlockTripWireHook;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockPillar
extends BlockBase {
    public static final ImmutableList<IProperty<Boolean>> CONNECTED_PROPERTIES = ImmutableList.copyOf((Collection)Stream.of(EnumFacing.field_82609_l).map(facing -> PropertyBool.func_177716_a((String)facing.func_176610_l())).collect(Collectors.toList()));
    private static float NORTHZ1 = 0.25f;
    private static float SOUTHZ2 = 0.75f;
    private static float WESTX1 = 0.25f;
    private static float EASTX2 = 0.75f;
    private static float DOWNY1 = 0.0f;
    private static float UPY2 = 1.0f;

    public BlockPillar(String name, CreativeTabs tab) {
        super(Material.field_151573_f, name, tab);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149711_c(0.8f);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, (IProperty[])CONNECTED_PROPERTIES.toArray((Object[])new IProperty[CONNECTED_PROPERTIES.size()]));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    private static boolean isValidConnection(IBlockAccess worldIn, BlockPos neightbourPos, IBlockState neighbourState, EnumFacing neighbourDirection) {
        Block nb = neighbourState.func_177230_c();
        if (neighbourDirection != EnumFacing.UP && neighbourDirection != EnumFacing.DOWN) {
            return nb instanceof BlockLever || nb instanceof BlockHVConnectorBase && neighbourState.func_177229_b((IProperty)BlockHVConnectorBase.FACING) == neighbourDirection.func_176734_d() || nb instanceof BlockRedstoneTorch || nb instanceof BlockTripWireHook || nb instanceof BlockColumn || nb instanceof BlockCableTray && ((EnumBaseDirection)((Object)neighbourState.func_177229_b(BlockCableTray.BASE))).equals((Object)EnumBaseDirection.byIndex(neighbourDirection.func_176734_d().func_176745_a())) || nb instanceof BlockLadder || nb instanceof BlockLight && neighbourState.func_177229_b((IProperty)BlockLight.FACING) == neighbourDirection.func_176734_d() || nb instanceof BlockRoof || nb instanceof BlockBrace && Objects.equals(((BlockBrace.EnumOrientation)((Object)neighbourState.func_177229_b(BlockBrace.FACING))).func_176610_l(), neighbourDirection.func_176734_d().func_176610_l()) || nb instanceof BlockBrace && Objects.equals(((BlockBrace.EnumOrientation)((Object)neighbourState.func_177229_b(BlockBrace.FACING))).func_176610_l(), "down_" + neighbourDirection.func_176610_l()) || nb instanceof BlockAlarm && neighbourState.func_177229_b(BlockAlarm.FACING) == neighbourDirection || nb instanceof BlockSignBase && (Boolean)neighbourState.func_177229_b((IProperty)BlockSignBase.ONWALL) != false && Objects.equals(((EnumFacing)neighbourState.func_177229_b((IProperty)BlockSignBase.FACING)).func_176610_l(), neighbourDirection.func_176734_d().func_176610_l()) || Objects.requireNonNull(nb.getRegistryName()).toString().matches("immersiveengineering:connector") || Objects.requireNonNull(nb.getRegistryName()).toString().matches("immersiveengineering:metal_decoration2") || Objects.requireNonNull(nb.getRegistryName()).toString().matches("immersiveengineering:wooden_device1") || Objects.requireNonNull(nb.getRegistryName()).toString().matches("immersiveengineering:metal_device1") || nb instanceof BlockIndustrialFloor || nb instanceof BlockFloorLamp || nb instanceof BlockFloorPipe || nb instanceof BlockFloorCable;
        }
        if (neighbourDirection == EnumFacing.DOWN) {
            return nb.func_149686_d(neighbourState) || nb.func_185481_k(neighbourState);
        }
        return nb.func_149686_d(neighbourState) || neighbourState.isSideSolid(worldIn, neightbourPos, EnumFacing.DOWN) || nb instanceof BlockIndustrialFloor || nb instanceof BlockFloorLamp || nb instanceof BlockFloorPipe || nb instanceof BlockFloorCable || nb instanceof BlockCatWalk;
    }

    public static boolean canConnectTo(IBlockAccess worldIn, BlockPos ownPos, EnumFacing neighbourDirection) {
        BlockPos neighbourPos = ownPos.func_177972_a(neighbourDirection);
        IBlockState neighbourState = worldIn.func_180495_p(neighbourPos);
        return BlockPillar.isValidConnection(worldIn, neighbourPos, neighbourState, neighbourDirection);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (this.name.equals("catwalk_pillar") && hand.equals((Object)EnumHand.MAIN_HAND)) {
            ItemStack playerStack = player.func_184586_b(EnumHand.MAIN_HAND);
            Item playerItem = playerStack.func_77973_b();
            Block clickedBlock = state.func_177230_c();
            if (playerItem.equals(ItemBlock.func_150898_a((Block)ModBlocks.energyCableMV))) {
                if (!world.field_72995_K) {
                    world.func_180501_a(pos, ModBlocks.pillarEnergyCableMV.func_176223_P(), 3);
                    world.func_184133_a(null, pos, SoundEvents.field_187772_dn, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    if (!player.func_184812_l_()) {
                        playerStack.func_190918_g(1);
                    }
                }
                return true;
            }
            if (playerItem.equals(ItemBlock.func_150898_a((Block)ModBlocks.energyCableLV))) {
                if (!world.field_72995_K) {
                    world.func_180501_a(pos, ModBlocks.pillarEnergyCableLV.func_176223_P(), 3);
                    world.func_184133_a(null, pos, SoundEvents.field_187772_dn, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    if (!player.func_184812_l_()) {
                        playerStack.func_190918_g(1);
                    }
                }
                return true;
            }
            if (playerItem.equals(ItemBlock.func_150898_a((Block)ModBlocks.energyCableHV))) {
                if (!world.field_72995_K) {
                    world.func_180501_a(pos, ModBlocks.pillarEnergyCableHV.func_176223_P(), 3);
                    world.func_184133_a(null, pos, SoundEvents.field_187772_dn, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    if (!player.func_184812_l_()) {
                        playerStack.func_190918_g(1);
                    }
                }
                return true;
            }
            if (playerItem.equals(ItemBlock.func_150898_a((Block)ModBlocks.fluidPipe))) {
                if (!world.field_72995_K) {
                    world.func_180501_a(pos, ModBlocks.pillarFluidPipe.func_176223_P(), 3);
                    world.func_184133_a(null, pos, SoundEvents.field_187772_dn, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    if (!player.func_184812_l_()) {
                        playerStack.func_190918_g(1);
                    }
                }
                return true;
            }
            if (playerItem.equals(ItemBlock.func_150898_a((Block)ModBlocks.pillar)) && clickedBlock.equals((Object)ModBlocks.pillar) || playerItem.equals(ItemBlock.func_150898_a((Block)ModBlocks.steel_pillar)) && clickedBlock.equals((Object)ModBlocks.steel_pillar)) {
                int n = 1;
                while (world.func_180495_p(pos.func_177981_b(n)).func_177230_c() instanceof BlockPillar || world.func_180495_p(pos.func_177981_b(n)).func_177230_c() instanceof BlockPillarEnergyCable || world.func_180495_p(pos.func_177981_b(n)).func_177230_c() instanceof BlockPillarFluidPipe) {
                    ++n;
                }
                if (world.func_180495_p(pos.func_177981_b(n)).func_177230_c().func_176200_f((IBlockAccess)world, pos.func_177981_b(n))) {
                    if (!world.field_72995_K) {
                        world.func_180501_a(pos.func_177981_b(n), BlockPillar.func_149634_a((Item)playerItem).func_176223_P(), 3);
                        world.func_184133_a(null, pos, SoundEvents.field_187772_dn, SoundCategory.BLOCKS, 1.0f, 1.0f);
                        if (!player.func_184812_l_()) {
                            playerStack.func_190918_g(1);
                        }
                    }
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            state = state.func_177226_a((IProperty)CONNECTED_PROPERTIES.get(facing.func_176745_a()), (Comparable)Boolean.valueOf(BlockPillar.canConnectTo(world, pos, facing)));
        }
        return state;
    }

    public final boolean isConnected(IBlockState state, EnumFacing facing) {
        return (Boolean)state.func_177229_b((IProperty)CONNECTED_PROPERTIES.get(facing.func_176745_a()));
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        if (!isActualState) {
            state = state.func_185899_b((IBlockAccess)worldIn, pos);
        }
        if (this.isConnected(state, EnumFacing.NORTH)) {
            NORTHZ1 = 0.0f;
        } else if (!this.isConnected(state, EnumFacing.NORTH)) {
            NORTHZ1 = 0.25f;
        }
        if (this.isConnected(state, EnumFacing.SOUTH)) {
            SOUTHZ2 = 1.0f;
        } else if (!this.isConnected(state, EnumFacing.SOUTH)) {
            SOUTHZ2 = 0.75f;
        }
        if (this.isConnected(state, EnumFacing.WEST)) {
            WESTX1 = 0.0f;
        } else if (!this.isConnected(state, EnumFacing.WEST)) {
            WESTX1 = 0.25f;
        }
        if (this.isConnected(state, EnumFacing.EAST)) {
            EASTX2 = 1.0f;
        } else if (!this.isConnected(state, EnumFacing.EAST)) {
            EASTX2 = 0.75f;
        }
        AxisAlignedBB AA_BB = new AxisAlignedBB((double)WESTX1, (double)DOWNY1, (double)NORTHZ1, (double)EASTX2, (double)UPY2, (double)SOUTHZ2);
        BlockPillar.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AA_BB);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        IBlockState actualState = state.func_185899_b(source, pos);
        if (this.isConnected(actualState, EnumFacing.NORTH)) {
            NORTHZ1 = 0.0f;
        } else if (!this.isConnected(actualState, EnumFacing.NORTH)) {
            NORTHZ1 = 0.25f;
        }
        if (this.isConnected(actualState, EnumFacing.SOUTH)) {
            SOUTHZ2 = 1.0f;
        } else if (!this.isConnected(actualState, EnumFacing.SOUTH)) {
            SOUTHZ2 = 0.75f;
        }
        if (this.isConnected(actualState, EnumFacing.WEST)) {
            WESTX1 = 0.0f;
        } else if (!this.isConnected(actualState, EnumFacing.WEST)) {
            WESTX1 = 0.25f;
        }
        if (this.isConnected(actualState, EnumFacing.EAST)) {
            EASTX2 = 1.0f;
        } else if (!this.isConnected(actualState, EnumFacing.EAST)) {
            EASTX2 = 0.75f;
        }
        return new AxisAlignedBB((double)WESTX1, (double)DOWNY1, (double)NORTHZ1, (double)EASTX2, (double)UPY2, (double)SOUTHZ2);
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        if (face == EnumFacing.EAST || face == EnumFacing.WEST || face == EnumFacing.NORTH || face == EnumFacing.SOUTH) {
            return BlockFaceShape.SOLID;
        }
        return BlockFaceShape.UNDEFINED;
    }
}

