/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.blocks.abstracts;

import cassiokf.industrialrenewal.blocks.abstracts.BlockHorizontalFacing;
import cassiokf.industrialrenewal.tileentity.abstracts.TileEntityMultiBlockBase;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class BlockMultiBlockBase<TE extends TileEntityMultiBlockBase>
extends BlockHorizontalFacing {
    public static final PropertyBool MASTER = PropertyBool.func_177716_a((String)"master");

    public BlockMultiBlockBase(Material material, String name, CreativeTabs tab) {
        super(name, tab, material);
        this.func_149672_a(SoundType.field_185852_e);
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        worldIn.func_175656_a(pos.func_177972_a((EnumFacing)state.func_177229_b((IProperty)FACING)).func_177984_a(), state.func_177226_a((IProperty)MASTER, (Comparable)Boolean.valueOf(true)));
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        if (((Boolean)state.func_177229_b((IProperty)MASTER)).booleanValue()) {
            EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            List<BlockPos> posList = this.getMachineBlockPosList(pos, facing);
            for (BlockPos currentPos : posList) {
                if (currentPos.equals((Object)pos)) continue;
                worldIn.func_175656_a(currentPos, state.func_177226_a((IProperty)MASTER, (Comparable)Boolean.valueOf(false)));
            }
        }
    }

    @Override
    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileEntityMultiBlockBase) {
            ((TileEntityMultiBlockBase)te).breakMultiBlocks();
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        EntityPlayer player = worldIn.func_184137_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 10.0, false);
        if (player == null) {
            return false;
        }
        EnumFacing facing = player.func_174811_aO();
        List<BlockPos> posList = this.getMachineBlockPosList(this.getMasterPosBasedOnPlace(pos, facing), facing);
        for (BlockPos currentPos : posList) {
            if (this.func_176200_f((IBlockAccess)worldIn, currentPos)) continue;
            return false;
        }
        return true;
    }

    protected BlockPos getMasterPosBasedOnPlace(BlockPos pos, EnumFacing facing) {
        return pos.func_177972_a(facing).func_177984_a();
    }

    public abstract List<BlockPos> getMachineBlockPosList(BlockPos var1, EnumFacing var2);

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        return false;
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, MASTER});
    }

    @Override
    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO()).func_177226_a((IProperty)MASTER, (Comparable)Boolean.valueOf(false));
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)(meta & 3))).func_177226_a((IProperty)MASTER, (Comparable)Boolean.valueOf((meta & 4) > 0));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        int i = 0;
        i |= ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
        if (((Boolean)state.func_177229_b((IProperty)MASTER)).booleanValue()) {
            i |= 4;
        }
        return i;
    }

    public TE getTileEntity(IBlockAccess world, BlockPos pos) {
        return (TE)((TileEntityMultiBlockBase)world.func_175625_s(pos));
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public abstract TE createTileEntity(World var1, IBlockState var2);
}

