/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.blocks.industrialfloor;

import cassiokf.industrialrenewal.blocks.BlockBase;
import cassiokf.industrialrenewal.blocks.BlockCatwalkHatch;
import cassiokf.industrialrenewal.blocks.BlockCatwalkLadder;
import cassiokf.industrialrenewal.blocks.industrialfloor.BlockFloorCable;
import cassiokf.industrialrenewal.blocks.industrialfloor.BlockFloorPipe;
import cassiokf.industrialrenewal.init.ModBlocks;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.common.property.Properties;

public class BlockIndustrialFloor
extends BlockBase {
    public static final ImmutableList<IUnlistedProperty<Boolean>> CONNECTED_PROPERTIES = ImmutableList.copyOf((Collection)Stream.of(EnumFacing.field_82609_l).map(facing -> new Properties.PropertyAdapter((IProperty)PropertyBool.func_177716_a((String)facing.func_176610_l()))).collect(Collectors.toList()));
    protected static final AxisAlignedBB UP_AABB = new AxisAlignedBB(0.0, 0.875, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB DOWN_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0);
    protected static final AxisAlignedBB NONE_AABB = new AxisAlignedBB(0.3125, 0.3125, 0.3125, 0.6875, 0.6875, 0.6875);
    protected static final AxisAlignedBB C_UP_AABB = new AxisAlignedBB(0.0, 0.9375, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB C_DOWN_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0625, 1.0);
    protected static final AxisAlignedBB C_NORTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.0625);
    protected static final AxisAlignedBB C_SOUTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.9375, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB C_WEST_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0625, 1.0, 1.0);
    protected static final AxisAlignedBB C_EAST_AABB = new AxisAlignedBB(0.9375, 0.0, 0.0, 1.0, 1.0, 1.0);

    public BlockIndustrialFloor(String name, CreativeTabs tab) {
        super(Material.field_151573_f, name, tab);
        this.func_149711_c(0.8f);
        this.func_149672_a(SoundType.field_185852_e);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        if (this.isConnected(worldIn, pos, state, EnumFacing.UP) && !this.isConnected(worldIn, pos, state, EnumFacing.DOWN)) {
            return UP_AABB;
        }
        if (!this.isConnected(worldIn, pos, state, EnumFacing.UP) && this.isConnected(worldIn, pos, state, EnumFacing.DOWN)) {
            return DOWN_AABB;
        }
        if (!this.isConnected(worldIn, pos, state, EnumFacing.UP) && !this.isConnected(worldIn, pos, state, EnumFacing.DOWN)) {
            return NONE_AABB;
        }
        return field_185505_j;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        if (this.isConnected((IBlockAccess)worldIn, pos, state, EnumFacing.UP)) {
            BlockIndustrialFloor.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)C_UP_AABB);
        }
        if (this.isConnected((IBlockAccess)worldIn, pos, state, EnumFacing.DOWN)) {
            BlockIndustrialFloor.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)C_DOWN_AABB);
        }
        if (this.isConnected((IBlockAccess)worldIn, pos, state, EnumFacing.NORTH)) {
            BlockIndustrialFloor.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)C_NORTH_AABB);
        }
        if (this.isConnected((IBlockAccess)worldIn, pos, state, EnumFacing.SOUTH)) {
            BlockIndustrialFloor.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)C_SOUTH_AABB);
        }
        if (this.isConnected((IBlockAccess)worldIn, pos, state, EnumFacing.WEST)) {
            BlockIndustrialFloor.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)C_WEST_AABB);
        }
        if (this.isConnected((IBlockAccess)worldIn, pos, state, EnumFacing.EAST)) {
            BlockIndustrialFloor.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)C_EAST_AABB);
        }
    }

    protected BlockStateContainer func_180661_e() {
        IProperty[] listedProperties = new IProperty[]{};
        IUnlistedProperty[] unlistedProperties = (IUnlistedProperty[])CONNECTED_PROPERTIES.toArray((Object[])new IUnlistedProperty[CONNECTED_PROPERTIES.size()]);
        return new ExtendedBlockState((Block)this, listedProperties, unlistedProperties);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    private static boolean isValidConnection(IBlockState neighbourState, IBlockAccess world, BlockPos ownPos, EnumFacing neighbourDirection) {
        Block nb = neighbourState.func_177230_c();
        return nb instanceof BlockIndustrialFloor || nb instanceof BlockFloorPipe || nb instanceof BlockFloorCable || nb instanceof BlockDoor && ((EnumFacing)neighbourState.func_177229_b((IProperty)BlockDoor.field_176520_a)).equals((Object)neighbourDirection) || neighbourDirection.equals((Object)EnumFacing.DOWN) && nb instanceof BlockCatwalkLadder || neighbourDirection.equals((Object)EnumFacing.UP) && nb instanceof BlockCatwalkHatch || neighbourDirection != EnumFacing.UP && neighbourDirection != EnumFacing.DOWN && nb instanceof BlockCatwalkLadder && (Boolean)neighbourState.func_177229_b((IProperty)BlockCatwalkLadder.ACTIVE) == false;
    }

    public static boolean canConnectTo(IBlockAccess worldIn, BlockPos ownPos, EnumFacing neighbourDirection) {
        BlockPos neighbourPos = ownPos.func_177972_a(neighbourDirection);
        IBlockState neighbourState = worldIn.func_180495_p(neighbourPos);
        return !BlockIndustrialFloor.isValidConnection(neighbourState, worldIn, ownPos, neighbourDirection);
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (state instanceof IExtendedBlockState) {
            IExtendedBlockState eState = (IExtendedBlockState)state;
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                eState = eState.withProperty((IUnlistedProperty)CONNECTED_PROPERTIES.get(facing.func_176745_a()), (Object)BlockIndustrialFloor.canConnectTo(world, pos, facing));
            }
            return eState;
        }
        return state;
    }

    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return true;
    }

    public final boolean isConnected(IBlockAccess world, BlockPos pos, IBlockState state, EnumFacing facing) {
        if (state instanceof IExtendedBlockState) {
            state = this.getExtendedState(state, world, pos);
            IExtendedBlockState eState = (IExtendedBlockState)state;
            return (Boolean)eState.getValue((IUnlistedProperty)CONNECTED_PROPERTIES.get(facing.func_176745_a()));
        }
        return false;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer entity, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack playerStack = entity.func_184586_b(EnumHand.MAIN_HAND);
        Item playerItem = playerStack.func_77973_b();
        if (playerItem.equals(ItemBlock.func_150898_a((Block)ModBlocks.fluidPipe))) {
            world.func_184133_a(null, pos, SoundEvents.field_187772_dn, SoundCategory.BLOCKS, 1.0f, 1.0f);
            world.func_180501_a(pos, ModBlocks.floorPipe.func_176223_P(), 3);
            if (!entity.func_184812_l_()) {
                playerStack.func_190918_g(1);
            }
            return true;
        }
        if (playerItem.equals(ItemBlock.func_150898_a((Block)ModBlocks.energyCableMV)) || playerItem.equals(ItemBlock.func_150898_a((Block)ModBlocks.energyCableLV)) || playerItem.equals(ItemBlock.func_150898_a((Block)ModBlocks.energyCableHV))) {
            world.func_184133_a(null, pos, SoundEvents.field_187772_dn, SoundCategory.BLOCKS, 1.0f, 1.0f);
            BlockFloorCable block = playerItem.equals(ItemBlock.func_150898_a((Block)ModBlocks.energyCableMV)) ? ModBlocks.floorCableMV : (playerItem.equals(ItemBlock.func_150898_a((Block)ModBlocks.energyCableLV)) ? ModBlocks.floorCableLV : ModBlocks.floorCableHV);
            world.func_180501_a(pos, block.func_176223_P(), 3);
            if (!entity.func_184812_l_()) {
                playerStack.func_190918_g(1);
            }
            return true;
        }
        if (playerItem.equals(ItemBlock.func_150898_a((Block)ModBlocks.fluorescent))) {
            world.func_184133_a(null, pos, SoundEvents.field_187772_dn, SoundCategory.NEUTRAL, 1.0f, 1.0f);
            world.func_180501_a(pos, ModBlocks.floorLamp.func_176223_P(), 3);
            if (entity.func_174811_aO() == EnumFacing.EAST || entity.func_174811_aO() == EnumFacing.WEST) {
                world.func_180501_a(pos.func_177984_a(), ModBlocks.dummy.func_176223_P(), 3);
            }
            if (!entity.func_184812_l_()) {
                playerStack.func_190918_g(1);
            }
            return true;
        }
        return false;
    }

    @Deprecated
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Deprecated
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Deprecated
    public boolean func_185481_k(IBlockState state) {
        return true;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return side.equals((Object)EnumFacing.UP);
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        if (face == EnumFacing.UP || face == EnumFacing.DOWN) {
            return BlockFaceShape.SOLID;
        }
        return BlockFaceShape.UNDEFINED;
    }
}

