/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.blocks.pipes;

import cassiokf.industrialrenewal.blocks.industrialfloor.BlockFloorCable;
import cassiokf.industrialrenewal.blocks.pipes.BlockCableTray;
import cassiokf.industrialrenewal.blocks.pipes.BlockEnergyCableGauge;
import cassiokf.industrialrenewal.blocks.pipes.BlockPipeBase;
import cassiokf.industrialrenewal.config.IRConfig;
import cassiokf.industrialrenewal.init.ModBlocks;
import cassiokf.industrialrenewal.tileentity.tubes.TileEntityEnergyCable;
import cassiokf.industrialrenewal.tileentity.tubes.TileEntityEnergyCableHV;
import cassiokf.industrialrenewal.tileentity.tubes.TileEntityEnergyCableLV;
import cassiokf.industrialrenewal.tileentity.tubes.TileEntityEnergyCableMV;
import cassiokf.industrialrenewal.util.enums.EnumCableIn;
import cassiokf.industrialrenewal.util.enums.EnumEnergyCableType;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.energy.CapabilityEnergy;

public class BlockEnergyCable
extends BlockPipeBase<TileEntityEnergyCable> {
    public EnumEnergyCableType type;

    public BlockEnergyCable(EnumEnergyCableType type, String name, CreativeTabs tab) {
        super(name, tab);
        this.type = type;
    }

    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        int amount;
        switch (this.type) {
            default: {
                amount = IRConfig.MainConfig.Main.maxLVEnergyCableTransferAmount;
                break;
            }
            case MV: {
                amount = IRConfig.MainConfig.Main.maxMVEnergyCableTransferAmount;
                break;
            }
            case HV: {
                amount = IRConfig.MainConfig.Main.maxHVEnergyCableTransferAmount;
            }
        }
        tooltip.add(amount + " FE/t");
        super.func_190948_a(stack, player, tooltip, advanced);
    }

    public static EnumCableIn convertFromType(EnumEnergyCableType type) {
        switch (type) {
            default: {
                return EnumCableIn.LV;
            }
            case MV: {
                return EnumCableIn.MV;
            }
            case HV: 
        }
        return EnumCableIn.HV;
    }

    @Override
    public boolean canConnectToPipe(IBlockAccess worldIn, BlockPos ownPos, EnumFacing neighbourDirection) {
        BlockPos otherPos = ownPos.func_177972_a(neighbourDirection);
        IBlockState state = worldIn.func_180495_p(otherPos);
        Block block = state.func_177230_c();
        return block instanceof BlockEnergyCable && this.type.equals((Object)((BlockEnergyCable)block).type) || block instanceof BlockCableTray && ((BlockCableTray)block).isCablePresent(worldIn, otherPos, BlockEnergyCable.convertFromType(this.type));
    }

    @Override
    public boolean canConnectToCapability(IBlockAccess worldIn, BlockPos ownPos, EnumFacing neighbourDirection) {
        BlockPos pos = ownPos.func_177972_a(neighbourDirection);
        IBlockState state = worldIn.func_180495_p(pos);
        TileEntity te = worldIn.func_175625_s(pos);
        return !(state.func_177230_c() instanceof BlockEnergyCable) && te != null && te.hasCapability(CapabilityEnergy.ENERGY, neighbourDirection.func_176734_d());
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer entity, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack playerStack = entity.func_184586_b(EnumHand.MAIN_HAND);
        if (playerStack.func_77973_b() == ItemBlock.func_150898_a((Block)ModBlocks.blockIndFloor)) {
            if (!world.field_72995_K) {
                BlockFloorCable block;
                world.func_184133_a(null, pos, SoundEvents.field_187772_dn, SoundCategory.BLOCKS, 1.0f, 1.0f);
                switch (this.type) {
                    default: {
                        block = ModBlocks.floorCableLV;
                        break;
                    }
                    case MV: {
                        block = ModBlocks.floorCableMV;
                        break;
                    }
                    case HV: {
                        block = ModBlocks.floorCableHV;
                    }
                }
                world.func_180501_a(pos, block.func_176223_P(), 3);
                if (!entity.func_184812_l_()) {
                    playerStack.func_190918_g(1);
                }
            }
            return true;
        }
        if (playerStack.func_77973_b() == ItemBlock.func_150898_a((Block)ModBlocks.energyLevel)) {
            if (!world.field_72995_K) {
                BlockEnergyCableGauge block;
                world.func_184133_a(null, pos, SoundEvents.field_187772_dn, SoundCategory.BLOCKS, 1.0f, 1.0f);
                switch (this.type) {
                    default: {
                        block = ModBlocks.energyCableGaugeLV;
                        break;
                    }
                    case MV: {
                        block = ModBlocks.energyCableGaugeMV;
                        break;
                    }
                    case HV: {
                        block = ModBlocks.energyCableGaugeHV;
                    }
                }
                world.func_180501_a(pos, block.func_176223_P().func_177226_a((IProperty)BlockEnergyCableGauge.FACING, (Comparable)entity.func_174811_aO()), 3);
                if (!entity.func_184812_l_()) {
                    playerStack.func_190918_g(1);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public TileEntityEnergyCable createTileEntity(World world, IBlockState state) {
        switch (this.type) {
            default: {
                return new TileEntityEnergyCableLV();
            }
            case MV: {
                return new TileEntityEnergyCableMV();
            }
            case HV: 
        }
        return new TileEntityEnergyCableHV();
    }
}

