/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.blocks.pipes;

import cassiokf.industrialrenewal.blocks.pipes.BlockCableTray;
import cassiokf.industrialrenewal.blocks.pipes.BlockFluidPipeGauge;
import cassiokf.industrialrenewal.blocks.pipes.BlockPipeBase;
import cassiokf.industrialrenewal.config.IRConfig;
import cassiokf.industrialrenewal.init.ModBlocks;
import cassiokf.industrialrenewal.tileentity.tubes.TileEntityCableTray;
import cassiokf.industrialrenewal.tileentity.tubes.TileEntityFluidPipe;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;

public class BlockFluidPipe
extends BlockPipeBase<TileEntityFluidPipe> {
    public BlockFluidPipe(String name, CreativeTabs tab) {
        super(name, tab);
    }

    @Override
    public boolean canConnectToPipe(IBlockAccess worldIn, BlockPos ownPos, EnumFacing neighbourDirection) {
        BlockPos neighbourPos = ownPos.func_177972_a(neighbourDirection);
        IBlockState state = worldIn.func_180495_p(neighbourPos);
        Block block = state.func_177230_c();
        return block instanceof BlockFluidPipe || block instanceof BlockCableTray && this.trayHasPipe(worldIn, neighbourPos);
    }

    private boolean trayHasPipe(IBlockAccess world, BlockPos pos) {
        TileEntityCableTray te = (TileEntityCableTray)world.func_175625_s(pos);
        if (te != null) {
            return te.hasPipe();
        }
        return false;
    }

    @Override
    public boolean canConnectToCapability(IBlockAccess worldIn, BlockPos ownPos, EnumFacing neighbourDirection) {
        BlockPos pos = ownPos.func_177972_a(neighbourDirection);
        IBlockState state = worldIn.func_180495_p(pos);
        TileEntity te = worldIn.func_175625_s(pos);
        return !(state.func_177230_c() instanceof BlockFluidPipe) && !(state.func_177230_c() instanceof BlockFluidPipeGauge) && te != null && te.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, neighbourDirection.func_176734_d());
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer entity, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (entity.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() == ItemBlock.func_150898_a((Block)ModBlocks.blockIndFloor)) {
            if (!world.field_72995_K) {
                world.func_184133_a(null, pos, SoundEvents.field_187772_dn, SoundCategory.BLOCKS, 1.0f, 1.0f);
                world.func_180501_a(pos, ModBlocks.floorPipe.func_176223_P(), 3);
                if (!entity.func_184812_l_()) {
                    entity.func_184586_b(EnumHand.MAIN_HAND).func_190918_g(1);
                }
            }
            return true;
        }
        if (entity.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() == ItemBlock.func_150898_a((Block)ModBlocks.gauge)) {
            if (!world.field_72995_K) {
                world.func_184133_a(null, pos, SoundEvents.field_187772_dn, SoundCategory.BLOCKS, 1.0f, 1.0f);
                world.func_180501_a(pos, ModBlocks.fluidPipeGauge.func_176223_P().func_177226_a((IProperty)BlockFluidPipeGauge.FACING, (Comparable)entity.func_174811_aO()), 3);
                if (!entity.func_184812_l_()) {
                    entity.func_184586_b(EnumHand.MAIN_HAND).func_190918_g(1);
                }
            }
            return true;
        }
        return false;
    }

    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(IRConfig.MainConfig.Main.maxFluidPipeTransferAmount + " mB/t");
        super.func_190948_a(stack, player, tooltip, advanced);
    }

    @Override
    @Nullable
    public TileEntityFluidPipe createTileEntity(World world, IBlockState state) {
        return new TileEntityFluidPipe();
    }
}

