/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.blocks.pipes;

import cassiokf.industrialrenewal.blocks.abstracts.BlockTileEntityConnectedMultiblocks;
import cassiokf.industrialrenewal.config.IRConfig;
import cassiokf.industrialrenewal.tileentity.tubes.TileEntityMultiBlocksTube;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.common.property.Properties;

public abstract class BlockPipeBase<TE extends TileEntityMultiBlocksTube>
extends BlockTileEntityConnectedMultiblocks<TE> {
    private static float NORTHZ1 = 0.25f;
    private static float SOUTHZ2 = 0.75f;
    private static float WESTX1 = 0.25f;
    private static float EASTX2 = 0.75f;
    private static float DOWNY1 = 0.25f;
    private static float UPY2 = 0.75f;
    public static final IUnlistedProperty<Boolean> MASTER = new Properties.PropertyAdapter((IProperty)PropertyBool.func_177716_a((String)"master"));
    public static final IUnlistedProperty<Boolean> CSOUTH = new Properties.PropertyAdapter((IProperty)PropertyBool.func_177716_a((String)"c_south"));
    public static final IUnlistedProperty<Boolean> CNORTH = new Properties.PropertyAdapter((IProperty)PropertyBool.func_177716_a((String)"c_north"));
    public static final IUnlistedProperty<Boolean> CEAST = new Properties.PropertyAdapter((IProperty)PropertyBool.func_177716_a((String)"c_east"));
    public static final IUnlistedProperty<Boolean> CWEST = new Properties.PropertyAdapter((IProperty)PropertyBool.func_177716_a((String)"c_west"));
    public static final IUnlistedProperty<Boolean> CUP = new Properties.PropertyAdapter((IProperty)PropertyBool.func_177716_a((String)"c_up"));
    public static final IUnlistedProperty<Boolean> CDOWN = new Properties.PropertyAdapter((IProperty)PropertyBool.func_177716_a((String)"c_down"));
    public static final IUnlistedProperty<Boolean> WSOUTH = new Properties.PropertyAdapter((IProperty)PropertyBool.func_177716_a((String)"w_south"));
    public static final IUnlistedProperty<Boolean> WNORTH = new Properties.PropertyAdapter((IProperty)PropertyBool.func_177716_a((String)"w_north"));
    public static final IUnlistedProperty<Boolean> WEAST = new Properties.PropertyAdapter((IProperty)PropertyBool.func_177716_a((String)"w_east"));
    public static final IUnlistedProperty<Boolean> WWEST = new Properties.PropertyAdapter((IProperty)PropertyBool.func_177716_a((String)"w_west"));
    public static final IUnlistedProperty<Boolean> WUP = new Properties.PropertyAdapter((IProperty)PropertyBool.func_177716_a((String)"w_up"));
    public static final IUnlistedProperty<Boolean> WDOWN = new Properties.PropertyAdapter((IProperty)PropertyBool.func_177716_a((String)"w_down"));

    public BlockPipeBase(String name, CreativeTabs tab) {
        super(Material.field_151573_f, name, tab);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149711_c(0.8f);
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        IProperty[] listedProperties = new IProperty[]{};
        IUnlistedProperty[] unlistedProperties = new IUnlistedProperty[]{MASTER, SOUTH, NORTH, EAST, WEST, UP, DOWN, CSOUTH, CNORTH, CEAST, CWEST, CUP, CDOWN};
        return new ExtendedBlockState((Block)this, listedProperties, unlistedProperties);
    }

    @Override
    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P();
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return 0;
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Override
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public abstract boolean canConnectToPipe(IBlockAccess var1, BlockPos var2, EnumFacing var3);

    public abstract boolean canConnectToCapability(IBlockAccess var1, BlockPos var2, EnumFacing var3);

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (state instanceof IExtendedBlockState) {
            IExtendedBlockState eState = (IExtendedBlockState)state;
            return eState.withProperty(MASTER, (Object)(IRConfig.MainConfig.Main.showMaster && this.isMaster(world, pos) ? 1 : 0)).withProperty(SOUTH, (Object)this.canConnectToPipe(world, pos, EnumFacing.SOUTH)).withProperty(NORTH, (Object)this.canConnectToPipe(world, pos, EnumFacing.NORTH)).withProperty(EAST, (Object)this.canConnectToPipe(world, pos, EnumFacing.EAST)).withProperty(WEST, (Object)this.canConnectToPipe(world, pos, EnumFacing.WEST)).withProperty(UP, (Object)this.canConnectToPipe(world, pos, EnumFacing.UP)).withProperty(DOWN, (Object)this.canConnectToPipe(world, pos, EnumFacing.DOWN)).withProperty(CSOUTH, (Object)this.canConnectToCapability(world, pos, EnumFacing.SOUTH)).withProperty(CNORTH, (Object)this.canConnectToCapability(world, pos, EnumFacing.NORTH)).withProperty(CEAST, (Object)this.canConnectToCapability(world, pos, EnumFacing.EAST)).withProperty(CWEST, (Object)this.canConnectToCapability(world, pos, EnumFacing.WEST)).withProperty(CUP, (Object)this.canConnectToCapability(world, pos, EnumFacing.UP)).withProperty(CDOWN, (Object)this.canConnectToCapability(world, pos, EnumFacing.DOWN));
        }
        return state;
    }

    public boolean isMaster(IBlockAccess world, BlockPos pos) {
        TileEntityMultiBlocksTube te = (TileEntityMultiBlocksTube)world.func_175625_s(pos);
        return te != null && te.isMaster();
    }

    public final boolean isConnected(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        return this.canConnectToPipe(world, pos, facing) || this.canConnectToCapability(world, pos, facing);
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        BlockPipeBase.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)this.func_185496_a(state, (IBlockAccess)worldIn, pos));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return this.getBB(state, worldIn, pos);
    }

    public AxisAlignedBB getBB(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        NORTHZ1 = this.isConnected(worldIn, pos, EnumFacing.NORTH) ? 0.0f : 0.25f;
        SOUTHZ2 = this.isConnected(worldIn, pos, EnumFacing.SOUTH) ? 1.0f : 0.75f;
        WESTX1 = this.isConnected(worldIn, pos, EnumFacing.WEST) ? 0.0f : 0.25f;
        EASTX2 = this.isConnected(worldIn, pos, EnumFacing.EAST) ? 1.0f : 0.75f;
        DOWNY1 = this.isConnected(worldIn, pos, EnumFacing.DOWN) ? 0.0f : 0.25f;
        UPY2 = this.isConnected(worldIn, pos, EnumFacing.UP) ? 1.0f : 0.75f;
        return new AxisAlignedBB((double)WESTX1, (double)DOWNY1, (double)NORTHZ1, (double)EASTX2, (double)UPY2, (double)SOUTHZ2);
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }
}

