/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.blocks.redstone;

import cassiokf.industrialrenewal.blocks.abstracts.BlockTileEntity;
import cassiokf.industrialrenewal.tileentity.redstone.TileEntitySignalIndicator;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockSignalIndicator
extends BlockTileEntity<TileEntitySignalIndicator> {
    protected static final AxisAlignedBB AABB = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 1.625, 0.75);
    private static final AxisAlignedBB WEST_BLOCK_AABB = new AxisAlignedBB(0.0, 0.25, 0.25, 0.625, 1.0, 0.75);
    private static final AxisAlignedBB EAST_BLOCK_AABB = new AxisAlignedBB(1.0, 0.25, 0.25, 0.375, 1.0, 0.75);
    private static final AxisAlignedBB SOUTH_BLOCK_AABB = new AxisAlignedBB(0.25, 0.25, 0.375, 0.75, 1.0, 1.0);
    private static final AxisAlignedBB NORTH_BLOCK_AABB = new AxisAlignedBB(0.25, 0.25, 0.625, 0.75, 1.0, 0.0);
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    public static final PropertyBool ONWALL = PropertyBool.func_177716_a((String)"onwall");
    public static final PropertyBool ACTIVE = PropertyBool.func_177716_a((String)"active");

    public BlockSignalIndicator(String name, CreativeTabs tab) {
        super(Material.field_151573_f, name, tab);
        this.field_149784_t = 7;
    }

    public boolean func_176198_a(World worldIn, BlockPos pos, EnumFacing side) {
        if (side == EnumFacing.UP) {
            return worldIn.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)worldIn, pos) && worldIn.func_180495_p(pos.func_177984_a()).func_177230_c().func_176200_f((IBlockAccess)worldIn, pos.func_177984_a());
        }
        return super.func_176196_c(worldIn, pos);
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO()).func_177226_a((IProperty)ONWALL, (Comparable)Boolean.valueOf(facing != EnumFacing.UP)).func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false));
    }

    private boolean getSignal(IBlockAccess world, BlockPos pos) {
        TileEntitySignalIndicator te = (TileEntitySignalIndicator)world.func_175625_s(pos);
        return te.active();
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)worldIn, pos) && worldIn.func_180495_p(pos.func_177984_a()).func_177230_c().func_176200_f((IBlockAccess)worldIn, pos.func_177984_a());
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return state.func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(this.getSignal(world, pos)));
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (((Boolean)state.func_177229_b((IProperty)ONWALL)).booleanValue()) {
            switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
                default: {
                    return NORTH_BLOCK_AABB;
                }
                case SOUTH: {
                    return SOUTH_BLOCK_AABB;
                }
                case EAST: {
                    return EAST_BLOCK_AABB;
                }
                case WEST: 
            }
            return WEST_BLOCK_AABB;
        }
        return AABB;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, ONWALL, ACTIVE});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)(meta & 3))).func_177226_a((IProperty)ONWALL, (Comparable)Boolean.valueOf((meta & 4) > 0));
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        i |= ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
        if (((Boolean)state.func_177229_b((IProperty)ONWALL)).booleanValue()) {
            i |= 4;
        }
        return i;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Deprecated
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Deprecated
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @Override
    @Nullable
    public TileEntitySignalIndicator createTileEntity(World world, IBlockState state) {
        return new TileEntitySignalIndicator();
    }
}

