/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.entity;

import cassiokf.industrialrenewal.config.IRConfig;
import cassiokf.industrialrenewal.entity.TrainBase;
import cassiokf.industrialrenewal.init.ModItems;
import javax.annotation.Nullable;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public abstract class EntityFluidBase
extends TrainBase
implements IFluidHandler {
    private static final DataParameter<NBTTagCompound> TANK = EntityDataManager.func_187226_a(EntityFluidBase.class, (DataSerializer)DataSerializers.field_192734_n);
    public FluidTank tank;

    public EntityFluidBase(World worldIn) {
        super(worldIn);
        this.tank = new FluidTank(IRConfig.MainConfig.Main.fluidCartCapacity){

            protected void onContentsChanged() {
                EntityFluidBase.this.Sync();
            }
        };
        this.func_70105_a(1.0f, 1.0f);
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (FluidUtil.interactWithFluidHandler((EntityPlayer)player, (EnumHand)hand, (IFluidHandler)this.tank) && this.field_70170_p.field_72995_K) {
            player.func_184609_a(hand);
        }
        return super.func_184230_a(player, hand);
    }

    public EntityFluidBase(World worldIn, double x, double y, double z) {
        super(worldIn, x, y, z);
        this.tank = new /* invalid duplicate definition of identical inner class */;
    }

    public void func_94095_a(DamageSource source) {
        this.func_70106_y();
        if (!source.func_94541_c() && this.field_70170_p.func_82736_K().func_82766_b("doEntityDrops")) {
            this.func_70099_a(new ItemStack((Item)ModItems.cargoContainer, 1), 0.0f);
        }
    }

    public EntityMinecart.Type func_184264_v() {
        return EntityMinecart.Type.CHEST;
    }

    public ItemStack getCartItem() {
        return new ItemStack((Item)ModItems.cargoContainer);
    }

    public IFluidTankProperties[] getTankProperties() {
        return this.tank.getTankProperties();
    }

    public int fill(FluidStack resource, boolean doFill) {
        return this.tank.fill(resource, doFill);
    }

    @Nullable
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        return this.tank.drain(resource.amount, doDrain);
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        return this.tank.drain(maxDrain, doDrain);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.tank);
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        this.tank.readFromNBT(tag);
        this.field_70180_af.func_187227_b(TANK, (Object)tag.func_74775_l("tank"));
    }

    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        this.tank.writeToNBT(tag);
        tag.func_74782_a("tank", (NBTBase)this.field_70180_af.func_187225_a(TANK));
    }

    public void Sync() {
        if (!this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_187227_b(TANK, (Object)this.GetTag());
        }
    }

    public NBTTagCompound GetTag() {
        NBTTagCompound tankCompound = new NBTTagCompound();
        this.tank.writeToNBT(tankCompound);
        return tankCompound;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(TANK, (Object)new NBTTagCompound());
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        if (this.field_70170_p.field_72995_K && key.equals(TANK)) {
            this.tank.readFromNBT((NBTTagCompound)this.field_70180_af.func_187225_a(TANK));
        }
    }
}

