/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.gui;

import cassiokf.industrialrenewal.gui.GUIBase;
import cassiokf.industrialrenewal.gui.container.ContainerFluidLoader;
import cassiokf.industrialrenewal.init.ModBlocks;
import cassiokf.industrialrenewal.init.NetworkHandler;
import cassiokf.industrialrenewal.network.PacketReturnFluidLoader;
import cassiokf.industrialrenewal.tileentity.railroad.TileEntityFluidLoader;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GUIFluidLoader
extends GUIBase {
    private final TileEntityFluidLoader entity;

    public GUIFluidLoader(IInventory playerInv, TileEntityFluidLoader entity) {
        super(new ContainerFluidLoader(playerInv, entity), playerInv);
        this.entity = entity;
    }

    private String getGUIButtonText() {
        String waitE;
        switch (this.entity.getWaitEnum()) {
            case WAIT_FULL: {
                waitE = I18n.func_135052_a((String)"gui.industrialrenewal.button.waitfull", (Object[])new Object[0]);
                break;
            }
            case WAIT_EMPTY: {
                waitE = I18n.func_135052_a((String)"gui.industrialrenewal.button.waitempty", (Object[])new Object[0]);
                break;
            }
            case NO_ACTIVITY: {
                waitE = I18n.func_135052_a((String)"gui.industrialrenewal.button.noactivity", (Object[])new Object[0]);
                break;
            }
            default: {
                waitE = I18n.func_135052_a((String)"gui.industrialrenewal.button.never", (Object[])new Object[0]);
            }
        }
        return waitE;
    }

    private String getGUIModeText() {
        if (this.entity.isUnload()) {
            return I18n.func_135052_a((String)"gui.industrialrenewal.button.unloader_mode", (Object[])new Object[0]);
        }
        return I18n.func_135052_a((String)"gui.industrialrenewal.button.loader_mode", (Object[])new Object[0]);
    }

    protected void func_146284_a(GuiButton b) {
        if (b.field_146127_k == 0) {
            NetworkHandler.INSTANCE.sendToServer((IMessage)new PacketReturnFluidLoader(this.entity, false));
        }
        if (b.field_146127_k == 1) {
            NetworkHandler.INSTANCE.sendToServer((IMessage)new PacketReturnFluidLoader(this.entity, true));
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int posX1 = (this.field_146294_l - this.field_146999_f) / 2;
        int posY1 = (this.field_146295_m - this.field_147000_g) / 2;
        this.field_146292_n.add(new GuiButton(0, posX1 + 7, posY1 + 53, 61, 18, ""));
        this.field_146292_n.add(new GuiButton(1, posX1 + 7, posY1 + 18, 52, 18, ""));
    }

    @Override
    public String getTexturePath() {
        return "textures/gui/container/fluidloader.png";
    }

    @Override
    public String getTranslationKey() {
        return ModBlocks.fluidLoader.func_149739_a();
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        String waitE = this.getGUIButtonText();
        String mode = this.getGUIModeText();
        this.field_146289_q.func_78276_b(waitE, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(waitE) / 2 - 50, 59, 0xFFFFFF);
        this.field_146289_q.func_78276_b(mode, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(mode) / 2 - 55, 24, 0xFFFFFF);
        this.drawFluidBar(this.entity.tank, 80, 79);
        if (this.func_146978_c(79, 21, 18, 60, mouseX, mouseY)) {
            int amount = this.entity.tank.getFluidAmount();
            ArrayList<String> text = new ArrayList<String>();
            if (amount > 0) {
                text.add(TextFormatting.WHITE + "" + this.entity.tank.getFluid().getLocalizedName());
            }
            text.add(TextFormatting.GRAY + "" + amount + " / " + this.entity.tank.getCapacity() + " mB");
            this.func_146283_a(text, this.actualMouseX, this.actualMouseY);
        }
        if (this.func_146978_c(7, 53, 61, 18, mouseX, mouseY)) {
            ArrayList<String> text = new ArrayList<String>();
            text.add(TextFormatting.GRAY + I18n.func_135052_a((String)"gui.industrialrenewal.button.cargoloaderbutton0", (Object[])new Object[0]) + " " + TextFormatting.DARK_GREEN + waitE);
            this.func_146283_a(text, this.actualMouseX, this.actualMouseY);
        }
    }
}

