/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.handlers;

import cassiokf.industrialrenewal.init.IRSoundRegister;
import cassiokf.industrialrenewal.util.interfaces.IDynamicSound;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.ITickableSound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.audio.Sound;
import net.minecraft.client.audio.SoundEventAccessor;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class IRSoundHandler {
    private static final Minecraft mc = Minecraft.func_71410_x();
    private static final Map<Long, ISound> soundMap = new HashMap<Long, ISound>();

    public static boolean isSoundPlaying(BlockPos pos) {
        return soundMap.containsKey(pos.func_177986_g());
    }

    public static ISound playRepeatableSound(ResourceLocation soundLoc, float volume, float pitch, BlockPos pos) {
        Object s = soundMap.get(pos.func_177986_g());
        if (s == null || !mc.func_147118_V().func_147692_c(s)) {
            s = new PositionedSoundRecord(soundLoc, SoundCategory.BLOCKS, volume, pitch, true, 0, ISound.AttenuationType.LINEAR, (float)pos.func_177958_n() + 0.5f, (float)pos.func_177956_o() + 0.5f, (float)pos.func_177952_p() + 0.5f){

                public float func_147653_e() {
                    if (this.field_184367_a == null) {
                        this.func_184366_a(mc.func_147118_V());
                    }
                    return super.func_147653_e();
                }
            };
            IRSoundHandler.playSound(s);
            s = soundMap.get(pos.func_177986_g());
        }
        return s;
    }

    public static void stopTileSound(BlockPos pos) {
        long posKey = pos.func_177986_g();
        ISound s = soundMap.get(posKey);
        if (s != null) {
            mc.func_147118_V().func_147683_b(s);
            soundMap.remove(posKey);
        }
    }

    public static void playSound(ISound sound) {
        mc.func_147118_V().func_147682_a(sound);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onTilePlaySound(PlaySoundEvent event) {
        Object resultSound = event.getResultSound();
        if (resultSound == null) {
            return;
        }
        ResourceLocation soundLoc = event.getSound().func_147650_b();
        if (IRSoundRegister.TICKABLE_SOUNDS.contains((Object)soundLoc.toString())) {
            resultSound = new TileSound(event.getSound(), resultSound.func_147653_e(), 1.0f, true);
            event.setResultSound(resultSound);
        } else if (IRSoundRegister.REPEATABLE_SOUNDS.contains((Object)soundLoc.toString())) {
            ISound s = event.getSound();
            float vol = 0.4f;
            try {
                vol = resultSound.func_147653_e();
            }
            catch (Exception exception) {
                // empty catch block
            }
            resultSound = new TileSound(s, vol, 1.0f, false);
            event.setResultSound(resultSound);
        } else {
            return;
        }
        BlockPos pos = new BlockPos((double)(resultSound.func_147649_g() - 0.5f), (double)(resultSound.func_147654_h() - 0.5f), (double)resultSound.func_147651_i() - 0.5);
        soundMap.put(pos.func_177986_g(), (ISound)resultSound);
    }

    private static class TileSound
    implements ITickableSound {
        private final Minecraft mc = Minecraft.func_71410_x();
        private final int checkInterval = 1 + ThreadLocalRandom.current().nextInt(8);
        private final ISound sound;
        private float volume;
        private float pitch;
        private boolean donePlaying = false;
        private final boolean isDynamic;

        TileSound(ISound sound, float volume, float pitch, boolean isDynamic) {
            this.sound = sound;
            this.volume = volume;
            this.pitch = pitch;
            this.isDynamic = isDynamic;
        }

        public void func_73660_a() {
            if (this.isDynamic && this.mc.field_71441_e != null && this.mc.field_71441_e.func_82737_E() % (long)this.checkInterval == 0L) {
                TileEntity te = this.mc.field_71441_e.func_175625_s(new BlockPos((double)this.sound.func_147649_g(), (double)this.sound.func_147654_h(), (double)this.sound.func_147651_i()));
                if (te != null) {
                    if (te instanceof IDynamicSound) {
                        this.pitch = ((IDynamicSound)te).getPitch();
                        this.volume = ((IDynamicSound)te).getVolume();
                    }
                } else {
                    this.donePlaying = true;
                }
            }
        }

        public boolean func_147667_k() {
            return this.donePlaying;
        }

        public float func_147653_e() {
            return this.volume;
        }

        public float func_147655_f() {
            return this.pitch;
        }

        @Nonnull
        public ResourceLocation func_147650_b() {
            return this.sound.func_147650_b();
        }

        @Nullable
        public SoundEventAccessor func_184366_a(SoundHandler handler) {
            return this.sound.func_184366_a(handler);
        }

        @Nonnull
        public Sound func_184364_b() {
            return this.sound.func_184364_b();
        }

        @Nonnull
        public SoundCategory func_184365_d() {
            return this.sound.func_184365_d();
        }

        public boolean func_147657_c() {
            return this.sound.func_147657_c();
        }

        public int func_147652_d() {
            return this.sound.func_147652_d();
        }

        public float func_147649_g() {
            return this.sound.func_147649_g();
        }

        public float func_147654_h() {
            return this.sound.func_147654_h();
        }

        public float func_147651_i() {
            return this.sound.func_147651_i();
        }

        @Nonnull
        public ISound.AttenuationType func_147656_j() {
            return this.sound.func_147656_j();
        }
    }

    public static enum EnumSoundType {
        NORMAL,
        REPEATABLE_ONLY,
        DYNAMIC;

    }
}

