/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.handlers;

import cassiokf.industrialrenewal.config.IRConfig;
import cassiokf.industrialrenewal.util.Utils;
import cassiokf.industrialrenewal.util.interfaces.ISync;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.ItemStackHandler;

public class SteamBoiler {
    private final ISync tiedTE;
    private final int maxHeat = 32000;
    public static final String steamName = "Steam";
    public final FluidTank waterTank = new FluidTank(32000){

        public boolean canFillFluidType(FluidStack fluid) {
            return fluid != null && IRConfig.waterTypesContains(fluid.getFluid().getName());
        }

        public boolean canDrain() {
            return false;
        }

        public void onContentsChanged() {
            SteamBoiler.this.tiedTE.sync();
        }
    };
    public final FluidTank steamTank = new FluidTank(320000){

        public boolean canFill() {
            return false;
        }

        public boolean canDrain() {
            return false;
        }

        public void onContentsChanged() {
            SteamBoiler.this.tiedTE.sync();
        }
    };
    private boolean useSolid;
    private int amountPerTick;
    private int heat;
    private int oldHeat;
    private int waterPtick;
    private int fuelTime;
    private String fuelName;
    private int maxFuelTime;
    private int steamGenerated;
    private final FluidStack steamStack;
    public final FluidTank fuelTank;
    public final ItemStackHandler solidFuelInv;
    private int oldFuelTime;

    public SteamBoiler(ISync tiedTE, BoilerType useSolid, int amountPerTick) {
        this.waterPtick = IRConfig.MainConfig.Main.steamBoilerWaterPerTick;
        this.fuelName = "";
        this.steamStack = new FluidStack(FluidRegistry.getFluid((String)"steam"), 1000);
        this.fuelTank = new FluidTank(32000){

            public boolean canFillFluidType(FluidStack fluid) {
                return fluid != null && IRConfig.MainConfig.Main.fluidFuel.containsKey(fluid.getFluid().getName());
            }

            public int fill(FluidStack resource, boolean doFill) {
                return SteamBoiler.this.updateLiquidFuel(resource, doFill);
            }
        };
        this.solidFuelInv = new ItemStackHandler(1){

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                if (stack.func_190926_b()) {
                    return false;
                }
                return TileEntityFurnace.func_145954_b((ItemStack)stack);
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                return SteamBoiler.this.updateSolidFuel(stack, simulate);
            }
        };
        this.tiedTE = tiedTE;
        this.useSolid = useSolid == BoilerType.Solid;
        this.amountPerTick = amountPerTick;
    }

    public SteamBoiler setWaterTankCapacity(int amount) {
        this.waterTank.setCapacity(amount);
        return this;
    }

    public void onTick() {
        if (this.tiedTE.getThisWorld().field_72995_K) {
            return;
        }
        this.updateHeat();
        this.generateSteam();
        this.heat = MathHelper.func_76125_a((int)this.heat, (int)2420, (int)32000);
        this.fuelTime = Math.max(0, this.fuelTime);
        this.outPutSteam();
        if (this.steamTank.getFluidAmount() > 0 && this.heat < 9000) {
            this.steamTank.drainInternal(10, true);
        }
        if (this.oldHeat != this.heat || this.fuelTime != this.oldFuelTime) {
            this.oldHeat = this.heat;
            this.oldFuelTime = this.fuelTime;
            this.tiedTE.sync();
        }
    }

    private void generateSteam() {
        if (this.heat >= 10000 && this.waterTank.getFluidAmount() >= this.waterPtick && this.steamTank.getFluidAmount() < this.steamTank.getCapacity()) {
            float factor = Utils.normalize(this.heat, 10000.0f, 32000.0f);
            int amount = Math.round((float)this.waterPtick * factor);
            this.waterTank.drainInternal(amount, true);
            this.steamStack.amount = amount * IRConfig.MainConfig.Main.steamBoilerConversionFactor;
            this.steamGenerated = this.steamTank.fillInternal(this.steamStack, true);
            this.heat -= 4;
        } else {
            this.steamGenerated = 0;
            this.heat -= 2;
        }
    }

    public void outPutSteam() {
        IFluidHandler upTank;
        if (this.tiedTE.getThisWorld().field_72995_K || this.steamTank.getFluidAmount() <= 0) {
            return;
        }
        BlockPos pos = this.tiedTE.getThisPosition().func_177981_b(2);
        TileEntity tileEntity = this.tiedTE.getThisWorld().func_175625_s(pos);
        if (tileEntity != null && tileEntity.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.DOWN) && (upTank = (IFluidHandler)tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.DOWN)) != null) {
            this.steamTank.drainInternal(upTank.fill(this.steamTank.drainInternal(10000, false), true), true);
        }
    }

    public void setType(BoilerType type, int amountPerTick) {
        switch (type) {
            case Solid: {
                this.useSolid = true;
                break;
            }
            case Liquid: {
                this.useSolid = false;
            }
        }
        this.amountPerTick = amountPerTick;
        this.resetFuelTime();
    }

    public int getFuelTime() {
        return this.fuelTime;
    }

    public int getMaxFuelTime() {
        return this.maxFuelTime;
    }

    public String getFuelName() {
        return this.fuelName;
    }

    public int getHeat() {
        return this.heat;
    }

    public int getMaxHeat() {
        return 32000;
    }

    public int getWaterTankAmount() {
        return this.waterTank.getFluidAmount();
    }

    public void dropItemsOnGround(BlockPos pos) {
        Utils.dropInventoryItems(this.tiedTE.getThisWorld(), pos, this.solidFuelInv);
    }

    private ItemStack updateSolidFuel(ItemStack stack, boolean simulate) {
        if (!this.useSolid || this.fuelTime > 0) {
            return stack;
        }
        int fuel = TileEntityFurnace.func_145952_a((ItemStack)stack);
        if (fuel > 0) {
            if (!simulate) {
                this.maxFuelTime = this.fuelTime = fuel;
                this.fuelName = stack.func_82833_r();
                stack.func_190918_g(1);
            }
            ItemStack stack1 = stack.func_77946_l();
            stack1.func_190918_g(1);
            return simulate ? stack1 : stack;
        }
        return stack;
    }

    private void updateHeat() {
        if (this.fuelTime >= this.amountPerTick) {
            this.heat += 8;
            this.fuelTime -= this.amountPerTick;
        } else {
            this.heat -= 2;
        }
    }

    public void coolDown() {
        if (this.tiedTE.getThisWorld().field_72995_K) {
            return;
        }
        if (this.steamTank.getFluidAmount() > 0 && this.heat < 9000) {
            this.steamTank.drainInternal(10, true);
        }
        if (this.heat > 2420) {
            this.heat -= 6;
            this.tiedTE.sync();
        }
    }

    private int updateLiquidFuel(FluidStack resource, boolean doFill) {
        int fuel;
        if (this.useSolid) {
            return 0;
        }
        if (this.fuelTime > 0) {
            return 0;
        }
        int n = fuel = IRConfig.MainConfig.Main.fluidFuel.get(resource.getFluid().getName()) != null ? IRConfig.MainConfig.Main.fluidFuel.get(resource.getFluid().getName()) : 0;
        if (fuel > 0) {
            int amount = Math.min(1000, resource.amount);
            float norm = Utils.normalize(amount, 0.0f, 1000.0f);
            if (doFill) {
                this.maxFuelTime = this.fuelTime = (int)((float)fuel * norm);
                this.fuelName = resource.getLocalizedName();
            }
            return amount;
        }
        return 0;
    }

    public void resetFuelTime() {
        this.fuelTime = 0;
    }

    public void serialize(NBTTagCompound compound) {
        NBTTagCompound newTag = new NBTTagCompound();
        newTag.func_74768_a("fuelTime", this.fuelTime);
        newTag.func_74768_a("maxFuelTime", this.maxFuelTime);
        newTag.func_74768_a("amountPerTick", this.amountPerTick);
        newTag.func_74768_a("heat", this.heat);
        newTag.func_74768_a("steamGen", this.steamGenerated);
        newTag.func_74757_a("useSolid", this.useSolid);
        newTag.func_74778_a("fuelName", this.fuelName);
        newTag.func_74782_a("steam", (NBTBase)this.steamTank.writeToNBT(new NBTTagCompound()));
        newTag.func_74782_a("water", (NBTBase)this.waterTank.writeToNBT(new NBTTagCompound()));
        compound.func_74782_a("boiler", (NBTBase)newTag);
    }

    public void deserialize(NBTTagCompound compound) {
        NBTTagCompound nbt = compound.func_74775_l("boiler");
        this.fuelTime = nbt.func_74762_e("fuelTime");
        this.maxFuelTime = nbt.func_74762_e("maxFuelTime");
        this.amountPerTick = nbt.func_74762_e("amountPerTick");
        this.heat = nbt.func_74762_e("heat");
        this.steamGenerated = nbt.func_74762_e("steamGen");
        this.useSolid = nbt.func_74767_n("useSolid");
        this.fuelName = nbt.func_74779_i("fuelName");
        this.steamTank.readFromNBT(nbt.func_74775_l("steam"));
        this.waterTank.readFromNBT(nbt.func_74775_l("water"));
    }

    public boolean isBurning() {
        return this.fuelTime > 0;
    }

    public String getWaterText() {
        return FluidRegistry.WATER.getName();
    }

    public String getSteamText() {
        return steamName;
    }

    public String getFuelText() {
        return this.fuelTime > 0 ? this.fuelName : "No Fuel";
    }

    public String getHeatText() {
        return Utils.getConvertedTemperatureString((float)this.heat / 100.0f);
    }

    public float getFuelFill() {
        return Utils.normalize(this.fuelTime, 0.0f, this.maxFuelTime) * 180.0f;
    }

    public float GetWaterFill() {
        return Utils.normalize(this.waterTank.getFluidAmount(), 0.0f, this.waterTank.getCapacity()) * 180.0f;
    }

    public float GetSteamFill() {
        int maxValue = IRConfig.MainConfig.Main.steamBoilerWaterPerTick * IRConfig.MainConfig.Main.steamBoilerConversionFactor;
        return Utils.normalize(this.steamGenerated, 0.0f, maxValue) * 180.0f;
    }

    public float getHeatFill() {
        return Utils.normalize(this.getHeat(), 0.0f, this.getMaxHeat()) * 140.0f;
    }

    public static enum BoilerType {
        Solid,
        Liquid;

    }
}

