/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.item;

import cassiokf.industrialrenewal.item.ItemBase;
import cassiokf.industrialrenewal.util.Utils;
import cassiokf.industrialrenewal.world.generation.OreGeneration;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemProspectingPan
extends ItemBase {
    private static final String found = "Deep vein found size:";
    public static final String notFound = "No deep vein found";

    public ItemProspectingPan(String name, CreativeTabs tab) {
        super(name, tab);
        this.field_77777_bU = 1;
        this.func_77656_e(13);
        this.func_77642_a(this);
        this.func_185043_a(new ResourceLocation("broken"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                return ItemProspectingPan.isEmpty(stack) ? 0.0f : 1.0f;
            }
        });
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(I18n.func_135052_a((String)"info.industrialrenewal.prospectingpan.info", (Object[])new Object[0]));
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public static boolean isEmpty(ItemStack stack) {
        return stack.func_77952_i() == 0;
    }

    public boolean func_82789_a(ItemStack itemToRepair, ItemStack resourceItem) {
        return false;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (worldIn.field_73011_w.getDimension() == 0 && stack.func_77952_i() <= 0) {
            if (!worldIn.field_72995_K) {
                stack.func_77964_b(1);
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (worldIn.field_73011_w.getDimension() == 0 && stack.func_77952_i() > 0) {
            playerIn.func_184609_a(handIn);
            ItemProspectingPan.prospect(worldIn, playerIn, stack);
            return new ActionResult(EnumActionResult.PASS, (Object)playerIn.func_184586_b(handIn));
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    private static void prospect(World worldIn, EntityPlayer playerIn, ItemStack panStack) {
        if (worldIn.field_72995_K) {
            return;
        }
        panStack.func_77972_a(1, (EntityLivingBase)playerIn);
        if (panStack.func_77952_i() >= 12) {
            ItemStack stackV = OreGeneration.getChunkVein(worldIn, playerIn.func_180425_c());
            boolean hasVein = !stackV.func_190926_b();
            String msg = hasVein ? stackV.func_82833_r() + " " + found + " " + stackV.func_190916_E() : notFound;
            Utils.sendChatMessage(playerIn, msg);
            panStack.func_77964_b(0);
        }
    }

    public ItemStack getContainerItem(ItemStack stack) {
        int dmg = stack.func_77952_i();
        if (dmg == this.getMaxDamage(stack)) {
            return new ItemStack(stack.func_77973_b(), 0, this.getMaxDamage(stack));
        }
        ItemStack tr = new ItemStack(stack.func_77973_b(), 1, stack.func_77952_i());
        tr.func_77964_b(dmg + 1);
        return tr;
    }
}

