/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.tileentity;

import cassiokf.industrialrenewal.config.IRConfig;
import cassiokf.industrialrenewal.tileentity.abstracts.TEMultiTankBase;
import cassiokf.industrialrenewal.util.Utils;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TEFluidTank
extends TEMultiTankBase<TEFluidTank> {
    public final FluidTank inTank = new FluidTank(capacity){

        public int fill(FluidStack resource, boolean doFill) {
            return ((TEFluidTank)TEFluidTank.this.getBottomTE()).tank.fillInternal(resource, doFill);
        }

        public boolean canDrain() {
            return false;
        }
    };
    public final FluidTank tank = new FluidTank(capacity){

        public boolean canFill() {
            return false;
        }

        public boolean canDrain() {
            return false;
        }

        protected void onContentsChanged() {
            TEFluidTank.this.sync();
        }
    };
    public static final int capacity = IRConfig.MainConfig.Main.barrelCapacity * 10;

    @Override
    public void tick() {
        IFluidHandler handler;
        TileEntity te;
        if (!this.field_145850_b.field_72995_K && this.isMaster() && this.isBottom() && this.tank.getFluidAmount() > 0 && (te = this.field_145850_b.func_175625_s(this.getOutPos())) != null && (handler = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.getMasterFacing())) != null) {
            this.tank.drainInternal(handler.fill(this.tank.drainInternal(1000, false), true), true);
        }
    }

    @Override
    public boolean instanceOf(TileEntity tileEntity) {
        return tileEntity instanceof TEFluidTank;
    }

    @Override
    public void setSize(int i) {
        int cap = i * capacity;
        if (cap < 0) {
            cap = Integer.MAX_VALUE;
        }
        if (cap < this.tank.getFluidAmount()) {
            FluidStack stack = this.tank.getFluid();
            stack.amount = cap;
        }
        this.tank.setCapacity(cap);
        this.sync();
    }

    public String getFluidName() {
        String name = this.tank.getFluidAmount() > 0 ? this.tank.getFluid().getLocalizedName() : "Empty";
        return name + ": " + this.tank.getFluidAmount() / 1000 + "B / " + this.tank.getCapacity() / 1000 + "B";
    }

    public float getFluidAngle() {
        return Utils.normalize(this.tank.getFluidAmount(), 0.0f, this.tank.getCapacity()) * 180.0f;
    }

    private BlockPos getOutPos() {
        return this.field_174879_c.func_177977_b().func_177967_a(this.getMasterFacing().func_176734_d(), 2);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        EnumFacing downFace = this.getMasterFacing().func_176734_d();
        TEFluidTank master = (TEFluidTank)this.getMaster();
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            if (facing == downFace && this.field_174879_c.equals((Object)master.field_174879_c.func_177977_b().func_177972_a(downFace))) {
                return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)master.tank);
            }
            if (facing == EnumFacing.UP && this.field_174879_c.equals((Object)master.field_174879_c.func_177984_a())) {
                return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)master.inTank);
            }
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        this.tank.writeToNBT(compound);
        compound.func_74768_a("tankCap", this.tank.getCapacity());
        return super.func_189515_b(compound);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        this.tank.readFromNBT(compound);
        this.tank.setCapacity(compound.func_74762_e("tankCap"));
        super.func_145839_a(compound);
    }
}

