/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.tileentity;

import cassiokf.industrialrenewal.tileentity.abstracts.TEMultiTankBase;
import cassiokf.industrialrenewal.util.MachinesUtils;
import cassiokf.industrialrenewal.util.MultiStackHandler;
import cassiokf.industrialrenewal.util.Utils;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;

public class TEStorage
extends TEMultiTankBase<TEStorage> {
    private final MultiStackHandler inventory = new MultiStackHandler(4096, true, this);
    private static final int capacity = 4096;

    @Override
    public List<BlockPos> getListOfBlockPositions(BlockPos centerPosition) {
        return MachinesUtils.getBlocksIn3x3x2Centered(centerPosition, this.getMasterFacing());
    }

    @Override
    public void setSize(int i) {
        int newCapacity = 4096 * i;
        if (this.inventory.getCount() > newCapacity) {
            this.spawnItems(this.inventory.getCount() - newCapacity);
        }
        this.inventory.setSlotLimit(4096 * i);
    }

    @Override
    public void onMasterBreak() {
        super.onMasterBreak();
        if (this.isBottom() && this.inventory.getCount() > 0) {
            this.spawnItems(this.inventory.getCount());
        }
    }

    private void spawnItems(int quantity) {
        ItemStack sStack;
        int temQ;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        ItemStack stack = this.inventory.getStackInSlot(0).func_77946_l();
        for (temQ = quantity; temQ >= stack.func_77976_d(); temQ -= stack.func_77976_d()) {
            sStack = stack.func_77946_l();
            sStack.func_190920_e(stack.func_77976_d());
            Utils.spawnItemStack(this.field_145850_b, this.field_174879_c.func_177967_a(this.getMasterFacing().func_176734_d(), 2), sStack);
        }
        if (temQ > 0) {
            sStack = stack.func_77946_l();
            sStack.func_190920_e(temQ);
            Utils.spawnItemStack(this.field_145850_b, this.field_174879_c.func_177967_a(this.getMasterFacing().func_176734_d(), 2), sStack);
        }
        this.inventory.removeFromCount(quantity);
    }

    public ItemStack getStack() {
        return this.inventory.getStackInSlot(0);
    }

    public int getCount() {
        return this.inventory.getCount();
    }

    public int getCapacity() {
        return this.inventory.getSlotLimit(0);
    }

    @Override
    public boolean instanceOf(TileEntity tileEntity) {
        return tileEntity instanceof TEStorage;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability.equals((Object)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)((TEStorage)((TEStorage)this.getMaster()).getBottomTE()).inventory);
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74782_a("inv", (NBTBase)this.inventory.serializeNBT());
        return super.func_189515_b(compound);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        this.inventory.deserializeNBT(compound.func_74775_l("inv"));
        super.func_145839_a(compound);
    }
}

