/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.tileentity;

import cassiokf.industrialrenewal.IndustrialRenewal;
import cassiokf.industrialrenewal.config.IRConfig;
import cassiokf.industrialrenewal.init.NetworkHandler;
import cassiokf.industrialrenewal.network.PacketStorageChest;
import cassiokf.industrialrenewal.tileentity.abstracts.TEMultiTankBase;
import cassiokf.industrialrenewal.util.InventoryHandler;
import cassiokf.industrialrenewal.util.MachinesUtils;
import cassiokf.industrialrenewal.util.Utils;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;

public class TEStorageChest
extends TEMultiTankBase<TEStorageChest> {
    private static final int slots = 99;
    public final InventoryHandler inventory = new InventoryHandler(99){

        protected void onContentsChanged(int slot) {
            TEStorageChest.this.func_70296_d();
        }

        @Override
        public void itemsToSpawn(List<ItemStack> list) {
            for (ItemStack item : list) {
                TEStorageChest.this.spawnItems(item);
            }
        }
    };
    public int additionalLines;
    public int currentLine;
    public String search = "";
    public boolean searchActive;

    public TEStorageChest() {
        this.searchActive = IRConfig.MainConfig.Main.searchBarStartFocused;
    }

    @Override
    public List<BlockPos> getListOfBlockPositions(BlockPos centerPosition) {
        return MachinesUtils.getBlocksIn3x3x2Centered(centerPosition, this.getMasterFacing());
    }

    public void guiButtonClick(int id, EntityPlayer player) {
        if (id == 1 && this.currentLine > 0) {
            --this.currentLine;
        } else if (id == 2 && this.currentLine < this.additionalLines) {
            ++this.currentLine;
        }
        this.openGui(player, false);
    }

    public void openGui(EntityPlayer player, boolean resetLine) {
        if (resetLine) {
            this.currentLine = 0;
            this.search = "";
            this.searchActive = IRConfig.MainConfig.Main.searchBarStartFocused;
        }
        if (!this.field_145850_b.field_72995_K) {
            player.openGui((Object)IndustrialRenewal.instance, 12, this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
        }
    }

    public void setLineValues(int currentLine, int additionalLines) {
        this.currentLine = currentLine;
        this.additionalLines = additionalLines;
    }

    @Override
    public void setSize(int i) {
        int newCapacity = 99 * i;
        if (newCapacity < 0) {
            newCapacity = Integer.MAX_VALUE;
        }
        this.additionalLines = newCapacity / 11 - 6;
        this.currentLine = 0;
        this.inventory.setInvSize(newCapacity);
        NetworkHandler.INSTANCE.sendToAll((IMessage)new PacketStorageChest(this));
        this.func_70296_d();
    }

    @Override
    public void onMasterBreak() {
        super.onMasterBreak();
        Utils.dropInventoryItems(this.field_145850_b, this.field_174879_c, this.inventory);
    }

    private void spawnItems(ItemStack stack) {
        if (!stack.func_190926_b()) {
            Utils.spawnItemStack(this.field_145850_b, this.field_174879_c.func_177967_a(this.getMasterFacing().func_176734_d(), 2), stack);
        }
    }

    @Override
    public boolean instanceOf(TileEntity tileEntity) {
        return tileEntity instanceof TEStorageChest;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability.equals((Object)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)((TEStorageChest)((TEStorageChest)this.getMaster()).getBottomTE()).inventory);
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74782_a("inv", (NBTBase)this.inventory.serializeNBT());
        return super.func_189515_b(compound);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        this.inventory.deserializeNBT(compound.func_74775_l("inv"));
        super.func_145839_a(compound);
    }
}

