/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.tileentity;

import cassiokf.industrialrenewal.blocks.abstracts.BlockTileEntityConnected;
import cassiokf.industrialrenewal.config.IRConfig;
import cassiokf.industrialrenewal.tileentity.abstracts.TileEntitySync;
import cassiokf.industrialrenewal.util.Utils;
import cassiokf.industrialrenewal.util.VoltsEnergyContainer;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class TileEntityBatteryBank
extends TileEntitySync
implements ITickable {
    private final VoltsEnergyContainer container;
    private final VoltsEnergyContainer dummyEnergy;
    private final Set<EnumFacing> outPutFacings = new HashSet<EnumFacing>();
    private EnumFacing blockFacing;

    public TileEntityBatteryBank() {
        this.container = new VoltsEnergyContainer(IRConfig.MainConfig.Main.batteryBankCapacity, IRConfig.MainConfig.Main.batteryBankMaxInput, IRConfig.MainConfig.Main.batteryBankMaxOutput){

            @Override
            public void onEnergyChange() {
                if (!((TileEntityBatteryBank)TileEntityBatteryBank.this).field_145850_b.field_72995_K) {
                    TileEntityBatteryBank.this.sync();
                }
            }
        };
        this.dummyEnergy = new VoltsEnergyContainer(0, 0, 0){

            @Override
            public boolean canReceive() {
                return false;
            }
        };
    }

    public void func_73660_a() {
        if (this.func_145830_o() && !this.field_145850_b.field_72995_K) {
            for (EnumFacing face : this.outPutFacings) {
                IEnergyStorage eStorage;
                TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(face));
                if (te == null || (eStorage = (IEnergyStorage)te.getCapability(CapabilityEnergy.ENERGY, face.func_176734_d())) == null || !eStorage.canReceive()) continue;
                this.container.extractEnergy(eStorage.receiveEnergy(this.container.extractEnergy(this.container.getMaxOutput(), true), false), false);
            }
        }
    }

    public boolean toggleFacing(EnumFacing facing) {
        if (this.outPutFacings.contains(facing)) {
            this.outPutFacings.remove(facing);
            this.sync();
            return false;
        }
        this.outPutFacings.add(facing);
        this.sync();
        return true;
    }

    public boolean isFacingOutput(@Nullable EnumFacing facing) {
        return this.outPutFacings.contains(facing) || facing == null;
    }

    public String GetText() {
        return Utils.formatEnergyString(this.container.getEnergyStored());
    }

    public EnumFacing getBlockFacing() {
        if (this.blockFacing != null) {
            return this.blockFacing;
        }
        return this.forceFaceCheck();
    }

    public EnumFacing forceFaceCheck() {
        this.blockFacing = (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockTileEntityConnected.FACING);
        return this.blockFacing;
    }

    public float getBatteryFill() {
        return Utils.normalize(this.container.getEnergyStored(), 0.0f, this.container.getMaxEnergyStored());
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY && this.isFacingOutput(facing)) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)this.dummyEnergy);
        }
        if (capability == CapabilityEnergy.ENERGY && facing != this.getBlockFacing().func_176734_d()) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)this.container);
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_145839_a(NBTTagCompound compound) {
        int[] enabledFacingIndices;
        this.container.deserializeNBT(compound.func_74775_l("StoredIR"));
        this.outPutFacings.clear();
        for (int index : enabledFacingIndices = compound.func_74759_k("OutputFacings")) {
            this.outPutFacings.add(EnumFacing.func_82600_a((int)index));
        }
        this.blockFacing = EnumFacing.func_176731_b((int)compound.func_74762_e("face"));
        super.func_145839_a(compound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74782_a("StoredIR", (NBTBase)this.container.serializeNBT());
        int[] enabledFacingIndices = this.outPutFacings.stream().mapToInt(EnumFacing::func_176745_a).toArray();
        compound.func_74783_a("OutputFacings", enabledFacingIndices);
        compound.func_74768_a("face", this.getBlockFacing().func_176736_b());
        return super.func_189515_b(compound);
    }
}

