/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.tileentity;

import cassiokf.industrialrenewal.blocks.BlockBulkConveyor;
import cassiokf.industrialrenewal.config.IRConfig;
import cassiokf.industrialrenewal.tileentity.abstracts.TileEntitySync;
import cassiokf.industrialrenewal.util.Utils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityBulkConveyor
extends TileEntitySync
implements ITickable {
    public static final int frontNumber = 2;
    public static final int middleNumber = 1;
    public static final int backNumber = 0;
    private static final int tickSpeed = 4;
    private int frontTick;
    private int middleTick;
    private int backTick;
    private float oldFrontTick;
    private float oldMiddleTick;
    private float oldBackTick;
    private float rFrontTick;
    private float rMiddleTick;
    public ItemStackHandler inventory = new ItemStackHandler(3){

        public int getSlots() {
            return 1;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return this.getStackInSlot(slot).func_190926_b() && super.isItemValid(slot, stack);
        }

        protected void onContentsChanged(int slot) {
            TileEntityBulkConveyor.this.func_70296_d();
            TileEntityBulkConveyor.this.itemReceived(slot);
        }
    };
    private float rBackTick;
    private EnumFacing facing;

    public void func_73660_a() {
        boolean moved = false;
        if (!this.inventory.getStackInSlot(2).func_190926_b()) {
            if (this.frontTick >= 4) {
                moved = this.updateFrontStack();
            }
            if (this.frontTick < 4) {
                ++this.frontTick;
            }
            this.oldFrontTick = this.rFrontTick;
            this.rFrontTick = Utils.normalize(this.frontTick, 0.0f, 4.0f);
            if (moved) {
                return;
            }
        } else {
            this.oldFrontTick = 0.0f;
            this.rFrontTick = 0.0f;
        }
        if (!this.inventory.getStackInSlot(1).func_190926_b()) {
            if (this.middleTick >= 4) {
                moved = this.updateMiddleStack();
            }
            if (this.middleTick < 4) {
                ++this.middleTick;
            }
            this.oldMiddleTick = this.rMiddleTick;
            this.rMiddleTick = Utils.normalize(this.middleTick, 0.0f, 4.0f);
            if (moved) {
                return;
            }
        }
        if (!this.inventory.getStackInSlot(0).func_190926_b()) {
            if (this.backTick >= 4) {
                this.updateBackStack();
            }
            if (this.backTick < 4) {
                ++this.backTick;
            }
            this.oldBackTick = this.rBackTick;
            this.rBackTick = Utils.normalize(this.backTick, 0.0f, 4.0f);
        }
    }

    public void itemReceived(int slot) {
        if (slot == 2) {
            this.frontTick = 0;
            this.oldFrontTick = 0.0f;
            this.rFrontTick = 0.0f;
        } else if (slot == 1) {
            this.middleTick = 0;
            this.oldMiddleTick = 0.0f;
            this.rMiddleTick = 0.0f;
        } else if (slot == 0) {
            this.backTick = 0;
            this.oldBackTick = 0.0f;
            this.rMiddleTick = 0.0f;
        }
        this.sync();
    }

    private boolean updateFrontStack() {
        if (this.field_145850_b.field_72995_K) {
            return false;
        }
        ItemStack frontPositionItem = this.inventory.getStackInSlot(2);
        IBlockState ownState = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (!(ownState.func_177230_c() instanceof BlockBulkConveyor)) {
            return false;
        }
        EnumFacing facing = this.getBlockFacing();
        if (!frontPositionItem.func_190926_b()) {
            BlockPos frontPos = this.field_174879_c.func_177972_a(facing);
            int mode = (Integer)ownState.func_185899_b((IBlockAccess)this.field_145850_b, this.field_174879_c).func_177229_b((IProperty)BlockBulkConveyor.MODE);
            BlockPos targetConveyorPos = this.frontConveyor(facing, mode);
            if (targetConveyorPos != null) {
                TileEntity tileEntity = this.field_145850_b.func_175625_s(targetConveyorPos);
                if (tileEntity instanceof TileEntityBulkConveyor) {
                    TileEntityBulkConveyor te = (TileEntityBulkConveyor)tileEntity;
                    if (te.getBlockFacing() == this.getBlockFacing() && te.transferItem(frontPositionItem, false)) {
                        this.inventory.setStackInSlot(2, ItemStack.field_190927_a);
                        return true;
                    }
                    if (te.getBlockFacing() != this.getBlockFacing().func_176734_d() && te.getStackInSlot(1).func_190926_b() && te.transferItem(frontPositionItem, 1, false)) {
                        this.inventory.setStackInSlot(2, ItemStack.field_190927_a);
                        return true;
                    }
                }
            } else if (this.field_145850_b.func_180495_p(frontPos).func_185904_a() == Material.field_151579_a) {
                this.dropFrontItem(facing, frontPositionItem, frontPos);
                return true;
            }
        }
        return false;
    }

    private boolean updateMiddleStack() {
        if (this.field_145850_b.field_72995_K) {
            return false;
        }
        ItemStack MiddlePositionItem = this.inventory.getStackInSlot(1);
        ItemStack frontPositionItem = this.inventory.getStackInSlot(2);
        if (frontPositionItem.func_190926_b() && !MiddlePositionItem.func_190926_b()) {
            this.moveItemInternally(1, 2);
            return true;
        }
        return false;
    }

    private void updateBackStack() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        ItemStack backPositionItem = this.inventory.getStackInSlot(0);
        ItemStack MiddlePositionItem = this.inventory.getStackInSlot(1);
        if (!backPositionItem.func_190926_b() && MiddlePositionItem.func_190926_b()) {
            this.moveItemInternally(0, 1);
        }
    }

    public float getStackOffset(int slot, boolean old) {
        switch (slot) {
            default: {
                return old ? this.oldFrontTick : this.rFrontTick;
            }
            case 1: {
                return old ? this.oldMiddleTick : this.rMiddleTick;
            }
            case 0: 
        }
        return old ? this.oldBackTick : this.rBackTick;
    }

    public float getMinYOffset(int slot, int mode) {
        switch (slot) {
            default: {
                return mode == 0 ? 0.6f : 1.1f;
            }
            case 1: {
                if (mode == 1) {
                    return 0.78f;
                }
                if (mode == 2) {
                    return 1.43f;
                }
                return 0.61f;
            }
            case 0: 
        }
        if (mode == 1) {
            return 0.43f;
        }
        if (mode == 2) {
            return 1.78f;
        }
        return 0.6f;
    }

    public float getMaxYOffset(int mode) {
        if (mode == 0) {
            return 0.0f;
        }
        if (mode == 1) {
            return 0.46f;
        }
        return -0.46f;
    }

    private BlockPos frontConveyor(EnumFacing facing, int mode) {
        BlockPos frontPos = this.field_174879_c.func_177972_a(facing);
        if (mode == 1 || !(this.field_145850_b.func_180495_p(frontPos).func_177230_c() instanceof BlockBulkConveyor)) {
            frontPos = mode == 1 ? this.field_174879_c.func_177972_a(facing).func_177984_a() : this.field_174879_c.func_177972_a(facing).func_177977_b();
        } else {
            return frontPos;
        }
        IBlockState frontState = this.field_145850_b.func_180495_p(frontPos);
        return frontState.func_177230_c() instanceof BlockBulkConveyor && frontState.func_177229_b((IProperty)BlockBulkConveyor.FACING) == this.getBlockFacing() ? frontPos : null;
    }

    private void moveItemInternally(int from, int to) {
        this.inventory.setStackInSlot(to, this.inventory.getStackInSlot(from));
        this.inventory.setStackInSlot(from, ItemStack.field_190927_a);
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    public boolean transferItem(ItemStack stack, boolean simulate) {
        return this.transferItem(stack, 0, simulate);
    }

    public boolean transferItem(ItemStack stack, int slot, boolean simulate) {
        if (this.inventory.getStackInSlot(0).func_190926_b() && !stack.func_190926_b()) {
            if (!simulate) {
                this.inventory.setStackInSlot(slot, stack);
            }
            return true;
        }
        return false;
    }

    public void dropFrontItem(EnumFacing facing, ItemStack frontPositionItem, BlockPos frontPos) {
        double multiplierX = BlockBulkConveyor.getMotionX(facing);
        double multiplierZ = BlockBulkConveyor.getMotionZ(facing);
        EntityItem entityitem = new EntityItem(this.field_145850_b, (double)frontPos.func_177958_n() + 0.5, (double)frontPos.func_177956_o() + 0.5, (double)frontPos.func_177952_p() + 0.5, frontPositionItem);
        entityitem.field_70181_x = 0.0;
        entityitem.field_70159_w = multiplierX * 0.2;
        entityitem.field_70179_y = multiplierZ * 0.2;
        this.field_145850_b.func_72838_d((Entity)entityitem);
        this.inventory.setStackInSlot(2, ItemStack.field_190927_a);
    }

    public void dropInventory() {
        Utils.dropInventoryItems(this.field_145850_b, this.field_174879_c, this.inventory);
    }

    public int getMode() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c).func_185899_b((IBlockAccess)this.field_145850_b, this.field_174879_c);
        return state.func_177230_c() instanceof BlockBulkConveyor ? (Integer)state.func_177229_b((IProperty)BlockBulkConveyor.MODE) : 0;
    }

    public ItemStack getStackInSlot(int slot) {
        return this.inventory.getStackInSlot(slot).func_77946_l();
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (facing == this.getBlockFacing().func_176734_d() && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.inventory);
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.frontTick = compound.func_74762_e("rFront");
        this.middleTick = compound.func_74762_e("rMiddle");
        this.backTick = compound.func_74762_e("rBack");
        this.rFrontTick = compound.func_74760_g("oFront");
        this.rMiddleTick = compound.func_74760_g("oMiddle");
        this.rBackTick = compound.func_74760_g("oBack");
        this.inventory.deserializeNBT(compound.func_74775_l("inv"));
        super.func_145839_a(compound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("rFront", this.frontTick);
        compound.func_74768_a("rMiddle", this.middleTick);
        compound.func_74768_a("rBack", this.backTick);
        compound.func_74776_a("oFront", this.rFrontTick);
        compound.func_74776_a("oMiddle", this.rMiddleTick);
        compound.func_74776_a("oBack", this.rBackTick);
        compound.func_74782_a("inv", (NBTBase)this.inventory.serializeNBT());
        return super.func_189515_b(compound);
    }

    public EnumFacing getBlockFacing() {
        if (this.facing != null) {
            return this.facing;
        }
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (state.func_177230_c() instanceof BlockBulkConveyor) {
            this.facing = (EnumFacing)state.func_177229_b((IProperty)BlockBulkConveyor.FACING);
            return this.facing;
        }
        return EnumFacing.NORTH;
    }

    public void setFacing(EnumFacing facing) {
        this.facing = facing;
    }

    public double func_145833_n() {
        return super.func_145833_n() * IRConfig.MainConfig.Render.conveyorsItemsRenderMult;
    }
}

