/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.tileentity;

import cassiokf.industrialrenewal.blocks.BlockBunkerHatch;
import cassiokf.industrialrenewal.config.IRConfig;
import cassiokf.industrialrenewal.init.IRSoundRegister;
import cassiokf.industrialrenewal.tileentity.abstracts.TEBase;
import cassiokf.industrialrenewal.util.MachinesUtils;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;

public class TileEntityBunkerHatch
extends TEBase {
    private boolean master;
    private boolean breaking;
    private TileEntityBunkerHatch masterTE;
    private boolean masterChecked = false;

    public TileEntityBunkerHatch getMaster() {
        List<BlockPos> list = MachinesUtils.getBlocksIn3x1x3Centered(this.field_174879_c);
        for (BlockPos currentPos : list) {
            TileEntityBunkerHatch te;
            if (!(this.field_145850_b.func_175625_s(currentPos) instanceof TileEntityBunkerHatch) || (te = (TileEntityBunkerHatch)this.field_145850_b.func_175625_s(currentPos)) == null || !te.isMaster()) continue;
            return te;
        }
        this.field_145850_b.func_175698_g(this.field_174879_c);
        this.field_145850_b.func_175713_t(this.field_174879_c);
        return null;
    }

    public void changeOpen() {
        if (!this.isMaster()) {
            if (this.getMaster() != null) {
                this.getMaster().changeOpen();
            }
            return;
        }
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        boolean value = (Boolean)state.func_177229_b((IProperty)BlockBunkerHatch.OPEN) == false;
        this.changeOpenFromMaster(value);
        if (value) {
            this.field_145850_b.func_184133_a(null, this.field_174879_c, IRSoundRegister.BLOCK_CATWALKGATE_CLOSE, SoundCategory.NEUTRAL, 1.0f * IRConfig.MainConfig.Sounds.masterVolumeMult, 1.0f);
        } else {
            this.field_145850_b.func_184133_a(null, this.field_174879_c, IRSoundRegister.BLOCK_CATWALKGATE_OPEN, SoundCategory.NEUTRAL, 1.0f * IRConfig.MainConfig.Sounds.masterVolumeMult, 1.0f);
        }
    }

    @Override
    public void onBlockBreak() {
        if (!this.isMaster()) {
            if (this.getMaster() != null) {
                this.getMaster().onBlockBreak();
            }
            return;
        }
        if (!this.breaking) {
            this.breaking = true;
            List<BlockPos> list = MachinesUtils.getBlocksIn3x1x3Centered(this.field_174879_c);
            for (BlockPos currentPos : list) {
                Block block = this.field_145850_b.func_180495_p(currentPos).func_177230_c();
                if (!(block instanceof BlockBunkerHatch)) continue;
                this.field_145850_b.func_175698_g(currentPos);
            }
        }
    }

    public void changeOpenFromMaster(boolean value) {
        List<BlockPos> list = MachinesUtils.getBlocksIn3x1x3Centered(this.field_174879_c);
        for (BlockPos currentPos : list) {
            IBlockState state = this.field_145850_b.func_180495_p(currentPos);
            if (!(state.func_177230_c() instanceof BlockBunkerHatch)) continue;
            this.field_145850_b.func_175656_a(currentPos, state.func_177226_a((IProperty)BlockBunkerHatch.OPEN, (Comparable)Boolean.valueOf(value)));
        }
    }

    public boolean isMaster() {
        if (this.masterChecked) {
            return this.master;
        }
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.master = !(state.func_177230_c() instanceof BlockBunkerHatch) ? false : (Boolean)state.func_177229_b((IProperty)BlockBunkerHatch.MASTER);
        return this.master;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74757_a("master", this.isMaster());
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.master = compound.func_74767_n("master");
        super.func_145839_a(compound);
    }
}

