/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.tileentity;

import cassiokf.industrialrenewal.blocks.BlockChunkLoader;
import cassiokf.industrialrenewal.config.IRConfig;
import cassiokf.industrialrenewal.handlers.ChunkManagerCallback;
import cassiokf.industrialrenewal.tileentity.abstracts.TEBase;
import com.google.common.collect.Lists;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.ForgeChunkManager;

public class TileEntityChunkLoader
extends TEBase
implements ITickable {
    private static final int ACTIVE_STATE_CHANGED = 1;
    @Nonnull
    private final List<ForgeChunkManager.Ticket> tickets = Lists.newArrayList();
    @Nonnull
    private final List<WeakReference<EntityPlayer>> trackedPlayers = new LinkedList<WeakReference<EntityPlayer>>();
    private long expireTime = -1L;
    private boolean isActive;
    private boolean master;

    public void setTicket(@Nonnull ForgeChunkManager.Ticket ticket) {
        String playerName = ticket.getPlayerName();
        Iterator<ForgeChunkManager.Ticket> iterator = this.tickets.iterator();
        while (iterator.hasNext()) {
            ForgeChunkManager.Ticket next = iterator.next();
            if (!next.getPlayerName().equals(playerName)) continue;
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)next);
            iterator.remove();
        }
        this.tickets.add(ticket);
        this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 1, 1);
        this.expireTime = -1L;
    }

    public void addTrackedPlayer(@Nullable EntityPlayer player) {
        for (WeakReference<EntityPlayer> trackedPlayerReference : this.trackedPlayers) {
            EntityPlayer trackedPlayer = (EntityPlayer)trackedPlayerReference.get();
            if (trackedPlayer == null || player == null || player.func_70005_c_() != trackedPlayer.func_70005_c_()) continue;
            return;
        }
        this.trackedPlayers.add(new WeakReference<EntityPlayer>(player));
    }

    public void func_73660_a() {
        if (IRConfig.MainConfig.Main.emergencyMode || !this.master) {
            return;
        }
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.tickets.isEmpty()) {
            return;
        }
        if (!IRConfig.MainConfig.Main.needPlayerToActivateChunkLoading) {
            return;
        }
        long totalWorldTime = this.field_145850_b.func_82737_E();
        if ((totalWorldTime & 0x1FL) != 31L) {
            return;
        }
        boolean trackedPlayersOnline = this.checkOnlinePlayers();
        boolean gadgetIsValid = this.checkPlayersLoggedOn(trackedPlayersOnline);
        if (!gadgetIsValid && this.expireTime == -1L) {
            int timeout = IRConfig.MainConfig.Main.hoursBeforeChunkLoadingDeactivation * 60 * 60 * 20;
            this.expireTime = totalWorldTime + (long)timeout;
        }
        if (this.expireTime != -1L && totalWorldTime >= this.expireTime) {
            this.disable();
        }
    }

    private boolean checkPlayersLoggedOn(boolean trackedPlayersOnline) {
        if (trackedPlayersOnline) {
            return true;
        }
        boolean gadgetIsValid = false;
        for (ForgeChunkManager.Ticket ticket : this.tickets) {
            EntityPlayerMP playerEntityByName = ChunkManagerCallback.getOnlinePlayerByName(this.field_145850_b.func_73046_m(), ticket.getPlayerName());
            if (playerEntityByName == null) continue;
            this.expireTime = -1L;
            this.trackedPlayers.add(new WeakReference<EntityPlayerMP>(playerEntityByName));
            this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 1, 1);
            gadgetIsValid = true;
        }
        return gadgetIsValid;
    }

    private boolean checkOnlinePlayers() {
        boolean trackedPlayersOnline = false;
        Iterator<WeakReference<EntityPlayer>> trackedPlayerIterator = this.trackedPlayers.iterator();
        while (trackedPlayerIterator.hasNext()) {
            WeakReference<EntityPlayer> playerWeakReference = trackedPlayerIterator.next();
            EntityPlayer player = (EntityPlayer)playerWeakReference.get();
            if (player == null) continue;
            player = ChunkManagerCallback.getOnlinePlayerByName(this.field_145850_b.func_73046_m(), player.func_70005_c_());
            if (player == null) {
                playerWeakReference.clear();
                trackedPlayerIterator.remove();
                continue;
            }
            trackedPlayersOnline = true;
        }
        return trackedPlayersOnline;
    }

    private void disable() {
        for (ForgeChunkManager.Ticket ticket : this.tickets) {
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket);
        }
        this.tickets.clear();
        this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 1, 0);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.expireTime = compound.func_74764_b("expireTime") ? compound.func_74763_f("expireTime") : -1L;
        this.master = compound.func_74767_n("master");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74757_a("master", ((Boolean)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockChunkLoader.MASTER)).booleanValue());
        compound.func_74772_a("expireTime", this.expireTime);
        return compound;
    }

    public boolean func_145842_c(int id, int type) {
        if (id == 1) {
            this.isActive = type == 1;
            this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
            return true;
        }
        return false;
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound updateTag = super.func_189517_E_();
        updateTag.func_74757_a("isActive", this.isActive);
        return updateTag;
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        this.isActive = tag.func_74767_n("isActive");
        super.handleUpdateTag(tag);
    }

    public boolean isExpired() {
        return this.tickets.isEmpty();
    }

    public boolean isMaster() {
        return this.master;
    }

    public void setMaster(boolean master) {
        this.master = master;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public boolean hasTicket(EntityPlayer player) {
        if (player == null) {
            return false;
        }
        for (ForgeChunkManager.Ticket ticket : this.tickets) {
            if (!ticket.getPlayerName().equals(player.func_70005_c_())) continue;
            return true;
        }
        return false;
    }

    public void expireAllTickets() {
        for (ForgeChunkManager.Ticket ticket : this.tickets) {
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket);
        }
        this.tickets.clear();
        this.trackedPlayers.clear();
    }
}

