/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.tileentity;

import cassiokf.industrialrenewal.blocks.BlockConcrete;
import cassiokf.industrialrenewal.tileentity.abstracts.TEHorizontalDirection;
import cassiokf.industrialrenewal.util.Utils;
import cassiokf.industrialrenewal.util.interfaces.ICompressedFluidCapability;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.BlockFluidBase;

public class TileEntityDamIntake
extends TEHorizontalDirection
implements ITickable,
ICompressedFluidCapability {
    private static final Map<BlockPos, BlockPos> WALLS = new HashMap<BlockPos, BlockPos>();
    private final List<BlockPos> connectedWalls = new CopyOnWriteArrayList<BlockPos>();
    private final List<BlockPos> failBlocks = new CopyOnWriteArrayList<BlockPos>();
    private final List<BlockPos> failWaters = new CopyOnWriteArrayList<BlockPos>();
    private int waterAmount = -1;
    private BlockPos neighborPos = null;
    private int concreteAmount;
    private boolean firstTick = false;

    public void func_73660_a() {
        TileEntity te;
        if (!this.firstTick) {
            this.firstTick = true;
            this.firstTick();
        }
        if (!this.field_145850_b.field_72995_K && this.getWaterAmount() > 0 && (te = this.field_145850_b.func_175625_s(this.getOutPutPos())) instanceof ICompressedFluidCapability && ((ICompressedFluidCapability)te).canAccept(this.getBlockFacing().func_176734_d(), this.getOutPutPos())) {
            ((ICompressedFluidCapability)te).passCompressedFluid(this.waterAmount, this.field_174879_c.func_177956_o(), false);
        }
    }

    public void firstTick() {
        this.initializeMultiblockIfNecessary(true);
    }

    private BlockPos getOutPutPos() {
        if (this.neighborPos != null) {
            return this.neighborPos;
        }
        this.neighborPos = this.field_174879_c.func_177972_a(this.getBlockFacing().func_176734_d());
        return this.neighborPos;
    }

    public boolean onBlockActivated(EntityPlayer player) {
        if (this.field_145850_b.field_72995_K) {
            return true;
        }
        this.cleanWallCached();
        this.initializeMultiblockIfNecessary(true);
        int percentage = this.waterAmount / 10;
        boolean done = false;
        if (percentage < 100 && this.failWaters.size() > 0 && player.func_184614_ca().func_77973_b() == Items.field_151131_as && this.tryFillDam(player)) {
            done = true;
        }
        Utils.sendChatMessage(player, "Efficiency: " + percentage + "%");
        if (done) {
            return true;
        }
        if (percentage < 100) {
            if (this.concreteAmount < 143) {
                this.sendFailBlockMessage(player);
            } else {
                this.sendFailWaterBlockMessage(player);
            }
        }
        return true;
    }

    private boolean tryFillDam(EntityPlayer player) {
        IBlockState state;
        BlockPos bPos = this.getNextReplaceableBlockForWater();
        if (bPos != null && (state = this.field_145850_b.func_180495_p(bPos)).func_177230_c().func_176200_f((IBlockAccess)this.field_145850_b, bPos)) {
            this.field_145850_b.func_175656_a(bPos, Blocks.field_150355_j.func_176223_P());
            this.failWaters.remove(bPos);
            if (!player.func_184812_l_()) {
                player.func_184614_ca().func_190918_g(1);
                player.func_191521_c(new ItemStack(Items.field_151133_ar));
            }
            return true;
        }
        return false;
    }

    private void sendFailBlockMessage(EntityPlayer player) {
        block0: {
            Utils.sendChatMessage(player, "Concrete Amount: " + this.concreteAmount + " / 143");
            Iterator<BlockPos> iterator = this.failBlocks.iterator();
            if (!iterator.hasNext()) break block0;
            BlockPos bPos = iterator.next();
            Block block = this.field_145850_b.func_180495_p(bPos).func_177230_c();
            String msg = block instanceof BlockConcrete ? "Concrete at " + Utils.blockPosToString(bPos) + " already used by another Intake" : block.func_149732_F() + " at: " + Utils.blockPosToString(bPos) + " is not a valid dam block";
            Utils.sendChatMessage(player, msg);
        }
    }

    private void sendFailWaterBlockMessage(EntityPlayer player) {
        Utils.sendChatMessage(player, "Water Amount: " + this.waterAmount + " / 1000");
        for (BlockPos bPos : this.failWaters) {
            Utils.sendChatMessage(player, "Block at: " + Utils.blockPosToString(bPos) + " is not a water source");
        }
    }

    private BlockPos getNextReplaceableBlockForWater() {
        for (BlockPos bPos : this.failWaters) {
            IBlockState state = this.field_145850_b.func_180495_p(bPos);
            if (!state.func_177230_c().func_176200_f((IBlockAccess)this.field_145850_b, bPos)) continue;
            return bPos;
        }
        return null;
    }

    @Override
    public boolean canAccept(EnumFacing face, BlockPos pos) {
        return false;
    }

    @Override
    public boolean canPipeConnect(EnumFacing face, BlockPos pos) {
        return face.equals((Object)this.getBlockFacing().func_176734_d());
    }

    @Override
    public int passCompressedFluid(int amount, int y, boolean simulate) {
        return 0;
    }

    public int getWaterAmount() {
        this.initializeMultiblockIfNecessary(false);
        return this.waterAmount;
    }

    private void initializeMultiblockIfNecessary(boolean forced) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.waterAmount < 0 || forced) {
            this.cleanWallCached();
            EnumFacing facing = this.getBlockFacing();
            this.searchForConcrete(facing);
            this.searchForWater(facing);
        }
    }

    private void searchForWater(EnumFacing facing) {
        this.failWaters.clear();
        this.waterAmount = 0;
        for (BlockPos wall : this.connectedWalls) {
            int f;
            for (f = 1; this.field_145850_b.func_180495_p(wall.func_177967_a(facing, f)).func_185904_a() == Material.field_151586_h && (Integer)this.field_145850_b.func_180495_p(wall.func_177967_a(facing, f)).func_177229_b((IProperty)BlockFluidBase.LEVEL) == 0 && f <= 10; ++f) {
            }
            if (f < 10) {
                this.failWaters.add(wall.func_177967_a(this.getBlockFacing(), f));
            }
            this.waterAmount += f - 1;
        }
        this.waterAmount = (int)(Utils.normalize(this.waterAmount, 0.0f, 1430.0f) * 1000.0f);
    }

    private void searchForConcrete(EnumFacing facing) {
        this.failBlocks.clear();
        this.connectedWalls.add(this.field_174879_c);
        for (int x = -6; x <= 6; ++x) {
            for (int y = 0; y <= 10; ++y) {
                BlockPos cPos = facing == EnumFacing.NORTH || facing == EnumFacing.SOUTH ? new BlockPos(this.field_174879_c.func_177958_n() + x, this.field_174879_c.func_177956_o() + y, this.field_174879_c.func_177952_p()) : new BlockPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() + y, this.field_174879_c.func_177952_p() + x);
                IBlockState state = this.field_145850_b.func_180495_p(cPos);
                if (state.func_177230_c() instanceof BlockConcrete && (!WALLS.containsKey(cPos) || WALLS.get(cPos).equals((Object)this.field_174879_c))) {
                    if (!WALLS.containsKey(cPos)) {
                        WALLS.put(cPos, this.field_174879_c);
                    }
                    this.connectedWalls.add(cPos);
                    continue;
                }
                this.failBlocks.add(cPos);
            }
        }
        this.concreteAmount = this.connectedWalls.size();
    }

    @Override
    public void onBlockBreak() {
        this.cleanWallCached();
        super.onBlockBreak();
    }

    private void cleanWallCached() {
        for (BlockPos wall : this.connectedWalls) {
            WALLS.remove(wall);
        }
        this.connectedWalls.clear();
    }
}

