/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.tileentity;

import cassiokf.industrialrenewal.config.IRConfig;
import cassiokf.industrialrenewal.handlers.IRSoundHandler;
import cassiokf.industrialrenewal.init.IRSoundRegister;
import cassiokf.industrialrenewal.init.ModItems;
import cassiokf.industrialrenewal.item.ItemDrill;
import cassiokf.industrialrenewal.tileentity.abstracts.TileEntityMultiBlockBase;
import cassiokf.industrialrenewal.util.Utils;
import cassiokf.industrialrenewal.util.VoltsEnergyContainer;
import cassiokf.industrialrenewal.world.generation.OreGeneration;
import java.util.ArrayList;
import java.util.Stack;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityMining
extends TileEntityMultiBlockBase<TileEntityMining> {
    private final VoltsEnergyContainer energyContainer;
    public final FluidTank waterTank = new FluidTank(32000){

        public boolean canFillFluidType(FluidStack fluid) {
            return fluid != null && fluid.getFluid().equals(FluidRegistry.WATER);
        }

        public void onContentsChanged() {
            TileEntityMining.this.sync();
        }
    };
    public final ItemStackHandler drillInv = new ItemStackHandler(1){

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return !stack.func_190926_b() && stack.func_77973_b() instanceof ItemDrill;
        }

        protected void onContentsChanged(int slot) {
            TileEntityMining.this.checkDeepMine();
        }
    };
    public final ItemStackHandler internalInv = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            TileEntityMining.this.func_70296_d();
        }
    };
    private static final int maxHeat = 18000;
    private int drillHeat;
    private int oldDrillHeat;
    public static int waterPerTick = IRConfig.MainConfig.Main.miningWaterPerTick;
    public static int energyPerTick = IRConfig.MainConfig.Main.miningEnergyPerTick;
    public static int deepEnergyPerTick = IRConfig.MainConfig.Main.miningDeepEnergyPerTick;
    public static float volume = IRConfig.MainConfig.Sounds.miningVolume * IRConfig.MainConfig.Sounds.masterVolumeMult;
    private static final int cooldown = IRConfig.MainConfig.Main.miningCooldown;
    private static final int damageAmount = 1;
    private int currentTick = 0;
    private boolean running;
    private boolean oldRunning;
    private boolean depleted = false;
    private boolean isDeepMine = false;
    private final Stack<OreMining> ores = new Stack();
    private ItemStack vein = ItemStack.field_190927_a;
    private int size;
    private float rotation;
    private float ySlide = 0.0f;
    private boolean revert;
    private int particleTick;

    public TileEntityMining() {
        this.energyContainer = new VoltsEnergyContainer(100000, 10240, 10240){

            @Override
            public boolean canExtract() {
                return false;
            }

            @Override
            public void onEnergyChange() {
                TileEntityMining.this.sync();
            }
        };
    }

    @Override
    public void tick() {
        if (this.isMaster()) {
            if (!this.field_145850_b.field_72995_K) {
                this.outputOrSpawn();
                if (this.canRun()) {
                    if (this.isDeepMine() ? this.vein.func_190926_b() : this.ores.isEmpty()) {
                        this.getOres();
                    }
                    if (this.isDeepMine() ? !this.vein.func_190926_b() : !this.ores.isEmpty()) {
                        this.running = true;
                    } else {
                        this.depleted = true;
                    }
                    if (this.running) {
                        this.size = this.isDeepMine() && !this.vein.func_190926_b() ? this.vein.func_190916_E() : this.ores.size();
                        this.consumeEnergy();
                        if (this.drillHeat < (this.waterTank.getFluidAmount() >= waterPerTick ? 9400 : 17300)) {
                            this.drillHeat += 20;
                        }
                        this.mineOre();
                    } else {
                        this.size = 0;
                        this.drillHeat -= 30;
                        this.currentTick = 0;
                    }
                } else {
                    this.size = this.isDeepMine() && !this.vein.func_190926_b() ? this.vein.func_190916_E() : this.ores.size();
                    this.drillHeat -= 30;
                    this.running = false;
                    this.depleted = false;
                    this.currentTick = 0;
                }
                this.drillHeat = MathHelper.func_76125_a((int)this.drillHeat, (int)3200, (int)18000);
                if (this.running != this.oldRunning || this.drillHeat != this.oldDrillHeat) {
                    this.oldRunning = this.running;
                    this.oldDrillHeat = this.drillHeat;
                    this.sync();
                }
            }
            this.doAnimation();
            this.updateSound();
        }
    }

    private void updateSound() {
        if (!this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.running) {
            IRSoundHandler.playRepeatableSound(IRSoundRegister.MINING_RESOURCEL, volume, 1.0f, this.field_174879_c);
        } else {
            IRSoundHandler.stopTileSound(this.field_174879_c);
        }
    }

    private boolean isDeepMine() {
        return this.isDeepMine;
    }

    public void checkDeepMine() {
        this.isDeepMine = this.drillInv.getStackInSlot(0).func_77973_b() == ModItems.drillDeep;
        this.sync();
    }

    private void consumeEnergy() {
        this.energyContainer.extractEnergy(this.isDeepMine() ? deepEnergyPerTick : energyPerTick, false);
        this.waterTank.drain(waterPerTick, true);
    }

    private int getFortune() {
        return this.drillInv.getStackInSlot(0).func_77973_b().equals((Object)ModItems.drillDiamond) ? 2 : 1;
    }

    private int getMaxCooldown() {
        int t = this.waterTank.getFluidAmount() >= waterPerTick ? cooldown : cooldown * 2;
        return this.isDeepMine() ? t * 2 : t;
    }

    private void mineOre() {
        if (this.currentTick >= this.getMaxCooldown()) {
            ItemStack stack;
            int fortune = this.getFortune();
            if (this.isDeepMine()) {
                this.currentTick = 0;
                stack = this.vein.func_77946_l();
                stack.func_190920_e(1);
                this.vein.func_190918_g(1);
            } else {
                if (this.ores.isEmpty()) {
                    return;
                }
                OreMining ore = this.ores.pop();
                Block block = ore.state.func_177230_c();
                if (this.field_145850_b.func_180495_p(ore.pos).func_177230_c() != ore.state.func_177230_c()) {
                    return;
                }
                this.currentTick = 0;
                int quantity = block.func_149679_a(fortune, this.field_145850_b.field_73012_v);
                Item item = block.func_180660_a(ore.state, this.field_145850_b.field_73012_v, fortune);
                stack = new ItemStack(item, quantity, block.func_180651_a(ore.state));
                this.field_145850_b.func_175656_a(ore.pos, Blocks.field_150347_e.func_176223_P());
            }
            this.internalInv.insertItem(0, stack, false);
            this.damageDrill();
        } else {
            ++this.currentTick;
        }
    }

    private void damageDrill() {
        int damage = this.drillHeat <= 13000 ? 1 : 4;
        ItemStack stack = this.drillInv.getStackInSlot(0);
        if (stack.func_96631_a(damage, this.field_145850_b.field_73012_v, null)) {
            stack.func_190918_g(stack.func_190916_E());
        }
    }

    private void outputOrSpawn() {
        if (this.internalInv.getStackInSlot(0).func_190926_b()) {
            return;
        }
        BlockPos outPos = this.field_174879_c.func_177967_a(this.getMasterFacing(), 2).func_177977_b();
        TileEntity te = this.field_145850_b.func_175625_s(outPos);
        if (te != null && te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.getMasterFacing().func_176734_d())) {
            IItemHandler handler = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.getMasterFacing().func_176734_d());
            if (handler != null) {
                Utils.moveItemToInventory((IItemHandler)this.internalInv, 0, handler);
            }
        } else {
            IBlockState state = this.field_145850_b.func_180495_p(outPos);
            if (state.func_177230_c().isAir(state, (IBlockAccess)this.field_145850_b, outPos)) {
                Utils.spawnItemStack(this.field_145850_b, outPos, this.internalInv.getStackInSlot(0));
            }
        }
    }

    private void getOres() {
        if (this.isDeepMine()) {
            this.vein = OreGeneration.getChunkVein(this.field_145850_b, this.field_174879_c);
            return;
        }
        Chunk chunk = this.field_145850_b.func_175726_f(this.field_174879_c);
        int a = chunk.field_76635_g * 16;
        int b = chunk.field_76647_h * 16;
        for (double y = 1.0; y <= (double)(this.field_174879_c.func_177956_o() - 2); y += 1.0) {
            for (double x = 0.0; x <= 15.0; x += 1.0) {
                for (double z = 0.0; z <= 15.0; z += 1.0) {
                    BlockPos actualPosition = new BlockPos((double)a + x, y, (double)b + z);
                    IBlockState state = chunk.func_177435_g(actualPosition);
                    if (!OreGeneration.MINERABLE_ORES.contains(Item.func_150898_a((Block)state.func_177230_c()))) continue;
                    this.ores.add(new OreMining(state, actualPosition));
                }
            }
        }
    }

    private void doAnimation() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.running) {
                if (this.particleTick >= 10) {
                    this.particleTick = 0;
                    this.spawnFluidParticle((float)this.field_174879_c.func_177958_n() + 0.5f, (float)this.field_174879_c.func_177956_o() - 1.0f, (float)this.field_174879_c.func_177952_p() + 0.5f, Blocks.field_150348_b);
                    if (this.waterTank.getFluidAmount() > 0) {
                        this.spawnFluidParticle((float)this.field_174879_c.func_177958_n() + 0.5f, (float)this.field_174879_c.func_177956_o() - 1.0f, (float)this.field_174879_c.func_177952_p() + 0.5f, this.waterTank.getFluid().getFluid().getBlock());
                    }
                }
                ++this.particleTick;
            }
        } else if (this.running) {
            this.rotation += 20.0f;
            if (this.rotation >= 360.0f) {
                this.rotation = 0.0f;
            }
            this.ySlide = Utils.lerp(this.ySlide, this.revert ? 0.0f : -1.0f, 0.01f);
            if ((double)this.ySlide >= -0.01 || (double)this.ySlide <= -0.9) {
                this.revert = !this.revert;
            }
        } else {
            this.rotation = 0.0f;
            this.ySlide = Utils.lerp(this.ySlide, -1.0f, 0.05f);
        }
    }

    @Override
    public boolean instanceOf(TileEntity tileEntity) {
        return tileEntity instanceof TileEntityMining;
    }

    private void spawnFluidParticle(double x, double y, double z, Block block) {
        float f = MathHelper.func_76123_f((float)1.0f);
        double d0 = Math.min((double)(0.2f + f / 15.0f), 2.5);
        int i = (int)(150.0 * d0);
        ((WorldServer)this.field_145850_b).func_175739_a(EnumParticleTypes.BLOCK_DUST, x, y, z, i, 0.0, 0.0, 0.0, (double)0.15f, new int[]{Block.func_176210_f((IBlockState)block.func_176223_P())});
    }

    private boolean canRun() {
        EnumFacing facing = this.getMasterFacing();
        BlockPos posPort = this.field_174879_c.func_177972_a(facing.func_176735_f()).func_177972_a(facing.func_176734_d()).func_177977_b();
        return !this.depleted && (this.field_145850_b.func_175640_z(posPort) || this.field_145850_b.func_175640_z(posPort.func_177972_a(facing.func_176734_d()))) && this.energyContainer.getEnergyStored() >= (this.isDeepMine() ? deepEnergyPerTick : energyPerTick) && !this.drillInv.getStackInSlot(0).func_190926_b() && this.internalInv.getStackInSlot(0).func_190926_b();
    }

    public boolean isRunning() {
        return this.running;
    }

    public void dropAllItems() {
        Utils.dropInventoryItems(this.field_145850_b, this.field_174879_c, this.drillInv);
    }

    public String getWaterText(int line) {
        if (line == 1) {
            return I18n.func_135052_a((String)"render.industrialrenewal.coolant", (Object[])new Object[0]) + ":";
        }
        return this.waterTank.getFluid() != null ? this.waterTank.getFluid().getLocalizedName() : "---";
    }

    public String getEnergyText(int line) {
        if (line == 1) {
            return I18n.func_135052_a((String)"render.industrialrenewal.energy", (Object[])new Object[0]) + ":";
        }
        return this.energyContainer.getEnergyStored() + " FE";
    }

    public String getHeatText() {
        String name = I18n.func_135052_a((String)"render.industrialrenewal.drillheat", (Object[])new Object[0]) + ": ";
        if (this.drillHeat > 13000) {
            name = name + TextFormatting.RED;
        }
        return name + Utils.getConvertedTemperatureString((float)this.drillHeat / 100.0f);
    }

    public String[] getScreenTexts() {
        ArrayList<String> texts = new ArrayList<String>();
        if (this.energyContainer.getEnergyStored() <= 0) {
            return EMPTY_ARRAY;
        }
        texts.add("Mining Drill Status: " + (this.running ? "Running" : TextFormatting.RED + " Stoped"));
        texts.add("Mining Drill Mode: " + TextFormatting.BLUE + (this.isDeepMine ? "Deep Mine" : "Surface Mine"));
        texts.add("Vein Size: " + this.size);
        texts.add("Consumption: " + (this.isDeepMine() ? deepEnergyPerTick : energyPerTick) + " FE/t");
        texts.add(this.getHeatText());
        int maxD = this.getDrill().func_77958_k();
        texts.add("Drill condition: " + (maxD - this.getDrill().func_77952_i()) + "/" + maxD);
        String[] itemsArray = new String[texts.size()];
        itemsArray = texts.toArray(itemsArray);
        return itemsArray;
    }

    public float getWaterFill() {
        return Utils.normalize(this.waterTank.getFluidAmount(), 0.0f, this.waterTank.getCapacity()) * 180.0f;
    }

    public float getEnergyFill() {
        return Utils.normalize(this.energyContainer.getEnergyStored(), 0.0f, this.energyContainer.getMaxEnergyStored());
    }

    public float getHeatFill() {
        return Utils.normalize(this.drillHeat, 0.0f, 18000.0f) * 180.0f;
    }

    public boolean hasDrill() {
        return !this.drillInv.getStackInSlot(0).func_190926_b();
    }

    public ItemStack getDrill() {
        return this.drillInv.getStackInSlot(0);
    }

    public float getRotation() {
        return -this.rotation;
    }

    public float getSlide() {
        return this.ySlide;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        NBTTagCompound waterTag = new NBTTagCompound();
        this.waterTank.writeToNBT(waterTag);
        compound.func_74782_a("water", (NBTBase)waterTag);
        compound.func_74782_a("firebox", (NBTBase)this.drillInv.serializeNBT());
        compound.func_74782_a("StoredIR", (NBTBase)this.energyContainer.serializeNBT());
        compound.func_74768_a("heat", this.drillHeat);
        compound.func_74757_a("running", this.running);
        compound.func_74757_a("deep", this.isDeepMine);
        compound.func_74768_a("vsize", this.size);
        return super.func_189515_b(compound);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        this.waterTank.readFromNBT(compound.func_74775_l("water"));
        this.drillInv.deserializeNBT(compound.func_74775_l("firebox"));
        this.energyContainer.deserializeNBT(compound.func_74775_l("StoredIR"));
        this.drillHeat = compound.func_74762_e("heat");
        this.running = compound.func_74767_n("running");
        this.isDeepMine = compound.func_74767_n("deep");
        this.size = compound.func_74762_e("vsize");
        super.func_145839_a(compound);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        TileEntityMining masterTE = (TileEntityMining)this.getMaster();
        if (masterTE == null) {
            return (T)super.getCapability(capability, facing);
        }
        EnumFacing face = masterTE.getMasterFacing();
        if (facing == face && this.field_174879_c.equals((Object)masterTE.func_174877_v().func_177977_b().func_177972_a(face).func_177972_a(face.func_176746_e())) && capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)masterTE.waterTank);
        }
        if (facing == EnumFacing.UP && this.field_174879_c.equals((Object)masterTE.func_174877_v().func_177972_a(face.func_176734_d()).func_177984_a()) && capability == CapabilityEnergy.ENERGY) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)masterTE.energyContainer);
        }
        return (T)super.getCapability(capability, facing);
    }

    public IItemHandler getDrillHandler() {
        return (IItemHandler)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)((TileEntityMining)this.getMaster()).drillInv);
    }

    public class OreMining {
        public final IBlockState state;
        public final BlockPos pos;

        OreMining(IBlockState state, BlockPos pos) {
            this.state = state;
            this.pos = pos;
        }
    }
}

