/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.tileentity;

import cassiokf.industrialrenewal.blocks.BlockPortableGenerator;
import cassiokf.industrialrenewal.blocks.abstracts.BlockHorizontalFacing;
import cassiokf.industrialrenewal.config.IRConfig;
import cassiokf.industrialrenewal.handlers.FluidGenerator;
import cassiokf.industrialrenewal.handlers.IRSoundHandler;
import cassiokf.industrialrenewal.init.IRSoundRegister;
import cassiokf.industrialrenewal.tileentity.abstracts.TileEntitySaveContent;
import cassiokf.industrialrenewal.util.Utils;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;

public class TileEntityPortableGenerator
extends TileEntitySaveContent
implements ITickable {
    private final FluidGenerator generator = new FluidGenerator(this);
    private EnumFacing blockFacing;
    private boolean soundStarted = false;
    private final float volume;

    public TileEntityPortableGenerator() {
        this.volume = IRConfig.MainConfig.Sounds.genVolume * IRConfig.MainConfig.Sounds.masterVolumeMult;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.generator.onTick();
            this.passEnergy();
        } else {
            this.handleSound();
        }
    }

    private void handleSound() {
        if (this.generator.isGenerating() && !this.soundStarted) {
            IRSoundHandler.playRepeatableSound(IRSoundRegister.GENERATOR_RESOURCEL, this.volume, 1.0f, this.field_174879_c);
            this.soundStarted = true;
        } else if (!this.generator.isGenerating() && this.soundStarted) {
            IRSoundHandler.stopTileSound(this.field_174879_c);
            this.soundStarted = false;
        }
    }

    public boolean isWorking() {
        return this.generator.isGenerating();
    }

    public void func_145843_s() {
        if (this.field_145850_b.field_72995_K) {
            IRSoundHandler.stopTileSound(this.field_174879_c);
        }
        super.func_145843_s();
    }

    public void changeGenerator() {
        this.generator.changeCanGenerate();
    }

    private void passEnergy() {
        IEnergyStorage handler;
        TileEntity te;
        if (this.generator.energyStorage.getEnergyStored() >= 0 && (te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(this.getBlockFacing()))) != null && (handler = (IEnergyStorage)te.getCapability(CapabilityEnergy.ENERGY, this.getBlockFacing())) != null && handler.canReceive()) {
            this.generator.energyStorage.extractEnergyInternally(handler.receiveEnergy(this.generator.energyStorage.extractEnergyInternally(128, true), false), false);
        }
    }

    @Override
    public FluidTank getTank() {
        return this.generator.tank;
    }

    public EnumFacing getBlockFacing() {
        return this.getBlockFacing(false);
    }

    public EnumFacing getBlockFacing(boolean force) {
        if (!force && this.blockFacing != null) {
            return this.blockFacing;
        }
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (!(state.func_177230_c() instanceof BlockPortableGenerator)) {
            return EnumFacing.NORTH;
        }
        this.blockFacing = (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockHorizontalFacing.FACING);
        return this.blockFacing;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        this.generator.saveGenerator(compound);
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.generator.loadGenerator(compound);
        super.func_145839_a(compound);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY && facing == this.getBlockFacing()) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)this.generator.energyStorage);
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.generator.tank);
        }
        return (T)super.getCapability(capability, facing);
    }

    public float getTankFill() {
        return Utils.normalize(this.getTank().getFluidAmount(), 0.0f, this.getTank().getCapacity()) * 180.0f;
    }

    public String getTankText() {
        return this.getTank().getFluidAmount() > 0 ? this.getTank().getFluid().getLocalizedName() : I18n.func_135052_a((String)"gui.industrialrenewal.fluid.empty", (Object[])new Object[0]);
    }

    public float getEnergyFill() {
        return Utils.normalize(this.generator.isGenerating() ? (float)FluidGenerator.energyPerTick : 0.0f, 0.0f, 128.0f) * 90.0f;
    }

    public String getEnergyText() {
        return Utils.formatEnergyString(this.generator.isGenerating() ? FluidGenerator.energyPerTick : 0) + "/t";
    }
}

