/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.tileentity;

import cassiokf.industrialrenewal.blocks.BlockSteamBoiler;
import cassiokf.industrialrenewal.handlers.SteamBoiler;
import cassiokf.industrialrenewal.init.ModItems;
import cassiokf.industrialrenewal.tileentity.abstracts.TileEntityMultiBlockBase;
import cassiokf.industrialrenewal.util.Utils;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileEntitySteamBoiler
extends TileEntityMultiBlockBase<TileEntitySteamBoiler> {
    private int type;
    private final int solidPerTick = 2;
    public final SteamBoiler boiler = new SteamBoiler(this, SteamBoiler.BoilerType.Solid, 2);
    private final int fluidPerTick = 1;

    @Override
    public void tick() {
        if (this.isMaster() && !this.field_145850_b.field_72995_K) {
            if (this.type > 0) {
                this.boiler.onTick();
            } else {
                this.boiler.outPutSteam();
                this.boiler.coolDown();
            }
        }
    }

    @Override
    public boolean instanceOf(TileEntity tileEntity) {
        return tileEntity instanceof TileEntitySteamBoiler;
    }

    public int getType() {
        if (!this.isMaster()) {
            return ((TileEntitySteamBoiler)this.getMaster()).type;
        }
        return this.type;
    }

    public void setType(int type) {
        if (!this.isMaster()) {
            ((TileEntitySteamBoiler)this.getMaster()).setType(type);
            return;
        }
        this.boiler.dropItemsOnGround(this.field_174879_c);
        this.type = type;
        if (type > 0) {
            this.boiler.setType(type == 1 ? SteamBoiler.BoilerType.Solid : SteamBoiler.BoilerType.Liquid, type == 1 ? 2 : 1);
        } else {
            this.boiler.resetFuelTime();
        }
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)BlockSteamBoiler.TYPE, (Comparable)Integer.valueOf(type));
        this.field_145850_b.func_180501_a(this.field_174879_c, state, 3);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
        this.sync();
    }

    public String getFuelText() {
        if (this.getType() == 0) {
            return "No Firebox";
        }
        return this.boiler.getFuelText();
    }

    @Override
    public void onMasterBreak() {
        this.boiler.dropItemsOnGround(this.field_174879_c);
        Utils.spawnItemStack(this.field_145850_b, this.field_174879_c, this.getFireBoxStack());
    }

    public ItemStack getFireBoxStack() {
        switch (this.type) {
            default: {
                return ItemStack.field_190927_a;
            }
            case 1: {
                return new ItemStack((Item)ModItems.fireBoxSolid);
            }
            case 2: 
        }
        return new ItemStack((Item)ModItems.fireBoxFluid);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        this.boiler.serialize(compound);
        compound.func_74768_a("type", this.type);
        return super.func_189515_b(compound);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        this.boiler.deserialize(compound);
        this.type = compound.func_74762_e("type");
        super.func_145839_a(compound);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        boolean matchFuelFace;
        TileEntitySteamBoiler masterTE = (TileEntitySteamBoiler)this.getMaster();
        if (masterTE == null) {
            return (T)super.getCapability(capability, facing);
        }
        EnumFacing face = masterTE.getMasterFacing();
        SteamBoiler masterBoiler = masterTE.boiler;
        boolean bl = matchFuelFace = facing == face.func_176735_f() && this.field_174879_c.equals((Object)masterTE.func_174877_v().func_177977_b().func_177972_a(face.func_176734_d()).func_177972_a(face.func_176735_f()));
        if (facing == EnumFacing.UP && this.field_174879_c.equals((Object)masterTE.func_174877_v().func_177984_a()) && capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)masterBoiler.steamTank);
        }
        if (facing == face && this.field_174879_c.equals((Object)masterTE.func_174877_v().func_177977_b().func_177972_a(face)) && capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)masterBoiler.waterTank);
        }
        if (masterTE.getType() == 1 && matchFuelFace && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)masterBoiler.solidFuelInv);
        }
        if (masterTE.getType() == 2 && matchFuelFace && capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)masterBoiler.fuelTank);
        }
        return (T)super.getCapability(capability, facing);
    }
}

