/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.tileentity.railroad;

import cassiokf.industrialrenewal.blocks.BlockChunkLoader;
import cassiokf.industrialrenewal.blocks.railroad.BlockFluidLoader;
import cassiokf.industrialrenewal.tileentity.railroad.TileEntityBaseLoader;
import cassiokf.industrialrenewal.tileentity.railroad.TileEntityLoaderRail;
import cassiokf.industrialrenewal.util.Utils;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class TileEntityFluidLoader
extends TileEntityBaseLoader
implements ITickable {
    public final FluidTank tank = new FluidTank(16000){

        public boolean canFill() {
            return !TileEntityFluidLoader.this.isUnload();
        }

        protected void onContentsChanged() {
            TileEntityFluidLoader.this.sync();
        }
    };
    private final int maxFlowPerTick = 200;
    private boolean checked = false;
    private boolean master;
    private float ySlide = 0.0f;
    private int cartFluidAmount;
    private int cartFluidCapacity;
    private int noActivity = 0;

    public void func_73660_a() {
        if (this.isMaster()) {
            if (!this.field_145850_b.field_72995_K) {
                IFluidHandler handler;
                TileEntity te;
                if (this.cartActivity > 0) {
                    --this.cartActivity;
                    this.sync();
                }
                if (this.isUnload() && this.tank.getFluidAmount() > 0 && (te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(this.getBlockFacing().func_176734_d()))) != null && (handler = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.getBlockFacing())) != null) {
                    this.tank.drain(handler.fill(this.tank.drain(200, false), true), true);
                }
            } else {
                this.ySlide = this.loading ? Utils.lerp(this.ySlide, 0.5f, 0.08f) : Utils.lerp(this.ySlide, 0.0f, 0.04f);
            }
        }
    }

    public boolean isMaster() {
        if (!this.checked) {
            this.master = (Boolean)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockChunkLoader.MASTER);
            this.checked = true;
        }
        return this.master;
    }

    public String getTankText() {
        if (this.tank.getFluid() == null) {
            return I18n.func_135052_a((String)"gui.industrialrenewal.fluid.empty", (Object[])new Object[0]);
        }
        return I18n.func_135052_a((String)"render.industrialrenewal.fluid", (Object[])new Object[0]) + ": " + this.tank.getFluid().getLocalizedName();
    }

    public String getCartName() {
        if (this.cartActivity <= 0) {
            return "No Cart";
        }
        return this.cartName;
    }

    public float getSlide() {
        return this.ySlide;
    }

    public float getCartFluidAngle() {
        if (this.cartActivity <= 0) {
            return 0.0f;
        }
        float currentAmount = this.cartFluidAmount;
        float totalCapacity = this.cartFluidCapacity;
        return Utils.normalize(currentAmount, 0.0f, totalCapacity) * 180.0f;
    }

    public float getTankFluidAngle() {
        float currentAmount = this.tank.getFluidAmount();
        float totalCapacity = this.tank.getCapacity();
        return Utils.normalize(currentAmount, 0.0f, totalCapacity) * 180.0f;
    }

    @Override
    public boolean onMinecartPass(EntityMinecart cart, TileEntityLoaderRail loaderRail) {
        if (!this.field_145850_b.field_72995_K && this.isMaster()) {
            this.cartName = cart.func_70005_c_();
            this.cartActivity = 10;
            IFluidHandler cartCapability = (IFluidHandler)cart.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.UP);
            if (cartCapability != null) {
                IFluidTankProperties properties = cartCapability.getTankProperties()[0];
                if (properties == null) {
                    return false;
                }
                this.cartFluidAmount = properties.getContents() != null ? properties.getContents().amount : 0;
                this.cartFluidCapacity = properties.getCapacity();
                FluidStack cartStack = properties.getContents();
                if (this.isUnload()) {
                    if (cartStack != null && cartStack.amount > 0 && this.tank.getFluidAmount() < this.tank.getCapacity()) {
                        cartCapability.drain(this.tank.fillInternal(cartCapability.drain(200, false), true), true);
                        this.loading = true;
                        this.noActivity = 0;
                        return true;
                    }
                    this.loading = false;
                    if (this.waitE == TileEntityBaseLoader.waitEnum.WAIT_EMPTY) {
                        return cartStack != null && cartStack.amount > 0;
                    }
                    if (this.waitE == TileEntityBaseLoader.waitEnum.WAIT_FULL) {
                        return cartStack == null || cartStack.amount < this.cartFluidCapacity;
                    }
                } else {
                    if (this.tank.getFluidAmount() > 0 && (cartStack == null || cartStack.amount < this.cartFluidCapacity)) {
                        this.tank.drain(cartCapability.fill(this.tank.drain(200, false), true), true);
                        this.loading = true;
                        this.noActivity = 0;
                        return true;
                    }
                    this.loading = false;
                    if (this.waitE == TileEntityBaseLoader.waitEnum.WAIT_FULL) {
                        return cartStack == null || cartStack.amount < this.cartFluidCapacity;
                    }
                    if (this.waitE == TileEntityBaseLoader.waitEnum.WAIT_EMPTY) {
                        return cartStack != null && cartStack.amount > 0;
                    }
                }
                if (this.waitE == TileEntityBaseLoader.waitEnum.NO_ACTIVITY) {
                    ++this.noActivity;
                    return this.noActivity < 10;
                }
            }
        }
        return this.waitE == TileEntityBaseLoader.waitEnum.NEVER;
    }

    @Override
    public boolean isUnload() {
        return this.unload;
    }

    @Override
    public EnumFacing getBlockFacing() {
        if (this.blockFacing == null) {
            this.blockFacing = (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockFluidLoader.FACING);
        }
        return this.blockFacing;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        this.tank.writeToNBT(compound);
        compound.func_74768_a("capacity", this.cartFluidCapacity);
        compound.func_74768_a("cartAmount", this.cartFluidAmount);
        compound.func_74768_a("activity", this.cartActivity);
        compound.func_74757_a("loading", this.loading);
        return super.func_189515_b(compound);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        this.tank.readFromNBT(compound);
        this.cartFluidCapacity = compound.func_74762_e("capacity");
        this.cartFluidAmount = compound.func_74762_e("cartAmount");
        this.cartActivity = compound.func_74762_e("activity");
        this.loading = compound.func_74767_n("loading");
        super.func_145839_a(compound);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(facing == this.getBlockFacing().func_176734_d() && capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY ? CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.tank) : super.getCapability(capability, facing));
    }
}

