/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.util;

import cassiokf.industrialrenewal.util.interfaces.ISync;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class MultiStackHandler
extends ItemStackHandler {
    private int maxStack;
    private boolean sync;
    private final TileEntity te;
    private int count;

    public MultiStackHandler(int maxStack, boolean sync, TileEntity te) {
        super(1);
        this.maxStack = maxStack;
        this.sync = sync;
        this.te = te;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        boolean reachedLimit;
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        this.validateSlotIndex(0);
        ItemStack existing = (ItemStack)this.stacks.get(0);
        int limit = this.getStackLimit(0, stack);
        if (!existing.func_190926_b()) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)existing)) {
                return stack;
            }
            limit -= this.count;
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.func_190916_E() > limit;
        if (!simulate) {
            if (existing.func_190926_b()) {
                this.stacks.set(0, (Object)(reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1) : stack));
                this.count = reachedLimit ? limit : stack.func_190916_E();
            } else {
                this.count += reachedLimit ? limit : stack.func_190916_E();
            }
            this.onContentsChanged(0);
        }
        return reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.func_190916_E() - limit)) : ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.field_190927_a;
        }
        this.validateSlotIndex(0);
        ItemStack existing = (ItemStack)this.stacks.get(0);
        if (existing.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        int toExtract = Math.min(amount, this.maxStack);
        if (this.count <= toExtract) {
            if (!simulate) {
                this.stacks.set(0, (Object)ItemStack.field_190927_a);
                this.count = 0;
                this.onContentsChanged(0);
            }
            return existing;
        }
        if (!simulate) {
            this.stacks.set(0, (Object)ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)1));
            this.count -= toExtract;
            this.onContentsChanged(0);
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)toExtract);
    }

    public int getSlotLimit(int slot) {
        return this.maxStack;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int value) {
        this.count = value;
        this.onContentsChanged(0);
    }

    public void removeFromCount(int value) {
        this.count -= value;
        this.onContentsChanged(0);
    }

    public void addToCount(int value) {
        this.count += value;
        this.onContentsChanged(0);
    }

    public void setSlotLimit(int value) {
        this.maxStack = value;
        this.onContentsChanged(0);
    }

    protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
        return this.getSlotLimit(0);
    }

    protected void onContentsChanged(int slot) {
        super.onContentsChanged(slot);
        if (this.sync && this.te instanceof ISync) {
            ((ISync)this.te).sync();
        } else {
            this.te.func_70296_d();
        }
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = super.serializeNBT();
        compound.func_74768_a("maxStack", this.maxStack);
        compound.func_74757_a("sync", this.sync);
        compound.func_74768_a("count", this.count);
        return compound;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.maxStack = nbt.func_74762_e("maxStack");
        this.sync = nbt.func_74767_n("sync");
        this.count = nbt.func_74762_e("count");
        super.deserializeNBT(nbt);
    }
}

