/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.util.compat.crafttweaker;

import cassiokf.industrialrenewal.recipes.LatheRecipe;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.Arrays;
import java.util.List;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.industrialrenewal.lathe")
@ZenRegister
public class LatheMachineCT {
    @ZenMethod
    public static void addRecipe(IIngredient output, IIngredient input, int time) {
        ItemStack outputStack = CraftTweakerMC.getItemStacks((List)output.getItems())[0];
        List<ItemStack> stackList = Arrays.asList(CraftTweakerMC.getItemStacks((List)input.getItems()));
        LatheRecipe latheRecipe = new LatheRecipe(stackList, outputStack, time);
        CraftTweakerAPI.apply((IAction)new Add(stackList, latheRecipe));
    }

    @ZenMethod
    public static void removeRecipe(IIngredient output) {
        ItemStack outputStack = CraftTweakerMC.getItemStacks((List)output.getItems())[0];
        LatheRecipe recipeToRemove = null;
        for (LatheRecipe recipe : LatheRecipe.LATHE_RECIPES) {
            if (!recipe.func_77571_b().func_77973_b().equals(outputStack.func_77973_b())) continue;
            recipeToRemove = recipe;
            break;
        }
        if (recipeToRemove != null) {
            CraftTweakerAPI.apply((IAction)new Remove(recipeToRemove.getInput(), recipeToRemove));
        }
    }

    @ZenMethod
    public static void removeAll() {
        CraftTweakerAPI.apply((IAction)new RemoveAll());
    }

    private static class RemoveAll
    implements IAction {
        public void apply() {
            LatheRecipe.LATHE_RECIPES.clear();
            LatheRecipe.CACHED_RECIPES.clear();
            System.out.println("All Recipes Removed");
        }

        public String describe() {
            return "Removing all Lathe Machine Recipes";
        }
    }

    private static class Remove
    implements IAction {
        private final List<ItemStack> item;
        private final LatheRecipe recipe;

        public Remove(List<ItemStack> item, LatheRecipe recipe) {
            this.item = item;
            this.recipe = recipe;
        }

        public void apply() {
            LatheRecipe.LATHE_RECIPES.remove((Object)this.recipe);
            for (ItemStack stack : this.item) {
                LatheRecipe.CACHED_RECIPES.remove(stack.func_77973_b());
            }
            System.out.println("Removed " + (Object)((Object)this.recipe));
        }

        public String describe() {
            return "Removing Lathe Machine Recipe for " + this.recipe.func_77571_b().func_82833_r();
        }
    }

    private static class Add
    implements IAction {
        private final LatheRecipe recipe;
        private final List<ItemStack> item;

        public Add(List<ItemStack> item, LatheRecipe recipe) {
            this.recipe = recipe;
            this.item = item;
        }

        public void apply() {
            LatheRecipe.LATHE_RECIPES.add(this.recipe);
            for (ItemStack stack : this.item) {
                LatheRecipe.CACHED_RECIPES.put(stack.func_77973_b(), this.recipe);
            }
            System.out.println("Added New Recipe " + (Object)((Object)this.recipe));
        }

        public String describe() {
            return "Adding Lathe Machine Recipe for " + this.recipe.func_77571_b().func_82833_r();
        }
    }
}

