/*
 * Decompiled with CFR 0.152.
 */
package com.phylogeny.extrabitmanipulation.armor.capability;

import com.google.common.collect.Maps;
import com.phylogeny.extrabitmanipulation.armor.capability.ChiseledArmorSlotsHandler;
import com.phylogeny.extrabitmanipulation.armor.capability.IChiseledArmorSlotsHandler;
import com.phylogeny.extrabitmanipulation.client.ClientHelper;
import com.phylogeny.extrabitmanipulation.client.gui.armor.GuiButtonArmorSlots;
import com.phylogeny.extrabitmanipulation.client.gui.armor.GuiInventoryArmorSlots;
import com.phylogeny.extrabitmanipulation.helper.BitToolSettingsHelper;
import com.phylogeny.extrabitmanipulation.helper.ItemStackHelper;
import com.phylogeny.extrabitmanipulation.init.ReflectionExtraBitManipulation;
import com.phylogeny.extrabitmanipulation.reference.Configs;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandReplaceItem;
import net.minecraft.command.CommandResultStats;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.NumberInvalidException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class ChiseledArmorSlotsEventHandler {
    private static final Map<String, Integer> COMMAND_VANITY_SLOTS = Maps.newHashMap();

    public static void addCommandTabCompletions() {
        ReflectionExtraBitManipulation.addShortcutsToCommandReplaceItem(new CommandReplaceItem(), COMMAND_VANITY_SLOTS);
    }

    @SubscribeEvent
    public void onEntityConstruct(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityPlayer) {
            event.addCapability(new ResourceLocation("extrabitmanipulation", "chiseled_armor_slots"), (ICapabilityProvider)new ChiseledArmorSlotsHandler());
        }
    }

    @SubscribeEvent
    public void markPlayerSlotsDirty(EntityJoinWorldEvent event) {
        this.markPlayerSlotsDirty(event.getEntity());
    }

    @SubscribeEvent
    public void markPlayerSlotsDirty(PlayerEvent.StartTracking event) {
        this.markPlayerSlotsDirty(event.getTarget());
    }

    private void markPlayerSlotsDirty(Entity player) {
        if (!(player instanceof EntityPlayerMP)) {
            return;
        }
        IChiseledArmorSlotsHandler cap = ChiseledArmorSlotsHandler.getCapability((EntityPlayer)player);
        if (cap != null) {
            cap.markAllSlotsDirty();
        }
    }

    @SubscribeEvent
    public void syncPlayerSlots(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END || !(event.player instanceof EntityPlayerMP)) {
            return;
        }
        IChiseledArmorSlotsHandler cap = ChiseledArmorSlotsHandler.getCapability(event.player);
        if (cap != null) {
            cap.syncAllSlots(event.player);
        }
    }

    @SubscribeEvent
    public void syncDataForClonedPlayers(PlayerEvent.Clone event) {
        IChiseledArmorSlotsHandler capNew;
        if (!event.isWasDeath()) {
            return;
        }
        IChiseledArmorSlotsHandler capOld = ChiseledArmorSlotsHandler.getCapability(event.getOriginal());
        if (capOld != null && (capNew = ChiseledArmorSlotsHandler.getCapability((EntityPlayer)event.getEntity())) != null) {
            ((ChiseledArmorSlotsHandler)capNew).deserializeNBT(((ChiseledArmorSlotsHandler)capOld).serializeNBT());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void dropArmorOnDeath(PlayerDropsEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        IChiseledArmorSlotsHandler cap = ChiseledArmorSlotsHandler.getCapability(player);
        if (cap == null) {
            return;
        }
        for (int i = 0; i < cap.getSlots(); ++i) {
            if (cap.getStackInSlot(i).func_190926_b()) continue;
            player.captureDrops = true;
            player.func_146097_a(cap.getStackInSlot(i).func_77946_l(), true, false);
            player.captureDrops = false;
            cap.setStackInSlot(i, ItemStack.field_190927_a);
        }
    }

    @SubscribeEvent
    public void vanitySlotCommandAccess(CommandEvent event) {
        Entity entity;
        Item item;
        if (!(event.getCommand() instanceof CommandReplaceItem)) {
            return;
        }
        String[] args = event.getParameters();
        if (args.length < 4 || !"entity".equals(args[0])) {
            return;
        }
        int i = 2;
        String slotName = args[i];
        if (!slotName.contains("vanity")) {
            return;
        }
        event.setCanceled(true);
        if (!COMMAND_VANITY_SLOTS.containsKey(slotName)) {
            this.notifyCommandListener(event, "commands.generic.parameter.invalid", slotName);
            return;
        }
        ICommandSender sender = event.getSender();
        int slot = COMMAND_VANITY_SLOTS.get(args[i++]);
        try {
            item = CommandBase.func_147179_f((ICommandSender)sender, (String)args[i++]);
        }
        catch (NumberInvalidException e) {
            this.notifyCommandListener(event, (CommandException)((Object)e));
            return;
        }
        ItemStack stack = new ItemStack(item);
        if (args.length > i) {
            String nbtTagJson = CommandBase.func_180529_a((String[])args, (int)(args.length > 5 ? 6 : 4));
            try {
                stack.func_77982_d(JsonToNBT.func_180713_a((String)nbtTagJson));
            }
            catch (NBTException e) {
                this.notifyCommandListener(event, "commands.replaceitem.tagError", e.getMessage());
                return;
            }
        } else {
            this.notifyCommandListener(event, "nbt");
            return;
        }
        if (!stack.func_190926_b() && !ChiseledArmorSlotsHandler.isItemValid(slot, stack)) {
            this.notifyCommandListener(event, "commands.replaceitem.failed", slotName, 1, stack.func_151000_E());
            return;
        }
        try {
            entity = CommandBase.func_184885_b((MinecraftServer)sender.func_184102_h(), (ICommandSender)sender, (String)args[1]);
        }
        catch (CommandException e) {
            this.notifyCommandListener(event, e);
            return;
        }
        if (!(entity instanceof EntityPlayer)) {
            this.notifyCommandListener(event, "player");
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        IChiseledArmorSlotsHandler cap = ChiseledArmorSlotsHandler.getCapability(player);
        if (cap == null) {
            this.notifyCommandListener(event, "capability");
            return;
        }
        sender.func_174794_a(CommandResultStats.Type.AFFECTED_ITEMS, 0);
        player.field_71070_bA.func_75142_b();
        cap.setStackInSlot(slot, stack);
        player.field_71070_bA.func_75142_b();
        sender.func_174794_a(CommandResultStats.Type.AFFECTED_ITEMS, 1);
        this.notifyCommandListener(event, "commands.replaceitem.success", slotName, 1, stack.func_190926_b() ? "Air" : stack.func_151000_E());
    }

    private void notifyCommandListener(CommandEvent event, String suffix) {
        this.notifyCommandListener(event, "command.extrabitmanipulation.vanity.failure." + suffix, new Object[0]);
    }

    private void notifyCommandListener(CommandEvent event, CommandException e) {
        this.notifyCommandListener(event, e.getMessage(), e.func_74844_a());
    }

    private void notifyCommandListener(CommandEvent event, String translationKey, Object ... translationArgs) {
        CommandBase.func_152373_a((ICommandSender)event.getSender(), (ICommand)event.getCommand(), (String)translationKey, (Object[])translationArgs);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void addArmorButtonToGui(GuiScreenEvent.InitGuiEvent.Post event) {
        EntityPlayer player = ClientHelper.getPlayer();
        if (player == null || player.field_71075_bZ.field_75098_d) {
            return;
        }
        boolean isArmorSlots = event.getGui() instanceof GuiInventoryArmorSlots;
        if (!isArmorSlots && !(event.getGui() instanceof GuiInventory)) {
            return;
        }
        GuiContainer gui = (GuiContainer)event.getGui();
        boolean add = false;
        IChiseledArmorSlotsHandler cap = ChiseledArmorSlotsHandler.getCapability(player);
        if (cap != null) {
            for (int i = 0; i < cap.getSlots(); ++i) {
                if (cap.getStackInSlot(i).func_190926_b()) continue;
                add = true;
                break;
            }
        }
        if (!add) {
            ArmorButtonVisibiltyMode mode = Configs.armorButtonVisibiltyMode;
            boolean bl = add = isArmorSlots || mode == ArmorButtonVisibiltyMode.ALWAYS;
            if (!isArmorSlots && mode != ArmorButtonVisibiltyMode.NEVER && mode != ArmorButtonVisibiltyMode.ALWAYS) {
                for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                    ResourceLocation name;
                    ItemStack stack = player.field_71071_by.func_70301_a(i);
                    if (stack.func_190926_b()) continue;
                    if (mode == ArmorButtonVisibiltyMode.ANY_ITEMS || mode == ArmorButtonVisibiltyMode.CHISELED_ARMOR_ITEMS) {
                        if (mode != ArmorButtonVisibiltyMode.ANY_ITEMS && !ItemStackHelper.isChiseledArmorStack(stack)) continue;
                        add = true;
                        break;
                    }
                    Item item = stack.func_77973_b();
                    if (item == null || (name = item.getRegistryName()) == null || !name.func_110624_b().equals("extrabitmanipulation") && (mode != ArmorButtonVisibiltyMode.EBM_OR_CNB_ITEMS || !name.func_110624_b().equals("chiselsandbits"))) continue;
                    add = true;
                    break;
                }
            }
        }
        if (add) {
            GuiButtonArmorSlots button = new GuiButtonArmorSlots(gui, isArmorSlots ? "Back" : "Chiseled Armor");
            if (isArmorSlots) {
                button.setHelpMode(((GuiInventoryArmorSlots)gui).isInHelpMode());
            }
            event.getButtonList().add(button);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void resetArmorButtonPosition(GuiScreenEvent.KeyboardInputEvent.Post event) {
        if (!Keyboard.isKeyDown((int)19) || !GuiButtonArmorSlots.shouldMoveButton() || !(event.getGui() instanceof GuiInventoryArmorSlots) && !(event.getGui() instanceof GuiInventory) || Configs.armorButtonX.isAtDefaultValue() && Configs.armorButtonY.isAtDefaultValue()) {
            return;
        }
        List<GuiButton> buttonList = ReflectionExtraBitManipulation.getButtonList(event.getGui());
        for (GuiButton button : buttonList) {
            if (!(button instanceof GuiButtonArmorSlots)) continue;
            BitToolSettingsHelper.setArmorButtonPosition((Integer)Configs.armorButtonX.getDefaultValue(), (Integer)Configs.armorButtonY.getDefaultValue());
            ((GuiButtonArmorSlots)button).setPosition();
            break;
        }
    }

    static {
        for (int i = 0; i < 16; ++i) {
            COMMAND_VANITY_SLOTS.put("slot.vanity.set" + i / 4 + "." + EntityEquipmentSlot.values()[5 - i % 4].toString().toLowerCase(), i);
        }
    }

    public static enum ArmorButtonVisibiltyMode {
        CHISELED_ARMOR_ITEMS,
        EBM_ITEMS,
        EBM_OR_CNB_ITEMS,
        ANY_ITEMS,
        ALWAYS,
        NEVER;

    }
}

