/*
 * Decompiled with CFR 0.152.
 */
package com.phylogeny.extrabitmanipulation.packet;

import com.phylogeny.extrabitmanipulation.api.ChiselsAndBitsAPIAccess;
import com.phylogeny.extrabitmanipulation.helper.BitIOHelper;
import com.phylogeny.extrabitmanipulation.helper.ItemStackHelper;
import com.phylogeny.extrabitmanipulation.packet.PacketBitMapIO;
import io.netty.buffer.ByteBuf;
import java.util.Map;
import mod.chiselsandbits.api.APIExceptions;
import mod.chiselsandbits.api.IBitBrush;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketAddBitMapping
extends PacketBitMapIO {
    private IBlockState state;
    private IBitBrush bit;

    public PacketAddBitMapping() {
    }

    public PacketAddBitMapping(String nbtKey, IBlockState state, IBitBrush bit, boolean saveStatesById) {
        super(nbtKey, saveStatesById);
        this.state = state;
        this.bit = bit;
    }

    @Override
    public void toBytes(ByteBuf buffer) {
        super.toBytes(buffer);
        BitIOHelper.stateToBytes(buffer, this.state);
        boolean removeMapping = this.bit == null;
        buffer.writeBoolean(removeMapping);
        if (!removeMapping) {
            ByteBufUtils.writeItemStack((ByteBuf)buffer, (ItemStack)this.bit.getItemStack(1));
        }
    }

    @Override
    public void fromBytes(ByteBuf buffer) {
        super.fromBytes(buffer);
        this.state = BitIOHelper.stateFromBytes(buffer);
        if (buffer.readBoolean()) {
            this.bit = null;
            return;
        }
        try {
            this.bit = ChiselsAndBitsAPIAccess.apiInstance.createBrush(ByteBufUtils.readItemStack((ByteBuf)buffer));
        }
        catch (APIExceptions.InvalidBitItem e) {
            this.bit = null;
        }
    }

    public static class Handler
    implements IMessageHandler<PacketAddBitMapping, IMessage> {
        public IMessage onMessage(final PacketAddBitMapping message, final MessageContext ctx) {
            WorldServer mainThread = (WorldServer)ctx.getServerHandler().field_147369_b.field_70170_p;
            mainThread.func_152344_a(new Runnable(){

                @Override
                public void run() {
                    EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                    ItemStack stack = player.func_184614_ca();
                    if (ItemStackHelper.isModelingToolStack(stack)) {
                        Map<IBlockState, IBitBrush> bitMapPermanent = BitIOHelper.readStateToBitMapFromNBT(ChiselsAndBitsAPIAccess.apiInstance, stack, message.nbtKey);
                        if (message.bit != null) {
                            bitMapPermanent.put(message.state, message.bit);
                        } else {
                            bitMapPermanent.remove(message.state);
                        }
                        BitIOHelper.writeStateToBitMapToNBT(stack, message.nbtKey, bitMapPermanent, message.saveStatesById);
                        player.field_71069_bz.func_75142_b();
                    }
                }
            });
            return null;
        }
    }
}

