/*
 * Decompiled with CFR 0.152.
 */
package com.phylogeny.extrabitmanipulation.packet;

import com.phylogeny.extrabitmanipulation.armor.DataChiseledArmorPiece;
import com.phylogeny.extrabitmanipulation.armor.capability.ChiseledArmorSlotsHandler;
import com.phylogeny.extrabitmanipulation.armor.capability.IChiseledArmorSlotsHandler;
import com.phylogeny.extrabitmanipulation.client.GuiHelper;
import com.phylogeny.extrabitmanipulation.client.gui.armor.GuiChiseledArmor;
import com.phylogeny.extrabitmanipulation.helper.ItemStackHelper;
import com.phylogeny.extrabitmanipulation.init.RenderLayersExtraBitManipulation;
import com.phylogeny.extrabitmanipulation.item.ItemChiseledArmor;
import com.phylogeny.extrabitmanipulation.packet.PacketArmorSlotInt;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public abstract class PacketChangeChiseledArmorList
extends PacketArmorSlotInt {
    protected int armorItemIndex;
    protected int selectedEntry;
    protected boolean refreshLists;
    protected NBTTagCompound nbt = new NBTTagCompound();

    public PacketChangeChiseledArmorList() {
    }

    public PacketChangeChiseledArmorList(NBTTagCompound nbt, ItemChiseledArmor.ArmorType armorType, int indexArmorSet, int partIndex, int armorItemIndex, int selectedEntry, boolean refreshLists, @Nullable EntityPlayer player) {
        super(armorType, indexArmorSet, partIndex);
        IChiseledArmorSlotsHandler cap;
        this.nbt = nbt;
        this.armorItemIndex = armorItemIndex;
        this.selectedEntry = selectedEntry;
        this.refreshLists = refreshLists;
        if (indexArmorSet > 0 && player instanceof EntityPlayerMP && (cap = ChiseledArmorSlotsHandler.getCapability(player)) != null) {
            cap.markSlotDirty(armorType.getSlotIndex(indexArmorSet));
        }
    }

    @Override
    public void toBytes(ByteBuf buffer) {
        super.toBytes(buffer);
        ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)this.nbt);
        buffer.writeInt(this.armorItemIndex);
        buffer.writeInt(this.selectedEntry);
        buffer.writeBoolean(this.refreshLists);
    }

    @Override
    public void fromBytes(ByteBuf buffer) {
        super.fromBytes(buffer);
        this.nbt = ByteBufUtils.readTag((ByteBuf)buffer);
        this.armorItemIndex = buffer.readInt();
        this.selectedEntry = buffer.readInt();
        this.refreshLists = buffer.readBoolean();
    }

    protected NBTTagCompound getData(NBTTagCompound nbt, boolean serverSide) {
        NBTTagCompound data = ItemStackHelper.getArmorData(nbt);
        if (!serverSide) {
            RenderLayersExtraBitManipulation.removeFromRenderMaps(data);
        }
        return data;
    }

    protected void initData(PacketChangeChiseledArmorList message, ItemStack stack) {
        NBTTagCompound nbt = ItemStackHelper.getNBTOrNew(stack);
        if (nbt.func_74764_b("data")) {
            return;
        }
        new DataChiseledArmorPiece(message.armorType).saveToNBT(nbt);
        stack.func_77982_d(nbt);
    }

    protected void finalizeDataChange(PacketChangeChiseledArmorList message, ItemStack stack, NBTTagCompound nbt, NBTTagCompound data, boolean serverSide, boolean isArmorItem, boolean scrollToEnd, int glListRemovalIndex) {
        nbt.func_74782_a("data", (NBTBase)data);
        stack.func_77982_d(nbt);
        if (serverSide) {
            return;
        }
        if (message.refreshLists && GuiHelper.getOpenGui() instanceof GuiChiseledArmor) {
            ((GuiChiseledArmor)GuiHelper.getOpenGui()).refreshListsAndSelectEntry(message.selectedEntry, isArmorItem, scrollToEnd, glListRemovalIndex);
        }
    }
}

