/*
 * Decompiled with CFR 0.152.
 */
package com.phylogeny.extrabitmanipulation.packet;

import com.phylogeny.extrabitmanipulation.armor.capability.ChiseledArmorSlotsHandler;
import com.phylogeny.extrabitmanipulation.armor.capability.IChiseledArmorSlotsHandler;
import com.phylogeny.extrabitmanipulation.client.ClientHelper;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketSyncArmorSlot
implements IMessage {
    private UUID playerID;
    private ItemStack stack;
    private int index;

    public PacketSyncArmorSlot() {
    }

    public PacketSyncArmorSlot(UUID playerID, ItemStack stack, int index) {
        this.playerID = playerID;
        this.stack = stack;
        this.index = index;
    }

    public void toBytes(ByteBuf buffer) {
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.playerID.toString());
        ByteBufUtils.writeItemStack((ByteBuf)buffer, (ItemStack)this.stack);
        buffer.writeInt(this.index);
    }

    public void fromBytes(ByteBuf buffer) {
        this.playerID = UUID.fromString(ByteBufUtils.readUTF8String((ByteBuf)buffer));
        this.stack = ByteBufUtils.readItemStack((ByteBuf)buffer);
        this.index = buffer.readInt();
    }

    public static class Handler
    implements IMessageHandler<PacketSyncArmorSlot, IMessage> {
        public IMessage onMessage(final PacketSyncArmorSlot message, MessageContext ctx) {
            ClientHelper.getThreadListener().func_152344_a(new Runnable(){

                @Override
                public void run() {
                    EntityPlayer player = ClientHelper.getWorld().func_152378_a(message.playerID);
                    if (player == null) {
                        return;
                    }
                    IChiseledArmorSlotsHandler cap = ChiseledArmorSlotsHandler.getCapability(player);
                    if (cap != null) {
                        cap.setStackInSlot(message.index, message.stack);
                    }
                }
            });
            return null;
        }
    }
}

