/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.gui.button;

import buildcraft.lib.gui.BuildCraftGui;
import buildcraft.lib.gui.ISimpleDrawable;
import buildcraft.lib.gui.button.GuiAbstractButton;
import buildcraft.lib.gui.pos.IGuiArea;
import buildcraft.lib.gui.pos.IGuiPosition;
import net.minecraft.client.renderer.GlStateManager;

public final class GuiButtonDrawable
extends GuiAbstractButton {
    private final ISimpleDrawable drEnabled;
    private final ISimpleDrawable drActive;
    private final ISimpleDrawable drHovered;
    private final ISimpleDrawable drActiveHovered;
    private final ISimpleDrawable drDisabled;
    private final ISimpleDrawable drDisabledActive;

    public GuiButtonDrawable(BuildCraftGui gui, String id, IGuiPosition parent, Builder args) {
        super(gui, id, args.rect.offset(parent));
        this.drEnabled = args.enabled;
        this.drActive = GuiButtonDrawable.getFirstNonnull(args.active, args.enabled);
        this.drHovered = GuiButtonDrawable.getFirstNonnull(args.hovered, args.enabled);
        this.drActiveHovered = GuiButtonDrawable.getFirstNonnull(args.activeHovered, args.hovered, args.active, args.enabled);
        this.drDisabled = GuiButtonDrawable.getFirstNonnull(args.disabled, args.enabled);
        this.drDisabledActive = GuiButtonDrawable.getFirstNonnull(args.disabledActive, args.disabled, args.enabled);
    }

    private static ISimpleDrawable getFirstNonnull(ISimpleDrawable ... of) {
        for (ISimpleDrawable d : of) {
            if (d == null) continue;
            return d;
        }
        throw new NullPointerException("No non-null elements found!");
    }

    @Override
    public void drawBackground(float partialTicks) {
        if (!this.visible) {
            return;
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179141_d();
        GlStateManager.func_179084_k();
        if (this.enabled) {
            boolean hovered = this.isMouseOver();
            if (this.active) {
                if (hovered) {
                    this.drActiveHovered.drawAt(this);
                } else {
                    this.drActive.drawAt(this);
                }
            } else if (hovered) {
                this.drHovered.drawAt(this);
            } else {
                this.drEnabled.drawAt(this);
            }
        } else if (this.active) {
            this.drDisabledActive.drawAt(this);
        } else {
            this.drDisabled.drawAt(this);
        }
    }

    public static class Builder {
        public final IGuiArea rect;
        public final ISimpleDrawable enabled;
        public ISimpleDrawable active;
        public ISimpleDrawable hovered;
        public ISimpleDrawable activeHovered;
        public ISimpleDrawable disabled;
        public ISimpleDrawable disabledActive;

        public Builder(IGuiArea rect, ISimpleDrawable enabled) {
            this.rect = rect;
            this.enabled = enabled;
        }
    }
}

