/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.builder;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.thirteen.Context;
import mcjty.lib.varia.Logging;
import mcjty.rftools.RFTools;
import mcjty.rftools.items.builder.GuiChamberDetails;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PacketChamberInfoReady
implements IMessage {
    private Map<IBlockState, Integer> blocks;
    private Map<IBlockState, Integer> costs;
    private Map<IBlockState, ItemStack> stacks;
    private Map<String, Integer> entities;
    private Map<String, Integer> entityCosts;
    private Map<String, Entity> realEntities;
    private Map<String, String> playerNames;
    private static final byte ENTITY_NONE = 0;
    private static final byte ENTITY_NORMAL = 1;
    private static final byte ENTITY_PLAYER = 2;

    public void fromBytes(ByteBuf buf) {
        int cost;
        int count;
        int i;
        int size = buf.readInt();
        this.blocks = new HashMap<IBlockState, Integer>(size);
        this.costs = new HashMap<IBlockState, Integer>(size);
        this.stacks = new HashMap<IBlockState, ItemStack>();
        for (i = 0; i < size; ++i) {
            IBlockState bm = Block.func_176220_d((int)buf.readInt());
            count = buf.readInt();
            cost = buf.readInt();
            this.blocks.put(bm, count);
            this.costs.put(bm, cost);
            if (!buf.readBoolean()) continue;
            ItemStack stack = NetworkTools.readItemStack((ByteBuf)buf);
            this.stacks.put(bm, stack);
        }
        size = buf.readInt();
        this.entities = new HashMap<String, Integer>(size);
        this.entityCosts = new HashMap<String, Integer>(size);
        this.realEntities = new HashMap<String, Entity>();
        this.playerNames = new HashMap<String, String>();
        for (i = 0; i < size; ++i) {
            String className = NetworkTools.readString((ByteBuf)buf);
            count = buf.readInt();
            cost = buf.readInt();
            this.entities.put(className, count);
            this.entityCosts.put(className, cost);
            byte how = buf.readByte();
            if (how == 1) {
                NBTTagCompound nbt = PacketChamberInfoReady.readNBT(buf);
                Entity entity = EntityList.func_75615_a((NBTTagCompound)nbt, (World)RFTools.proxy.getClientWorld());
                this.realEntities.put(className, entity);
                continue;
            }
            if (how != 2) continue;
            int entityId = buf.readInt();
            String entityName = NetworkTools.readString((ByteBuf)buf);
            Entity entity = RFTools.proxy.getClientWorld().func_73045_a(entityId);
            if (entity != null) {
                this.realEntities.put(className, entity);
            }
            this.playerNames.put(className, entityName);
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.blocks.size());
        for (Map.Entry<IBlockState, Integer> entry : this.blocks.entrySet()) {
            IBlockState bm = entry.getKey();
            buf.writeInt(Block.func_176210_f((IBlockState)bm));
            buf.writeInt(entry.getValue().intValue());
            buf.writeInt(this.costs.get(bm).intValue());
            if (this.stacks.containsKey(bm)) {
                buf.writeBoolean(true);
                NetworkTools.writeItemStack((ByteBuf)buf, (ItemStack)this.stacks.get(bm));
                continue;
            }
            buf.writeBoolean(false);
        }
        buf.writeInt(this.entities.size());
        for (Map.Entry<Object, Integer> entry : this.entities.entrySet()) {
            String name = (String)entry.getKey();
            NetworkTools.writeString((ByteBuf)buf, (String)name);
            buf.writeInt(entry.getValue().intValue());
            buf.writeInt(this.entityCosts.get(name).intValue());
            if (this.realEntities.containsKey(name)) {
                Entity entity = this.realEntities.get(name);
                if (entity instanceof EntityPlayer) {
                    buf.writeByte(2);
                    int entityId = entity.func_145782_y();
                    buf.writeInt(entityId);
                    NetworkTools.writeString((ByteBuf)buf, (String)entity.func_145748_c_().func_150254_d());
                    continue;
                }
                buf.writeByte(1);
                NBTTagCompound nbt = entity.serializeNBT();
                PacketChamberInfoReady.writeNBT(buf, nbt);
                continue;
            }
            buf.writeByte(0);
        }
    }

    private static NBTTagCompound readNBT(ByteBuf dataIn) {
        PacketBuffer buf = new PacketBuffer(dataIn);
        try {
            return buf.func_150793_b();
        }
        catch (IOException e) {
            Logging.logError((String)"Error parsing packet chamber info", (Throwable)e);
            return null;
        }
    }

    private static void writeNBT(ByteBuf dataOut, NBTTagCompound nbt) {
        PacketBuffer buf = new PacketBuffer(dataOut);
        try {
            buf.func_150786_a(nbt);
        }
        catch (Exception e) {
            Logging.logError((String)"Error writing packet chamber info", (Throwable)e);
        }
    }

    public PacketChamberInfoReady() {
    }

    public PacketChamberInfoReady(ByteBuf buf) {
        this.fromBytes(buf);
    }

    public PacketChamberInfoReady(Map<IBlockState, Integer> blocks, Map<IBlockState, Integer> costs, Map<IBlockState, ItemStack> stacks, Map<String, Integer> entities, Map<String, Integer> entityCosts, Map<String, Entity> realEntities) {
        this.blocks = new HashMap<IBlockState, Integer>(blocks);
        this.costs = new HashMap<IBlockState, Integer>(costs);
        this.stacks = new HashMap<IBlockState, ItemStack>(stacks);
        this.entities = new HashMap<String, Integer>(entities);
        this.entityCosts = new HashMap<String, Integer>(entityCosts);
        this.realEntities = new HashMap<String, Entity>(realEntities);
    }

    public void handle(Supplier<Context> supplier) {
        Context ctx = supplier.get();
        ctx.enqueueWork(() -> GuiChamberDetails.setItemsWithCount(this.blocks, this.costs, this.stacks, this.entities, this.entityCosts, this.realEntities, this.playerNames));
        ctx.setPacketHandled(true);
    }
}

