/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.blocks;

import com.zuxelus.energycontrol.EnergyControl;
import com.zuxelus.energycontrol.blocks.FacingBlock;
import com.zuxelus.energycontrol.crossmod.CrossModLoader;
import com.zuxelus.energycontrol.tileentities.TileEntityHowlerAlarm;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class HowlerAlarm
extends FacingBlock {
    protected static final AxisAlignedBB AABB_DOWN = new AxisAlignedBB(0.125, 0.5625, 0.125, 0.875, 1.0, 0.875);
    protected static final AxisAlignedBB AABB_UP = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 0.4375, 0.875);
    protected static final AxisAlignedBB AABB_NORTH = new AxisAlignedBB(0.125, 0.125, 0.5625, 0.875, 0.875, 1.0);
    protected static final AxisAlignedBB AABB_SOUTH = new AxisAlignedBB(0.125, 0.125, 0.0, 0.875, 0.875, 0.4375);
    protected static final AxisAlignedBB AABB_WEST = new AxisAlignedBB(0.5625, 0.125, 0.125, 1.0, 0.875, 0.875);
    protected static final AxisAlignedBB AABB_EAST = new AxisAlignedBB(0.0, 0.125, 0.125, 0.4375, 0.875, 0.875);

    public TileEntity func_149915_a(World world, int meta) {
        TileEntityHowlerAlarm te = new TileEntityHowlerAlarm();
        te.setFacing(meta);
        return te;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176198_a(World worldIn, BlockPos pos, EnumFacing side) {
        return HowlerAlarm.canPlaceBlock(worldIn, pos, side.func_176734_d());
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        for (EnumFacing enumfacing : EnumFacing.values()) {
            if (!HowlerAlarm.canPlaceBlock(worldIn, pos, enumfacing)) continue;
            return true;
        }
        return false;
    }

    protected static boolean canPlaceBlock(World worldIn, BlockPos pos, EnumFacing direction) {
        BlockPos blockpos = pos.func_177972_a(direction);
        return worldIn.func_180495_p(blockpos).isSideSolid((IBlockAccess)worldIn, blockpos, direction.func_176734_d());
    }

    @Override
    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return HowlerAlarm.canPlaceBlock(world, pos, facing.func_176734_d()) ? this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing) : this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.DOWN);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        if (this.checkForDrop(world, pos, state) && !HowlerAlarm.canPlaceBlock(world, pos, ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176734_d())) {
            this.func_176226_b(world, pos, state, 0);
            world.func_175698_g(pos);
        } else if (!world.field_72995_K) {
            world.func_184138_a(pos, state, state, 2);
        }
    }

    private boolean checkForDrop(World worldIn, BlockPos pos, IBlockState state) {
        if (this.func_176196_c(worldIn, pos)) {
            return true;
        }
        this.func_176226_b(worldIn, pos, state, 0);
        worldIn.func_175698_g(pos);
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        switch (enumfacing) {
            case EAST: {
                return AABB_EAST;
            }
            case WEST: {
                return AABB_WEST;
            }
            case SOUTH: {
                return AABB_SOUTH;
            }
            default: {
                return AABB_NORTH;
            }
            case UP: {
                return AABB_UP;
            }
            case DOWN: 
        }
        return AABB_DOWN;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (CrossModLoader.ic2.isWrench(player.func_184586_b(hand))) {
            return true;
        }
        if (world.field_72995_K) {
            player.openGui((Object)EnergyControl.instance, 2, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    @Override
    public boolean setFacing(World world, BlockPos pos, EnumFacing newDirection, EntityPlayer player) {
        return false;
    }
}

