/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.config;

import com.zuxelus.energycontrol.EnergyControl;
import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ConfigHandler {
    public Configuration configuration;
    public int howlerAlarmRange;
    public int maxAlarmRange;
    public String allowedAlarms;
    public int remoteThermalMonitorEnergyConsumption;
    public int infoPanelRefreshPeriod;
    public int rangeTriggerRefreshPeriod;
    public int SMPMaxAlarmRange;
    public boolean useCustomSounds;

    public void init(File configFile) {
        if (this.configuration == null) {
            this.configuration = new Configuration(configFile);
        }
        this.loadConfiguration();
    }

    private void loadConfiguration() {
        try {
            this.howlerAlarmRange = this.configuration.getInt("howlerAlarmRange", "general", 64, 0, 256, "", "ec.config.howlerAlarmRange");
            this.maxAlarmRange = this.configuration.getInt("maxAlarmRange", "general", 128, 0, 256, "", "ec.config.maxAlarmRange");
            this.allowedAlarms = this.configuration.getString("allowedAlarms", "general", "default,sci-fi,siren", "", "ec.config.allowedAlarms").replaceAll(" ", "");
            this.remoteThermalMonitorEnergyConsumption = this.configuration.getInt("remoteThermalMonitorEnergyConsumption", "general", 1, 0, 1000, "", "ec.config.remoteThermalMonitorEnergyConsumption");
            this.infoPanelRefreshPeriod = this.configuration.getInt("infoPanelRefreshPeriod", "general", 20, 0, 2000, "", "ec.config.screenRefreshPeriod");
            this.rangeTriggerRefreshPeriod = this.configuration.getInt("rangeTriggerRefreshPeriod", "general", 20, 0, 2000, "", "ec.config.rangeTriggerRefreshPeriod");
            this.SMPMaxAlarmRange = this.configuration.getInt("SMPMaxAlarmRange", "general", 256, 0, 512, "", "ec.config.SMPMaxAlarmRange");
            this.useCustomSounds = this.configuration.getBoolean("useCustomSounds", "general", false, "", "ec.config.useCustomSounds");
        }
        catch (Exception e) {
            EnergyControl.logger.error("Mod has a problem loading it's configuration", (Throwable)e);
        }
        finally {
            if (this.configuration.hasChanged()) {
                this.configuration.save();
            }
        }
    }

    public void save() {
        if (this.configuration.hasChanged()) {
            this.configuration.save();
        }
    }

    @SubscribeEvent
    public void onConfigurationChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("energycontrol")) {
            this.loadConfiguration();
        }
    }
}

