/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.crossmod;

import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.fluid.OxygenPressureProtocol;
import micdoodle8.mods.galacticraft.core.tile.TileEntityOxygenCollector;
import micdoodle8.mods.galacticraft.core.tile.TileEntityOxygenSealer;
import micdoodle8.mods.galacticraft.core.tile.TileEntityRefinery;
import micdoodle8.mods.galacticraft.core.tile.TileEntitySolar;
import micdoodle8.mods.galacticraft.core.util.EnumColor;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.RedstoneUtil;
import micdoodle8.mods.galacticraft.planets.mars.tile.TileEntityElectrolyzer;
import micdoodle8.mods.galacticraft.planets.mars.tile.TileEntityGasLiquefier;
import micdoodle8.mods.galacticraft.planets.mars.tile.TileEntityLaunchController;
import micdoodle8.mods.galacticraft.planets.mars.tile.TileEntityMethaneSynthesizer;
import micdoodle8.mods.galacticraft.planets.venus.tile.TileEntitySolarArrayController;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class GalacticraftHelper {
    public static String getStatus(TileEntityOxygenCollector collector) {
        String returnValue = collector.getGUIstatus();
        if (returnValue.equals(EnumColor.DARK_GREEN + GCCoreUtil.translate((String)"gui.status.active.name")) && collector.lastOxygenCollected <= 0.0f) {
            return EnumColor.DARK_RED + GCCoreUtil.translate((String)"gui.status.missingleaves.name");
        }
        return returnValue;
    }

    public static String getThermalStatus(TileEntityOxygenSealer sealer) {
        IBlockState stateAbove = sealer.func_145831_w().func_180495_p(sealer.func_174877_v().func_177984_a());
        Block blockAbove = stateAbove.func_177230_c();
        if ((blockAbove == GCBlocks.breatheableAir || blockAbove == GCBlocks.brightBreatheableAir) && blockAbove.func_176201_c(stateAbove) == 1) {
            return EnumColor.DARK_GREEN + GCCoreUtil.translate((String)"gui.status.on.name");
        }
        if (sealer.thermalControlEnabled()) {
            return EnumColor.DARK_RED + GCCoreUtil.translate((String)"gui.status.not_available.name");
        }
        return EnumColor.DARK_RED + GCCoreUtil.translate((String)"gui.status.off.name");
    }

    public static String getStatus(TileEntityOxygenSealer sealer) {
        IBlockState state;
        BlockPos blockPosAbove = sealer.func_174877_v().func_177984_a();
        Block blockAbove = sealer.func_145831_w().func_180495_p(blockPosAbove).func_177230_c();
        if (!blockAbove.isAir(state = sealer.func_145831_w().func_180495_p(blockPosAbove), (IBlockAccess)sealer.func_145831_w(), blockPosAbove) && !OxygenPressureProtocol.canBlockPassAir((World)sealer.func_145831_w(), (Block)blockAbove, (BlockPos)blockPosAbove, (EnumFacing)EnumFacing.UP)) {
            return EnumColor.DARK_RED + GCCoreUtil.translate((String)"gui.status.sealerblocked.name");
        }
        if (sealer.disabled) {
            return EnumColor.ORANGE + GCCoreUtil.translate((String)"gui.status.disabled.name");
        }
        if (sealer.getEnergyStoredGC() == 0.0f) {
            return EnumColor.DARK_RED + GCCoreUtil.translate((String)"gui.status.missingpower.name");
        }
        if (sealer.getEnergyStoredGC() < sealer.storage.getMaxExtract()) {
            return EnumColor.ORANGE + GCCoreUtil.translate((String)"gui.status.missingpower.name");
        }
        if (sealer.getOxygenStored() < 1) {
            return EnumColor.DARK_RED + GCCoreUtil.translate((String)"gui.status.missingoxygen.name");
        }
        if (sealer.calculatingSealed) {
            return EnumColor.ORANGE + GCCoreUtil.translate((String)"gui.status.checking_seal.name") + "...";
        }
        int threadCooldown = sealer.getScaledThreadCooldown(25);
        if (threadCooldown < 15) {
            if (threadCooldown < 4) {
                String elipsis = "";
                for (int i = 0; i < (23 - threadCooldown) % 4; ++i) {
                    elipsis = elipsis + ".";
                }
                return EnumColor.ORANGE + GCCoreUtil.translate((String)"gui.status.check_starting.name") + elipsis;
            }
            return EnumColor.ORANGE + GCCoreUtil.translate((String)"gui.status.check_pending.name");
        }
        if (!sealer.sealed) {
            return EnumColor.DARK_RED + GCCoreUtil.translate((String)"gui.status.unsealed.name");
        }
        return EnumColor.DARK_GREEN + GCCoreUtil.translate((String)"gui.status.sealed.name");
    }

    public static String getStatus(TileEntityRefinery te) {
        String missingInput = null;
        if (te.oilTank.getFluid() == null || te.oilTank.getFluidAmount() == 0) {
            missingInput = EnumColor.RED + GCCoreUtil.translate((String)"gui.status.nooil.name");
        }
        String activeString = te.canProcess() ? EnumColor.BRIGHT_GREEN + GCCoreUtil.translate((String)"gui.status.refining.name") : null;
        return te.getGUIstatus(missingInput, activeString, false);
    }

    public static String getStatus(TileEntityElectrolyzer te) {
        String displayText = "";
        displayText = RedstoneUtil.isBlockReceivingRedstone((World)te.func_145831_w(), (BlockPos)te.func_174877_v()) ? EnumColor.RED + GCCoreUtil.translate((String)"gui.status.off.name") : (!te.hasEnoughEnergyToRun ? EnumColor.RED + GCCoreUtil.translate((String)"gui.message.low_energy.name") : (te.waterTank.getFluid() == null || te.waterTank.getFluidAmount() == 0 ? EnumColor.RED + GCCoreUtil.translate((String)"gui.message.zero_water.name") : (te.waterTank.getFluidAmount() > 0 && te.disabled ? EnumColor.ORANGE + GCCoreUtil.translate((String)"gui.status.ready.name") : (te.canProcess() ? EnumColor.BRIGHT_GREEN + GCCoreUtil.translate((String)"gui.status.running.name") : (te.liquidTank.getFluidAmount() == te.liquidTank.getCapacity() && te.liquidTank2.getFluidAmount() == te.liquidTank2.getCapacity() ? EnumColor.RED + GCCoreUtil.translate((String)"gui.status.tanksfull.name") : EnumColor.RED + GCCoreUtil.translate((String)"gui.status.unknown.name"))))));
        return displayText;
    }

    public static String getStatus(TileEntityMethaneSynthesizer te) {
        String displayText = "";
        displayText = RedstoneUtil.isBlockReceivingRedstone((World)te.func_145831_w(), (BlockPos)te.func_174877_v()) ? EnumColor.RED + GCCoreUtil.translate((String)"gui.status.off.name") : (!te.hasEnoughEnergyToRun ? EnumColor.RED + GCCoreUtil.translate((String)"gui.message.low_energy.name") : (te.processTicks > -8 || te.canProcess() ? EnumColor.BRIGHT_GREEN + GCCoreUtil.translate((String)"gui.status.processing.name") : (te.gasTank.getFluid() == null || te.gasTank.getFluidAmount() == 0 ? EnumColor.RED + GCCoreUtil.translate((String)"gui.status.nogas.name") : (te.gasTank.getFluidAmount() > 0 && te.disabled ? EnumColor.ORANGE + GCCoreUtil.translate((String)"gui.status.ready.name") : (te.liquidTank.getFluidAmount() == te.liquidTank.getCapacity() ? EnumColor.RED + GCCoreUtil.translate((String)"gui.status.tankfull.name") : EnumColor.RED + GCCoreUtil.translate((String)"gui.status.needs_carbon.name"))))));
        return displayText;
    }

    public static String getStatus(TileEntityGasLiquefier te) {
        String displayText = "";
        displayText = RedstoneUtil.isBlockReceivingRedstone((World)te.func_145831_w(), (BlockPos)te.func_174877_v()) ? EnumColor.RED + GCCoreUtil.translate((String)"gui.status.off.name") : (!te.hasEnoughEnergyToRun ? EnumColor.RED + GCCoreUtil.translate((String)"gui.message.low_energy.name") : (te.processTicks > -10 || te.canProcess() ? EnumColor.BRIGHT_GREEN + GCCoreUtil.translate((String)"gui.status.liquefying.name") : (te.gasTank.getFluid() == null || te.gasTank.getFluidAmount() <= 0 ? EnumColor.RED + GCCoreUtil.translate((String)"gui.status.nogas.name") : (te.gasTank.getFluidAmount() > 0 && te.disabled ? EnumColor.ORANGE + GCCoreUtil.translate((String)"gui.status.ready.name") : (te.liquidTank.getFluidAmount() == te.liquidTank.getCapacity() && te.liquidTank2.getFluidAmount() == te.liquidTank2.getCapacity() ? EnumColor.RED + GCCoreUtil.translate((String)"gui.status.tanksfull.name") : EnumColor.RED + GCCoreUtil.translate((String)"gui.status.unknown.name"))))));
        return displayText;
    }

    public static String getStatus(TileEntitySolar te) {
        if (te.getDisabled(0)) {
            return EnumColor.ORANGE + GCCoreUtil.translate((String)"gui.status.disabled.name");
        }
        if (!te.func_145831_w().func_72935_r()) {
            return EnumColor.DARK_RED + GCCoreUtil.translate((String)"gui.status.blockedfully.name");
        }
        if (te.func_145831_w().func_72896_J() || te.func_145831_w().func_72911_I()) {
            return EnumColor.DARK_RED + GCCoreUtil.translate((String)"gui.status.raining.name");
        }
        if (te.solarStrength == 0) {
            return EnumColor.DARK_RED + GCCoreUtil.translate((String)"gui.status.blockedfully.name");
        }
        if (te.solarStrength < 9) {
            return EnumColor.DARK_RED + GCCoreUtil.translate((String)"gui.status.blockedpartial.name");
        }
        if (te.generateWatts > 0) {
            return EnumColor.DARK_GREEN + GCCoreUtil.translate((String)"gui.status.collectingenergy.name");
        }
        return EnumColor.ORANGE + GCCoreUtil.translate((String)"gui.status.unknown.name");
    }

    public static String getStatus(TileEntityLaunchController te) {
        if (!te.frequencyValid) {
            return EnumColor.RED + GCCoreUtil.translate((String)"gui.message.invalid_freq.name");
        }
        if (te.getEnergyStoredGC() <= 0.0f) {
            return EnumColor.RED + GCCoreUtil.translate((String)"gui.message.no_energy.name");
        }
        if (te.getDisabled(0)) {
            return EnumColor.ORANGE + GCCoreUtil.translate((String)"gui.status.disabled.name");
        }
        return EnumColor.BRIGHT_GREEN + GCCoreUtil.translate((String)"gui.status.active.name");
    }

    public static String getStatus(TileEntitySolarArrayController te) {
        if (te.getDisabled(0)) {
            return EnumColor.ORANGE + GCCoreUtil.translate((String)"gui.status.disabled.name");
        }
        if (!te.func_145831_w().func_72935_r()) {
            return EnumColor.DARK_RED + GCCoreUtil.translate((String)"gui.status.blockedfully.name");
        }
        if (te.func_145831_w().func_72896_J() || te.func_145831_w().func_72911_I()) {
            return EnumColor.DARK_RED + GCCoreUtil.translate((String)"gui.status.raining.name");
        }
        float sunVisible = (float)Math.floor((float)te.getActualArraySize() / (float)te.getPossibleArraySize());
        if (sunVisible == 0.0f) {
            return EnumColor.DARK_RED + GCCoreUtil.translate((String)"gui.status.blockedfully.name");
        }
        if (sunVisible < 1.0f) {
            return EnumColor.DARK_RED + GCCoreUtil.translate((String)"gui.status.blockedpartial.name");
        }
        if (te.generateWatts > 0) {
            return EnumColor.DARK_GREEN + GCCoreUtil.translate((String)"gui.status.collectingenergy.name");
        }
        return EnumColor.ORANGE + GCCoreUtil.translate((String)"gui.status.unknown.name");
    }
}

