/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.crossmod.buildcraft;

import buildcraft.lib.engine.TileEngineBase_BC8;
import buildcraft.lib.fluid.TankManager;
import buildcraft.lib.tile.TileBC_Neptune;
import com.zuxelus.energycontrol.api.ItemStackHelper;
import com.zuxelus.energycontrol.crossmod.buildcraft.CrossBC;
import com.zuxelus.energycontrol.items.ItemHelper;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class BuildCraft
extends CrossBC {
    @Override
    public boolean modLoaded() {
        return true;
    }

    @Override
    public List<IFluidTank> getAllTanks(TileEntity te) {
        if (te instanceof TileBC_Neptune) {
            try {
                Field field = TileBC_Neptune.class.getDeclaredField("tankManager");
                field.setAccessible(true);
                TankManager tankManager = (TankManager)field.get(te);
                IFluidTankProperties[] tanks = tankManager.getTankProperties();
                ArrayList<IFluidTank> result = new ArrayList<IFluidTank>();
                for (IFluidTankProperties tank : tanks) {
                    result.add((IFluidTank)new FluidTank(tank.getContents(), tank.getCapacity()));
                }
                return result;
            }
            catch (Throwable t) {
                return null;
            }
        }
        return null;
    }

    @Override
    public ItemStack getGeneratorCard(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEngineBase_BC8) {
            ItemStack sensorLocationCard = new ItemStack(ItemHelper.itemCard, 1, 9);
            ItemStackHelper.setCoordinates(sensorLocationCard, pos);
            return sensorLocationCard;
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public NBTTagCompound getEngineData(TileEntity te) {
        if (!(te instanceof TileEngineBase_BC8)) {
            return null;
        }
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("type", 1);
        tag.func_74780_a("output", (double)((TileEngineBase_BC8)te).getCurrentOutput() / Math.pow(10.0, 6.0));
        tag.func_74757_a("active", ((TileEngineBase_BC8)te).isBurning());
        tag.func_74780_a("power", (double)((TileEngineBase_BC8)te).getEnergyStored() / Math.pow(10.0, 6.0));
        tag.func_74780_a("powerLevel", ((TileEngineBase_BC8)te).getPowerLevel() * 100.0);
        tag.func_74780_a("maxPower", (double)((TileEngineBase_BC8)te).getMaxPower() / Math.pow(10.0, 6.0));
        tag.func_74780_a("heat", ((TileEngineBase_BC8)te).getHeat());
        tag.func_74780_a("heatLevel", ((TileEngineBase_BC8)te).getHeatLevel() * 100.0);
        tag.func_74780_a("speed", ((TileEngineBase_BC8)te).getPistonSpeed());
        return tag;
    }
}

