/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.crossmod.computercraft;

import com.zuxelus.energycontrol.api.PanelString;
import com.zuxelus.energycontrol.crossmod.computercraft.ArgumentHelper;
import com.zuxelus.energycontrol.items.ItemUpgrade;
import com.zuxelus.energycontrol.items.cards.ItemCardMain;
import com.zuxelus.energycontrol.items.cards.ItemCardReader;
import com.zuxelus.energycontrol.tileentities.TileEntityInfoPanel;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;

public class InfoPanelPeripheral
implements IPeripheral {
    private final TileEntityInfoPanel te;

    public InfoPanelPeripheral(TileEntityInfoPanel te) {
        this.te = te;
    }

    public String getType() {
        return "info_panel";
    }

    public String[] getMethodNames() {
        return new String[]{"hasColorUpgrade", "isActive", "getRange", "getCardData", "getColorBack", "getColorText", "setColorBack", "setColorText", "getCardTitle", "setCardTitle"};
    }

    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] args) throws LuaException, InterruptedException {
        switch (method) {
            case 0: {
                return new Object[]{this.te.getColored()};
            }
            case 1: {
                return new Object[]{this.te.powered};
            }
            case 2: {
                ItemStack itemStack = this.te.func_70301_a(this.te.getSlotUpgradeRange());
                int upgradeCountRange = 0;
                if (itemStack != ItemStack.field_190927_a && itemStack.func_77973_b() instanceof ItemUpgrade && itemStack.func_77952_i() == 0) {
                    upgradeCountRange = itemStack.func_190916_E();
                }
                return new Object[]{8 * (int)Math.pow(2.0, Math.min(upgradeCountRange, 7))};
            }
            case 3: {
                List<PanelString> joinedData = this.te.getPanelStringList(false);
                NonNullList list = NonNullList.func_191196_a();
                if (joinedData == null || joinedData.size() == 0) {
                    return new Object[]{list};
                }
                for (PanelString panelString : joinedData) {
                    if (panelString.textLeft != null) {
                        list.add(panelString.textLeft);
                    }
                    if (panelString.textCenter != null) {
                        list.add(panelString.textCenter);
                    }
                    if (panelString.textRight == null) continue;
                    list.add(panelString.textRight);
                }
                return list.toArray();
            }
            case 4: {
                return new Object[]{this.te.getColorBackground()};
            }
            case 5: {
                return new Object[]{this.te.getColorText()};
            }
            case 6: {
                int value = ArgumentHelper.getInt(args, 0);
                if (value >= 0 && value < 16) {
                    this.te.setColorBackground(value);
                }
                return null;
            }
            case 7: {
                int value = ArgumentHelper.getInt(args, 0);
                if (value >= 0 && value < 16) {
                    this.te.setColorText(value);
                }
                return null;
            }
            case 8: {
                ItemStack stack = this.te.func_70301_a(0);
                if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemCardMain)) {
                    return new Object[]{""};
                }
                return new Object[]{new ItemCardReader(stack).getTitle()};
            }
            case 9: {
                String title = ArgumentHelper.getString(args, 0);
                ItemStack stack = this.te.func_70301_a(0);
                if (title != null && !stack.func_190926_b() && stack.func_77973_b() instanceof ItemCardMain) {
                    new ItemCardReader(stack).setTitle(title);
                }
                return null;
            }
        }
        return null;
    }

    public boolean equals(IPeripheral other) {
        return other instanceof InfoPanelPeripheral && ((InfoPanelPeripheral)other).te == this.te;
    }
}

