/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.items.cards;

import com.zuxelus.energycontrol.api.CardState;
import com.zuxelus.energycontrol.api.ICardReader;
import com.zuxelus.energycontrol.api.PanelSetting;
import com.zuxelus.energycontrol.api.PanelString;
import com.zuxelus.energycontrol.crossmod.CrossModLoader;
import com.zuxelus.energycontrol.items.cards.ItemCardBase;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemCardEngine
extends ItemCardBase {
    public ItemCardEngine() {
        super(9, "card_engine");
    }

    @Override
    public CardState update(World world, ICardReader reader, int range, BlockPos pos) {
        BlockPos target = reader.getTarget();
        if (target == null) {
            return CardState.NO_TARGET;
        }
        TileEntity entity = world.func_175625_s(target);
        NBTTagCompound tag = CrossModLoader.buildCraft.getEngineData(entity);
        if (tag == null || !tag.func_74764_b("type")) {
            return CardState.NO_TARGET;
        }
        reader.setInt("type", tag.func_74762_e("type"));
        switch (tag.func_74762_e("type")) {
            case 1: {
                reader.setDouble("output", tag.func_74769_h("output"));
                reader.setDouble("power", tag.func_74769_h("power"));
                reader.setDouble("powerLevel", tag.func_74769_h("powerLevel"));
                reader.setDouble("maxPower", tag.func_74769_h("maxPower"));
                reader.setDouble("heat", tag.func_74769_h("heat"));
                reader.setDouble("heatLevel", tag.func_74769_h("heatLevel"));
                reader.setDouble("speed", tag.func_74769_h("speed"));
            }
        }
        reader.setBoolean("active", tag.func_74767_n("active"));
        return CardState.OK;
    }

    @Override
    public List<PanelString> getStringData(int settings, ICardReader reader, boolean showLabels) {
        List<PanelString> result = reader.getTitleList();
        switch (reader.getInt("type")) {
            case 1: {
                result.add(new PanelString("msg.ec.InfoPanelOutputMJ", reader.getDouble("output"), showLabels));
                if ((settings & 1) > 0) {
                    result.add(new PanelString("msg.ec.InfoPanelHeat", reader.getDouble("heat"), showLabels));
                    result.add(new PanelString("msg.ec.InfoPanelHeatPercentage", reader.getDouble("heatLevel"), showLabels));
                }
                if ((settings & 2) > 0) {
                    result.add(new PanelString("msg.ec.InfoPanelStorageMJ", reader.getDouble("power"), showLabels));
                }
                if ((settings & 4) > 0) {
                    result.add(new PanelString("msg.ec.InfoPanelPercentage", reader.getDouble("powerLevel"), showLabels));
                    result.add(new PanelString("msg.ec.InfoPanelMaxStorageMJ", reader.getDouble("maxPower"), showLabels));
                }
                if ((settings & 8) <= 0) break;
                result.add(new PanelString("msg.ec.InfoPanelSpeed", reader.getDouble("speed"), showLabels));
            }
        }
        if ((settings & 0x10) > 0) {
            this.addOnOff(result, reader.getBoolean("active"));
        }
        return result;
    }

    @Override
    public List<PanelSetting> getSettingsList() {
        ArrayList<PanelSetting> result = new ArrayList<PanelSetting>(5);
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelHeat", (Object[])new Object[0]), 1, this.damage));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelStorage", (Object[])new Object[0]), 2, this.damage));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelMaxStorage", (Object[])new Object[0]), 4, this.damage));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelSpeed", (Object[])new Object[0]), 8, this.damage));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelOnOff", (Object[])new Object[0]), 16, this.damage));
        return result;
    }

    @Override
    public int getKitFromCard() {
        return 4;
    }
}

