/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.items.cards;

import com.zuxelus.energycontrol.api.CardState;
import com.zuxelus.energycontrol.api.ICardReader;
import com.zuxelus.energycontrol.api.PanelSetting;
import com.zuxelus.energycontrol.api.PanelString;
import com.zuxelus.energycontrol.crossmod.CrossModLoader;
import com.zuxelus.energycontrol.items.cards.ItemCardBase;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemCardGeneratorHeat
extends ItemCardBase {
    public ItemCardGeneratorHeat() {
        super(6, "card_generator_heat");
    }

    @Override
    public CardState update(World world, ICardReader reader, int range, BlockPos pos) {
        BlockPos target = reader.getTarget();
        if (target == null) {
            return CardState.NO_TARGET;
        }
        TileEntity entity = world.func_175625_s(target);
        NBTTagCompound tag = CrossModLoader.ic2.getGeneratorHeatData(entity);
        if (tag == null || !tag.func_74764_b("type")) {
            return CardState.NO_TARGET;
        }
        reader.setInt("type", tag.func_74762_e("type"));
        switch (tag.func_74762_e("type")) {
            case 1: 
            case 3: {
                reader.setDouble("storage", tag.func_74769_h("storage"));
                reader.setDouble("maxStorage", tag.func_74769_h("maxStorage"));
                reader.setInt("items", tag.func_74762_e("items"));
                break;
            }
            case 2: {
                reader.setDouble("storage", tag.func_74769_h("storage"));
                reader.setDouble("maxStorage", tag.func_74769_h("maxStorage"));
                break;
            }
            case 4: {
                reader.setInt("items", tag.func_74762_e("items"));
                reader.setDouble("multiplier", tag.func_74769_h("multiplier"));
            }
        }
        reader.setInt("output", tag.func_74762_e("output"));
        reader.setInt("energy", tag.func_74762_e("energy"));
        reader.setBoolean("active", tag.func_74767_n("active"));
        return CardState.OK;
    }

    @Override
    public List<PanelString> getStringData(int settings, ICardReader reader, boolean showLabels) {
        List<PanelString> result = reader.getTitleList();
        if ((settings & 1) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelOutputHU", reader.getInt("output").intValue(), showLabels));
        }
        if ((settings & 2) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelBufferHU", reader.getInt("energy").intValue(), showLabels));
        }
        switch (reader.getInt("type")) {
            case 1: {
                if ((settings & 4) > 0) {
                    result.add(new PanelString("msg.ec.InfoPanelStorageEU", reader.getDouble("storage"), showLabels));
                }
                if ((settings & 8) > 0) {
                    result.add(new PanelString("msg.ec.InfoPanelCapacityEU", reader.getDouble("maxStorage"), showLabels));
                }
                if ((settings & 0x10) <= 0) break;
                result.add(new PanelString("msg.ec.InfoPanelCoils", reader.getInt("items").intValue(), showLabels));
                break;
            }
            case 2: {
                if ((settings & 4) > 0) {
                    result.add(new PanelString("msg.ec.InfoPanelStorageL", reader.getDouble("storage"), showLabels));
                }
                if ((settings & 8) <= 0) break;
                result.add(new PanelString("msg.ec.InfoPanelCapacityL", reader.getDouble("maxStorage"), showLabels));
                break;
            }
            case 3: {
                if ((settings & 4) > 0) {
                    result.add(new PanelString("msg.ec.InfoPanelStorageL", reader.getDouble("storage"), showLabels));
                }
                if ((settings & 8) > 0) {
                    result.add(new PanelString("msg.ec.InfoPanelCapacityL", reader.getDouble("maxStorage"), showLabels));
                }
                if ((settings & 0x10) <= 0) break;
                result.add(new PanelString("msg.ec.InfoPanelConductors", reader.getInt("items").intValue(), showLabels));
                break;
            }
            case 4: {
                if ((settings & 0x10) > 0) {
                    result.add(new PanelString("msg.ec.InfoPanelPellets", reader.getInt("items").intValue(), showLabels));
                }
                if ((settings & 0x20) <= 0) break;
                result.add(new PanelString("msg.ec.InfoPanelMultiplier", reader.getInt("multiplier").intValue(), showLabels));
                break;
            }
        }
        if ((settings & 0x40) > 0) {
            this.addOnOff(result, reader.getBoolean("active"));
        }
        return result;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<PanelSetting> getSettingsList() {
        ArrayList<PanelSetting> result = new ArrayList<PanelSetting>(7);
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelOutput", (Object[])new Object[0]), 1, this.damage));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelBuffer", (Object[])new Object[0]), 2, this.damage));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelStorage", (Object[])new Object[0]), 4, this.damage));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelCapacity", (Object[])new Object[0]), 8, this.damage));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelItems", (Object[])new Object[0]), 16, this.damage));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelMultiplier", (Object[])new Object[0]), 32, this.damage));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelOnOff", (Object[])new Object[0]), 64, this.damage));
        return result;
    }

    @Override
    public int getKitFromCard() {
        return 4;
    }
}

