/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.network;

import com.zuxelus.energycontrol.EnergyControl;
import com.zuxelus.energycontrol.items.cards.ItemCardMain;
import com.zuxelus.energycontrol.items.cards.ItemCardReader;
import com.zuxelus.energycontrol.tileentities.TileEntityInfoPanel;
import io.netty.buffer.ByteBuf;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketCard
implements IMessage,
IMessageHandler<PacketCard, IMessage> {
    private int x;
    private int y;
    private int z;
    private int slot;
    private Map<String, Object> fields;
    public static final int FIELD_DOUBLE = 1;
    public static final int FIELD_INT = 2;
    public static final int FIELD_STRING = 3;
    public static final int FIELD_BOOLEAN = 4;
    public static final int FIELD_TAG = 5;
    public static final int FIELD_NULL = 6;
    public static final int FIELD_LONG = 7;

    public PacketCard() {
    }

    public PacketCard(BlockPos pos, int slot, Map<String, Object> fields) {
        this.x = pos.func_177958_n();
        this.y = pos.func_177956_o();
        this.z = pos.func_177952_p();
        this.slot = slot;
        this.fields = fields;
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.slot = buf.readInt();
        int fieldCount = buf.readShort();
        this.fields = new HashMap<String, Object>();
        block11: for (int i = 0; i < fieldCount; ++i) {
            String name = ByteBufUtils.readUTF8String((ByteBuf)buf);
            byte type = buf.readByte();
            switch (type) {
                case 2: {
                    this.fields.put(name, buf.readInt());
                    continue block11;
                }
                case 4: {
                    this.fields.put(name, buf.readBoolean());
                    continue block11;
                }
                case 7: {
                    this.fields.put(name, buf.readLong());
                    continue block11;
                }
                case 1: {
                    this.fields.put(name, buf.readDouble());
                    continue block11;
                }
                case 3: {
                    this.fields.put(name, ByteBufUtils.readUTF8String((ByteBuf)buf));
                    continue block11;
                }
                case 5: {
                    try {
                        int size = buf.readInt();
                        DataInputStream dat = new DataInputStream(new ByteArrayInputStream(Arrays.copyOfRange(buf.array(), buf.readerIndex() + 1, buf.readerIndex() + 1 + size)));
                        NBTTagCompound tag = CompressedStreamTools.func_74796_a((InputStream)dat);
                        this.fields.put(name, tag);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    continue block11;
                }
                case 6: {
                    this.fields.put(name, null);
                    continue block11;
                }
                default: {
                    EnergyControl.logger.warn("Invalid field type in PacketCard: %d", (Object)type);
                }
            }
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeInt(this.slot);
        buf.writeShort(this.fields.size());
        for (Map.Entry<String, Object> entry : this.fields.entrySet()) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)entry.getKey());
            Object value = entry.getValue();
            if (value instanceof Long) {
                buf.writeByte(7);
                buf.writeLong(((Long)value).longValue());
                continue;
            }
            if (value instanceof Double) {
                buf.writeByte(1);
                buf.writeDouble(((Double)value).doubleValue());
                continue;
            }
            if (value instanceof Integer) {
                buf.writeByte(2);
                buf.writeInt(((Integer)value).intValue());
                continue;
            }
            if (value instanceof String) {
                buf.writeByte(3);
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)((String)value));
                continue;
            }
            if (value instanceof Boolean) {
                buf.writeByte(4);
                buf.writeBoolean(((Boolean)value).booleanValue());
                continue;
            }
            if (value instanceof NBTTagCompound) {
                buf.writeByte(5);
                try {
                    ByteArrayOutputStream stream = new ByteArrayOutputStream();
                    DataOutputStream output = new DataOutputStream(stream);
                    CompressedStreamTools.func_74799_a((NBTTagCompound)((NBTTagCompound)value), (OutputStream)output);
                    buf.writeInt(stream.size());
                    buf.writeBytes(stream.toByteArray());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (value != null) continue;
            buf.writeByte(6);
        }
    }

    public IMessage onMessage(PacketCard message, MessageContext ctx) {
        TileEntity tileEntity = FMLClientHandler.instance().getClient().field_71441_e.func_175625_s(new BlockPos(message.x, message.y, message.z));
        if (tileEntity == null || !(tileEntity instanceof TileEntityInfoPanel)) {
            return null;
        }
        TileEntityInfoPanel panel = (TileEntityInfoPanel)tileEntity;
        ItemStack stack = panel.func_70301_a(message.slot);
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemCardMain)) {
            return null;
        }
        ItemCardReader reader = new ItemCardReader(stack);
        for (Map.Entry<String, Object> entry : message.fields.entrySet()) {
            String name = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Long) {
                reader.setLong(name, (Long)value);
                continue;
            }
            if (value instanceof Double) {
                reader.setDouble(name, (Double)value);
                continue;
            }
            if (value instanceof Integer) {
                reader.setInt(name, (Integer)value);
                continue;
            }
            if (value instanceof String) {
                reader.setString(name, (String)value);
                continue;
            }
            if (value instanceof Boolean) {
                reader.setBoolean(name, (Boolean)value);
                continue;
            }
            if (value instanceof NBTTagCompound) {
                reader.setTag(name, (NBTTagCompound)value);
                continue;
            }
            if (value != null) continue;
            reader.clearField(name);
        }
        panel.resetCardData();
        return null;
    }
}

