/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.tileentities;

import com.zuxelus.energycontrol.tileentities.IScreenPart;
import com.zuxelus.energycontrol.tileentities.TileEntityInfoPanel;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class Screen {
    public int minX;
    public int minY;
    public int minZ;
    public int maxX;
    public int maxY;
    public int maxZ;
    private BlockPos corePos;
    private boolean powered = false;

    public Screen(TileEntityInfoPanel panel) {
        BlockPos pos = panel.func_174877_v();
        this.maxX = this.minX = pos.func_177958_n();
        this.maxY = this.minY = pos.func_177956_o();
        this.maxZ = this.minZ = pos.func_177952_p();
        this.corePos = pos;
        this.powered = panel.getPowered();
    }

    public Screen(TileEntityInfoPanel panel, NBTTagCompound tag) {
        this.minX = tag.func_74762_e("minX");
        this.minY = tag.func_74762_e("minY");
        this.minZ = tag.func_74762_e("minZ");
        this.maxX = tag.func_74762_e("maxX");
        this.maxY = tag.func_74762_e("maxY");
        this.maxZ = tag.func_74762_e("maxZ");
        this.corePos = panel.func_174877_v();
        this.powered = panel.getPowered();
    }

    public TileEntityInfoPanel getCore(IBlockAccess world) {
        TileEntity tileEntity = world.func_175625_s(this.corePos);
        if (tileEntity == null || !(tileEntity instanceof TileEntityInfoPanel)) {
            return null;
        }
        return (TileEntityInfoPanel)tileEntity;
    }

    public boolean isBlockNearby(TileEntity tileEntity) {
        BlockPos pos = tileEntity.func_174877_v();
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        return x == this.minX - 1 && y >= this.minY && y <= this.maxY && z >= this.minZ && z <= this.maxZ || x == this.maxX + 1 && y >= this.minY && y <= this.maxY && z >= this.minZ && z <= this.maxZ || x >= this.minX && x <= this.maxX && y == this.minY - 1 && z >= this.minZ && z <= this.maxZ || x >= this.minX && x <= this.maxX && y == this.maxY + 1 && z >= this.minZ && z <= this.maxZ || x >= this.minX && x <= this.maxX && y >= this.minY && y <= this.maxY && z == this.minZ - 1 || x >= this.minX && x <= this.maxX && y >= this.minY && y <= this.maxY && z == this.maxZ + 1;
    }

    public boolean isBlockPartOf(TileEntity tileEntity) {
        BlockPos pos = tileEntity.func_174877_v();
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        return x >= this.minX && x <= this.maxX && y >= this.minY && y <= this.maxY && z >= this.minZ && z <= this.maxZ;
    }

    public void init(boolean force, World world) {
        for (int x = this.minX; x <= this.maxX; ++x) {
            for (int y = this.minY; y <= this.maxY; ++y) {
                for (int z = this.minZ; z <= this.maxZ; ++z) {
                    TileEntity tileEntity = world.func_175625_s(new BlockPos(x, y, z));
                    if (tileEntity == null || !(tileEntity instanceof IScreenPart)) continue;
                    ((IScreenPart)tileEntity).setScreen(this);
                    if (!this.powered && !force) continue;
                    ((IScreenPart)tileEntity).notifyBlockUpdate();
                }
            }
        }
    }

    public void destroy(boolean force, World world) {
        for (int x = this.minX; x <= this.maxX; ++x) {
            for (int y = this.minY; y <= this.maxY; ++y) {
                for (int z = this.minZ; z <= this.maxZ; ++z) {
                    TileEntity tileEntity = world.func_175625_s(new BlockPos(x, y, z));
                    if (tileEntity == null || !(tileEntity instanceof IScreenPart)) continue;
                    IScreenPart part = (IScreenPart)tileEntity;
                    Screen targetScreen = part.getScreen();
                    if (targetScreen != null && targetScreen.equals(this)) {
                        part.setScreen(null);
                        part.updateData();
                    }
                    if (!this.powered && !force) continue;
                    part.notifyBlockUpdate();
                }
            }
        }
    }

    public void turnPower(boolean on, World world) {
        if (this.powered == on) {
            return;
        }
        this.powered = on;
        this.markUpdate(world);
    }

    private void markUpdate(World world) {
        for (int x = this.minX; x <= this.maxX; ++x) {
            for (int y = this.minY; y <= this.maxY; ++y) {
                for (int z = this.minZ; z <= this.maxZ; ++z) {
                    TileEntity te = world.func_175625_s(new BlockPos(x, y, z));
                    if (!(te instanceof IScreenPart)) continue;
                    ((IScreenPart)te).notifyBlockUpdate();
                }
            }
        }
    }

    public NBTTagCompound toTag() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("minX", this.minX);
        tag.func_74768_a("minY", this.minY);
        tag.func_74768_a("minZ", this.minZ);
        tag.func_74768_a("maxX", this.maxX);
        tag.func_74768_a("maxY", this.maxY);
        tag.func_74768_a("maxZ", this.maxZ);
        return tag;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.corePos.func_177958_n();
        result = 31 * result + this.corePos.func_177956_o();
        result = 31 * result + this.corePos.func_177952_p();
        result = 31 * result + this.maxX;
        result = 31 * result + this.maxY;
        result = 31 * result + this.maxZ;
        result = 31 * result + this.minX;
        result = 31 * result + this.minY;
        result = 31 * result + this.minZ;
        return result;
    }

    public boolean isCore(int x, int y, int z) {
        return x == this.corePos.func_177958_n() && y == this.corePos.func_177956_o() && z == this.corePos.func_177952_p();
    }

    public int getDx() {
        return this.maxX - this.minX;
    }

    public int getDy() {
        return this.maxY - this.minY;
    }

    public int getDz() {
        return this.maxZ - this.minZ;
    }

    public boolean isOneBlock() {
        return this.minX == this.maxX && this.minY == this.maxY && this.minZ == this.maxZ;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Screen other = (Screen)obj;
        if (this.corePos.func_177958_n() != other.corePos.func_177958_n()) {
            return false;
        }
        if (this.corePos.func_177956_o() != other.corePos.func_177956_o()) {
            return false;
        }
        if (this.corePos.func_177952_p() != other.corePos.func_177952_p()) {
            return false;
        }
        if (this.maxX != other.maxX) {
            return false;
        }
        if (this.maxY != other.maxY) {
            return false;
        }
        if (this.maxZ != other.maxZ) {
            return false;
        }
        if (this.minX != other.minX) {
            return false;
        }
        if (this.minY != other.minY) {
            return false;
        }
        return this.minZ == other.minZ;
    }
}

