/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonWriter;
import com.zuxelus.energycontrol.EnergyControl;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SoundList;
import net.minecraft.client.audio.SoundListSerializer;
import net.minecraft.client.resources.FolderResourcePack;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.client.resources.SimpleReloadableResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.resource.IResourceType;
import net.minecraftforge.client.resource.ISelectiveResourceReloadListener;
import net.minecraftforge.client.resource.VanillaResourceType;

public class SoundHelper {
    private static final Gson gson = new GsonBuilder().registerTypeAdapter(SoundList.class, (Object)new SoundListSerializer()).create();
    private static File alarms;
    private static final ParameterizedType type;

    public static void initSound(File configFolder) {
        if (configFolder == null || !EnergyControl.config.useCustomSounds) {
            return;
        }
        alarms = new File(configFolder, "alarms");
        File audioLoc = new File(alarms, "assets" + File.separator + "energycontrol" + File.separator + "sounds");
        if (!alarms.exists()) {
            try {
                alarms.mkdir();
                audioLoc.mkdirs();
                SoundHelper.buildJSON();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void importSound() {
        EnergyControl.instance.availableAlarms = new ArrayList<String>();
        try {
            List list = Minecraft.func_71410_x().func_110442_L().func_135056_b(new ResourceLocation("energycontrol", "sounds.json"));
            for (int i = list.size() - 1; i >= 0; --i) {
                IResource iresource = (IResource)list.get(i);
                try {
                    Map map = (Map)gson.fromJson((Reader)new InputStreamReader(iresource.func_110527_b()), (Type)type);
                    for (Map.Entry entry : map.entrySet()) {
                        EnergyControl.instance.availableAlarms.add(((String)entry.getKey()).replace("alarm-", ""));
                    }
                    continue;
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void buildJSON() throws IOException {
        JsonWriter parse = new JsonWriter((Writer)new FileWriter(alarms.getAbsolutePath() + File.separator + "assets" + File.separator + "energycontrol" + File.separator + "sounds.json"));
        parse.beginObject();
        parse.name("_comment").value("EXAMPLE 'alarm-name': {'category': 'master','sounds': [{'name': 'energycontrol:alarm-name','stream': true}]}");
        parse.endObject();
        parse.close();
    }

    static {
        type = new ParameterizedType(){
            private static final String __OBFID = "CL_00001148";

            @Override
            public Type[] getActualTypeArguments() {
                return new Type[]{String.class, SoundList.class};
            }

            @Override
            public Type getRawType() {
                return Map.class;
            }

            @Override
            public Type getOwnerType() {
                return null;
            }
        };
    }

    public static class SoundLoader
    implements ISelectiveResourceReloadListener {
        public void onResourceManagerReload(IResourceManager resourceManager, Predicate<IResourceType> resourcePredicate) {
            if (resourcePredicate.test((IResourceType)VanillaResourceType.SOUNDS) && resourceManager instanceof SimpleReloadableResourceManager && alarms != null) {
                FolderResourcePack pack = new FolderResourcePack(alarms);
                ((SimpleReloadableResourceManager)resourceManager).func_110545_a((IResourcePack)pack);
            }
        }
    }
}

