/*
 * Decompiled with CFR 0.152.
 */
package com.vladmarica.energymeters.network;

import com.vladmarica.energymeters.EnergyMetersMod;
import com.vladmarica.energymeters.network.BufferUtil;
import com.vladmarica.energymeters.tile.TileEntityEnergyMeterBase;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketUpdateMeterSides
implements IMessage {
    private BlockPos pos;
    @Nullable
    private EnumFacing inputSide;
    @Nullable
    private EnumFacing outputSide;

    public PacketUpdateMeterSides() {
    }

    public PacketUpdateMeterSides(BlockPos meterPos, @Nullable EnumFacing inputSide, @Nullable EnumFacing outputSide) {
        this.pos = meterPos;
        this.inputSide = inputSide;
        this.outputSide = outputSide;
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = BufferUtil.readBlockPos(buf);
        this.inputSide = BufferUtil.readNullableFace(buf);
        this.outputSide = BufferUtil.readNullableFace(buf);
    }

    public void toBytes(ByteBuf buf) {
        BufferUtil.writeBlockPos(buf, this.pos);
        BufferUtil.writeNullableFace(buf, this.inputSide);
        BufferUtil.writeNullableFace(buf, this.outputSide);
    }

    public static class Handler
    implements IMessageHandler<PacketUpdateMeterSides, IMessage> {
        public IMessage onMessage(PacketUpdateMeterSides message, MessageContext ctx) {
            BlockPos pos = message.pos;
            WorldServer world = ctx.getServerHandler().field_147369_b.func_71121_q();
            world.func_152344_a(() -> {
                if (!world.func_175667_e(pos)) {
                    EnergyMetersMod.LOGGER.error("Recieved PacketUpdateMeterSides for unloaded position {}", (Object)pos);
                    return;
                }
                TileEntity tile = world.func_175625_s(pos);
                if (tile instanceof TileEntityEnergyMeterBase) {
                    ((TileEntityEnergyMeterBase)tile).handleSideUpdateRequest(message.inputSide, message.outputSide);
                    EnergyMetersMod.LOGGER.info("Recieved PacketUpdateMeterSides for {}", (Object)pos);
                } else {
                    EnergyMetersMod.LOGGER.error("Recieved PacketUpdateMeterSides for position with no TE: {}", (Object)pos);
                }
            });
            return null;
        }
    }
}

